package Sct.IS;
import Sct.*;
import java.io.IOException;
import java.io.InvalidClassException;

public class ObjectManagerIS extends AbstractObjectManager {
    private static ObjectManagerIS instance;
    static {
        instance = new ObjectManagerIS();
    }
    
    protected ObjectManagerIS() {}
    
    public static ObjectManagerIS getInstance() {
        return instance;
    }
    
    
    public Serializable readObject(String uniqueID, String className) throws IOException{
        ISObject o = new ISObject(className);
        NameIS name = new NameIS(className, uniqueID);
        is.Repository r = SctNames.getISRepository();
        try {
            r.getValue(name.getName(),  o);
        } catch (RuntimeException re) {
            IOException e = new IOException("IS Exception trying to read " + name.getName());
            e.initCause(re);
            throw e;
        }
        
        return o.s;
    }
    
    public Name writeObject(Serializable object) throws IOException{
        ISObject o = new ISObject(object);
        is.Repository r = SctNames.getISRepository();
        NameIS name = new NameIS(object);
        try {
            r.insert(name.getName(),  o);
        } catch (RuntimeException re) {
            IOException e = new IOException("IS Exception trying to write " + name.getName());
            e.initCause(re);
            throw e;
        }
        return name;
    }
    
    public Serializable readObject(String name) throws IOException{
        is.Repository r = SctNames.getISRepository();
                
        try {
	    NameIS nameIS = new NameIS(name);
            ISObject o = new ISObject(nameIS.getClassName());        
            r.getValue(name, o);            
            return o.s;
            
        } catch (IllegalArgumentException iae) {
            is.AnyInfo any = new is.AnyInfo();            
            try {
                r.getValue(name, any);
                return new AnyInfoAdapter(any);
            } catch (RuntimeException re) {
                IOException e = new IOException("IS Exception trying to read " + name);
                e.initCause(re);
                throw e;
            }            
        } catch (RuntimeException re) {
            IOException e = new IOException("IS Exception trying to read " + name);
            e.initCause(re);
            throw e;
        }
                
    }    
    
    
    protected class ISObject extends is.Info {
        protected boolean bInConstructor = true;
        Serializable s;
        
        /**
         * Used for publishing
         */
        ISObject(Serializable s) {
            super(s.getClassName());
            this.s = s;
            bInConstructor = false;            
        }
        
        /**
         * Used for reading
         */
        ISObject(String typename) {
            super(typename);
            bInConstructor = false;            
        }
                
        public void publishGuts(is.Ostream out) {
            if (bInConstructor) return;
            super.publishGuts(out);
            try {
                OStreamIS outIS = new OStreamIS(out);
                writeClassName(outIS, s.getClassName());
                s.write(outIS,  ObjectManagerIS.getInstance());
            } catch (IOException e) {
                e.printStackTrace();
                return;
            }
        }
        public void refreshGuts(is.Istream in) {
            super.refreshGuts(in);
            ///@todo Think about exceptions here
            try {
                IStreamIS inIS = new IStreamIS(in);
                s = (Serializable)ObjectManagerIS.getInstance().createObject(inIS, readClassName(inIS));
	    } catch (InvalidClassException e) {                
                IllegalArgumentException ie = new IllegalArgumentException();
                ie.initCause(e);
                throw ie;
            } catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }
    }
}
