package Sct.IS;

import java.util.*;
import Sct.*;

public class NameIS extends Name {
    protected String ISServer;
    
    public NameIS(Serializable s) {
        super(s);
        ISServer = SctNames.getISServer(className);
    }
    
    public NameIS(String name) throws IllegalArgumentException {
        super(name);        
    }
    
    public NameIS(String className, String uniqueID) {
        super(className, uniqueID);
        ISServer = SctNames.getISServer(className);
    }
    
    public String getName() {
        return ISServer + "." + convertToC(className) + "." + uniqueID;
    }
    
    public String getISServer() {
        return ISServer;
    }
    
    /*
     * Format: <ISServer>.<ClassName>.<UniqueID>
     */
    protected void parse(String name) throws IllegalArgumentException {
	try {
	    StringTokenizer st = new StringTokenizer(name, ".", false);
	    
	    ISServer = st.nextToken();
	    className = convertFromC(st.nextToken());
	    uniqueID = st.nextToken("").substring(1); //Make sure initial . is removed            
	} catch (NoSuchElementException e) {
	    IllegalArgumentException iae = new IllegalArgumentException("NameIS cannot parse IS name - doesn't match expected format: " + name);   
	    iae.initCause(e);
	    throw iae;
	}
    }    
    
}

