package Sct.IS;

import java.lang.reflect.Array;
import is.AnyInfo;
import Sct.*;

public class AnyInfoAdapter implements Sct.Serializable {
    
    public AnyInfoAdapter(AnyInfo a) {
        any = a;
    }
    
    public AnyInfoAdapter() {
        any = new AnyInfo();
    }
    
    public AnyInfo getInfo() {
        return any;
    }
    
    public String getClassName() {
        return any.getType().getName();
    }    
    
    public String getUniqueID() {
        return new NameIS(any.getName()).getUniqueID();
    }
    
    public void read(IStream s, ObjectManager o) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("AnyInfoAdapter can only write AnyInfo objects - can't read into them!");
    }
    
    public void write(OStream s, ObjectManager o) throws java.io.IOException {
        for (int i=0; i<any.getAttributeCount(); ++i) {
           write(s, any.getAttributeTypeName(i),  any.getAttribute(i));
        }
    }
    
    /*
     * Trys casting to the various possiblities...
     */
    private void write(OStream s, String name, Object o) throws java.io.IOException {
        if (o.getClass().isArray()) {
            writeArray(s, name, o);
            return;
        }
        
        if (o instanceof Boolean) {
            s.writeBoolean(name,  ((Boolean)o).booleanValue());
            return;
        }
        
        if (o instanceof Byte) {
            s.writeByte(name,  ((Byte)o).byteValue(), true);
            return;
        }
        
        if (o instanceof Short) {
            s.writeShort(name, ((Short)o).shortValue(), true);
            return;
        }
        
        if (o instanceof Integer) {
            s.writeInt(name, ((Integer)o).intValue(), true);
            return;
        }
        
        if (o instanceof Float) {
            s.writeFloat(name, ((Float)o).floatValue());
            return;
        }
        
        if (o instanceof Double) {
            s.writeDouble(name,  ((Double)o).doubleValue());
            return;
        }
        
        if (o instanceof String) {
            s.writeString(name, (String)o);
            return;
        }
        
        s.writeString(name, o.toString());
    }
    
    private void writeArray(OStream s, String name, Object o) throws java.io.IOException {
        Class c = o.getClass().getComponentType();
        int length = Array.getLength(o);
        
        if (c==Boolean.class) {
            boolean[] array = new boolean[length];
            for (int i=0; i<length; ++i) array[i] = ((Boolean)Array.get(o, i)).booleanValue();
            s.writeBooleanArray(name, array);
            return;
        }
        
        if (c==Byte.class) {
            byte[] array = new byte[length];
            for (int i=0; i<length; ++i) array[i] = ((Byte)Array.get(o, i)).byteValue();
            s.writeByteArray(name, array, true);
            return;
        }
        
        if (c==Short.class) {
            short[] array = new short[length];
            for (int i=0; i<length; ++i) array[i] = ((Short)Array.get(o, i)).shortValue();
            s.writeShortArray(name, array, true);
            return;
        }
        
        if (c==Integer.class) {
            int[] array = new int[length];
            for (int i=0; i<length; ++i) array[i] = ((Integer)Array.get(o, i)).intValue();
            s.writeIntArray(name, array, true);
            return;
        }
                
        if (c==Float.class) {
            float[] array = new float[length];
            for (int i=0; i<length; ++i) array[i] = ((Float)Array.get(o, i)).floatValue();
            s.writeFloatArray(name, array);
            return;
        }
        
        if (c==Double.class) {
            double[] array = new double[length];
            for (int i=0; i<length; ++i) array[i] = ((Double)Array.get(o, i)).doubleValue();
            s.writeDoubleArray(name, array);
            return;
        }
        
        if (c==String.class) {
            String[] array = new String[length];
            for (int i=0; i<length; ++i) array[i] = (String)Array.get(o, i);
            s.writeStringArray(name, array);
            return;
        }
        
        ///@todo Currently fails silently for other array types
    }
    
    private AnyInfo any;
}