/*
 * ObjectManagerFile.java
 *
 * Created on 29 October 2003, 14:54
 */

package Sct.File;
import Sct.*;

/**
 * The ObjectManager reads from binary files.
 * It should use exactly the same format as the C++ code!
 * @author Matthew Palmer
 */
public class ObjectManagerFile extends AbstractObjectManager {
    
    /**
     * Get the global instance of the File IO Manager
     */
    public static ObjectManagerFile getInstance() {
        if (instance == null)
            instance = new ObjectManagerFile();
        return instance;
    }
    
    /**
     * Read an object from a raw byte[]  Useful for passing structures around over IPC!
     */
    public Streamable readObject(byte[] data, String className) throws java.io.IOException {
        IStreamFile s = new IStreamFile(data);
        return this.createObject(s, className);
    }
    
    public Serializable readObject(String name) throws java.io.IOException {        
        IStreamFile s = new IStreamFile(new NameFile(name));
        return (Serializable)this.createObject(s, readClassName(s));
    }    

    public Serializable readObject(String uniqueID, String className) throws java.io.IOException {
        return readObject(new NameFile(uniqueID, className).getName());
    }
    
    public Name writeObject(Serializable object) throws java.io.IOException {
        NameFile name = new NameFile(object);
        OStreamFile s = new OStreamFile(name);
        writeClassName(s, object.getClassName());
        object.write(s, this);
        s.close();
        return name;
    }
    
    private ObjectManagerFile() {}
    private static ObjectManagerFile instance;
}
