/*
 * IStreamFile.java
 *
 * Created on 29 October 2003, 15:17
 */

package Sct.File;

import java.io.*;
import java.nio.*;
import java.nio.channels.FileChannel;

/**
 *
 * @author  Matthew Palmer
 */
public class IStreamFile implements Sct.IStream {
    
    /** Creates a new instance of IStreamFile */
    public IStreamFile(NameFile name) throws IOException {
        FileChannel fc = new FileInputStream(name.getName()).getChannel();
        buffer = ByteBuffer.allocate((int)fc.size());
        fc.read(buffer);
        fc.close();
        buffer.position(0);
        buffer.order(ByteOrder.nativeOrder());
    }
    
    /**
     * Creates an IStreamFile that reads from a byte[]
     * rather than a file directly.
     */
    public IStreamFile(byte[] input) {
        buffer = ByteBuffer.wrap(input);
        buffer.position(0);
        buffer.order(ByteOrder.nativeOrder());
    }
    
    public boolean readBoolean(String name) throws java.io.IOException {
        if (buffer.get() == 0) return false;
        else return true;
    }
    
    public boolean[] readBooleanArray(String name) throws java.io.IOException {
        int size = buffer.getInt();
        boolean[] bools = new boolean[size];
        for (int i=0; i<size; ++i) {
            if (buffer.get() == 0) bools[i] = false;
            else bools[i] = true;
        }
        return bools;
    }
    
    public byte readByte(String name) throws java.io.IOException {
        return buffer.get();
    }
    
    public byte[] readByteArray(String name) throws java.io.IOException {
        int size = buffer.getInt();
        byte[] bytes = new byte[size];
        buffer.get(bytes);
        return bytes;
    }
    
    public double readDouble(String name) throws java.io.IOException {
        return buffer.getDouble();
    }
    
    public double[] readDoubleArray(String name) throws java.io.IOException {
        int size = buffer.getInt();
        double[] doubles = new double[size];
        buffer.position(buffer.position() + buffer.asDoubleBuffer().get(doubles).position() * 8);
        return doubles;
    }
    
    public float readFloat(String name) throws java.io.IOException {
        return buffer.getFloat();
    }
    
    public float[] readFloatArray(String name) throws java.io.IOException {
        int size = buffer.getInt();        
        float[] floats = new float[size];
        buffer.position(buffer.position() + buffer.asFloatBuffer().get(floats).position() * 4);
        return floats;
    }
    
    public int readInt(String name) throws java.io.IOException {
        return buffer.getInt();
    }
    
    public int[] readIntArray(String name) throws java.io.IOException {
        int size = buffer.getInt();
        int[] ints = new int[size];
        buffer.position(buffer.position() + buffer.asIntBuffer().get(ints).position() * 4);
        return ints;
    }
    
    public long readLong(String name) throws java.io.IOException {
        return buffer.getLong();
    }
    
    public long[] readLongArray(String name) throws java.io.IOException {
        int size = buffer.getInt();        
        long[] longs = new long[size];
        buffer.position(buffer.position() + buffer.asLongBuffer().get(longs).position() * 8);
        return longs;
    }
    
    public short readShort(String name) throws java.io.IOException {
        return buffer.getShort();
    }
    
    public short[] readShortArray(String name) throws java.io.IOException {
        int size = buffer.getInt();        
        short[] shorts = new short[size];
        buffer.position(buffer.position() + buffer.asShortBuffer().get(shorts).position() * 2);
        return shorts;
    }
    
    public String readString(String name) throws java.io.IOException {
        int size = buffer.getInt();        
        byte[] bytes = new byte[size - 1];
        buffer.get(bytes);
        buffer.get();   //Throw away null
        return new String(bytes);
    }
    
    public String[] readStringArray(String name) throws java.io.IOException {
        int size = buffer.getInt();
        String[] strings = new String[size];
        for (int i=0; i<size; ++i) {
            strings[i] = readString("");
        }
        return strings;
    }
    
    /**
     * Ensures that b's position is the same as a's
     */
    private void align(Buffer a, Buffer b) {
        b.position(a.position());
    }
        
    private ByteBuffer buffer;
}
