#include "Sct/Env.h"
#include "Env_Test.h"
#include <cstdlib>

#include <boost/test/unit_test.hpp>

using boost::unit_test_framework::test_suite;

namespace Sct {

void testSubstitute(string subst, string compare) {
    BOOST_CHECK_EQUAL(compare, Env::substituteVariables(subst));
}

void testSubstituteVariable1() {
    testSubstitute("aaa${TEST_VAR}bbb", "aaaTest Variablebbb");
}

void testSubstituteVariable2() {
    testSubstitute("${WIBBLE}", "${WIBBLE}");
}

void testSubstituteVariable3() {
    testSubstitute("${WIBBLE}wererg${TEST_VAR}dsf", "${WIBBLE}werergTest Variabledsf");
}

void testSubstituteVariable4() {
    testSubstitute("aaa${TEST_VAR}wererg${WIBBLE}dsf", "aaaTest Variablewererg${WIBBLE}dsf");
}

void testSubstituteVariable5() {
    testSubstitute("A Test ${TEST_VAR}: (lots of money! $$$)", "A Test Test Variable: (lots of money! $$$)");
}


Env_Test::Env_Test() {
    setenv("TEST_VAR", "Test Variable", 1);
    add(BOOST_TEST_CASE(&testSubstituteVariable1));
    add(BOOST_TEST_CASE(&testSubstituteVariable2));
    add(BOOST_TEST_CASE(&testSubstituteVariable3));
    add(BOOST_TEST_CASE(&testSubstituteVariable4));
    add(BOOST_TEST_CASE(&testSubstituteVariable5));
}

}
