/*
 * TestOStream.java
 *
 * Created on 16 September 2003, 10:35
 */

package Sct.TestFramework;
import Sct.*;
import java.io.IOException;


/**
 *
 * @author  palmer
 */
public class TestOStream implements OStream {
    
    private TestStreamData data = new TestStreamData();
    
    /** Creates a new instance of TestOStream */
    public TestOStream() {
    }
    
    public TestStreamData getData() {
        return data;
    }    
    
    public void writeBoolean(String name, boolean b) throws IOException {
        data.add(name, new Boolean(b));
    }
    
    public void writeBooleanArray(String name, boolean[] b) throws IOException {
        data.add(name, b);
    }
    
    public void writeByte(String name, byte b, boolean sign) throws IOException {
        data.add(name, new Byte(b));
    }
    
    public void writeByteArray(String name, byte[] b, boolean sign) throws IOException {
        data.add(name, b);
    }
    
    public void writeDouble(String name, double d) throws IOException {
        data.add(name, new Double(d));
    }
    
    public void writeDoubleArray(String name, double[] d) throws IOException {
        data.add(name, d);
    }
    
    public void writeFloat(String name, float f) throws IOException {
        data.add(name, new Float(f));
    }
    
    public void writeFloatArray(String name, float[] f) throws IOException {
        data.add(name, f);
    }
    
    public void writeInt(String name, int i, boolean sign) throws IOException {
        data.add(name, new Integer(i));
    }
    
    public void writeIntArray(String name, int[] i, boolean sign) throws IOException {
        data.add(name, i);
    }
    
    public void writeLong(String name, long i, boolean sign) throws IOException {
        data.add(name, new Long(i));
    }
    
    public void writeLongArray(String name, long[] l, boolean sign) throws IOException {
        data.add(name, l);
    }
    
    public void writeShort(String name, short s, boolean sign) throws IOException {
        data.add(name, new Short(s));
    }
    
    public void writeShortArray(String name, short[] s, boolean sign) throws IOException {
        data.add(name, s);
    }
    
    public void writeString(String name, String s) throws IOException {
        data.add(name, s);
    }
    
    public void writeStringArray(String name, String[] s) throws IOException {
        data.add(name, s);
    }
    
}
