/*
 * TestIStream.java
 *
 * Created on 16 September 2003, 10:20
 */

package Sct.TestFramework;
import Sct.*;
import java.io.IOException;

/**
 *
 * @author  palmer
 */
public class TestIStream implements IStream {
    
    private TestStreamData data;
    
    /** Creates a new instance of TestIStream */
    public TestIStream(TestStreamData data) {
        this.data = data;
    }
    
    public boolean readBoolean(String name) throws java.io.IOException {
        Object d = data.get(name);
        if (d instanceof Boolean) {
            return ((Boolean)d).booleanValue();
        } else {        
            String message = "Could not read a boolean\nName: " + name + "\nClass: " + d.getClass()
                             + "\nValue: " + d;
            throw new IOException(message);
        }
    }
    
    public boolean[] readBooleanArray(String name) throws java.io.IOException {
        Object d = data.get(name);
        if (d instanceof boolean[]) {
            return ((boolean[])d);
        } else {        
            String message = "Could not read a boolean[]\nName: " + name + "\nClass: " + d.getClass()
                             + "\nValue: " + d;
            throw new IOException(message);
        }
    }
    
    public byte readByte(String name) throws java.io.IOException {
        Object d = data.get(name);
        if (d instanceof Byte) {
            return ((Byte)d).byteValue();
        } else {        
            String message = "Could not read a byte\nName: " + name + "\nClass: " + d.getClass()
                             + "\nValue: " + d;
            throw new IOException(message);
        }
    }
    
    public byte[] readByteArray(String name) throws java.io.IOException {
        Object d = data.get(name);
        if (d instanceof byte[]) {
            return (byte[])d;
        } else {        
            String message = "Could not read a byte[]\nName: " + name + "\nClass: " + d.getClass()
                             + "\nValue: " + d;
            throw new IOException(message);
        }
    }
    
    public double readDouble(String name) throws java.io.IOException {
        Object d = data.get(name);
        if (d instanceof Double) {
            return ((Double)d).doubleValue();
        } else {        
            String message = "Could not read a double\nName: " + name + "\nClass: " + d.getClass()
                             + "\nValue: " + d;
            throw new IOException(message);
        }
    }
    
    public double[] readDoubleArray(String name) throws java.io.IOException {
        Object d = data.get(name);
        if (d instanceof double[]) {
            return ((double[])d);
        } else {        
            String message = "Could not read a double[]\nName: " + name + "\nClass: " + d.getClass()
                             + "\nValue: " + d;
            throw new IOException(message);
        }
    }
    
    public float readFloat(String name) throws java.io.IOException {
        Object d = data.get(name);
        if (d instanceof Float) {
            return ((Float)d).floatValue();
        } else {        
            String message = "Could not read a float\nName: " + name + "\nClass: " + d.getClass()
                             + "\nValue: " + d;
            throw new IOException(message);
        }
    }
    
    public float[] readFloatArray(String name) throws java.io.IOException {
        Object d = data.get(name);
        if (d instanceof float[]) {
            return ((float[])d);
        } else {        
            String message = "Could not read a float[]\nName: " + name + "\nClass: " + d.getClass()
                             + "\nValue: " + d;
            throw new IOException(message);
        }
    }
    
    public int readInt(String name) throws java.io.IOException {
        Object d = data.get(name);
        if (d instanceof Integer) {
            return ((Integer)d).intValue();
        } else {        
            String message = "Could not read an int\nName: " + name + "\nClass: " + d.getClass()
                             + "\nValue: " + d;
            throw new IOException(message);
        }
    }
    
    public int[] readIntArray(String name) throws java.io.IOException {
        Object d = data.get(name);
        if (d instanceof int[]) {
            return ((int[])d);
        } else {        
            String message = "Could not read an int[]\nName: " + name + "\nClass: " + d.getClass()
                             + "\nValue: " + d;
            throw new IOException(message);
        }
    }
    
    public long readLong(String name) throws java.io.IOException {
        Object d = data.get(name);
        if (d instanceof Long) {
            return ((Long)d).longValue();
        } else {        
            String message = "Could not read a long\nName: " + name + "\nClass: " + d.getClass()
                             + "\nValue: " + d;
            throw new IOException(message);
        }
    }
    
    public long[] readLongArray(String name) throws java.io.IOException {
        Object d = data.get(name);
        if (d instanceof long[]) {
            return ((long[])d);
        } else {        
            String message = "Could not read a long[]\nName: " + name + "\nClass: " + d.getClass()
                             + "\nValue: " + d;
            throw new IOException(message);
        }
    }
    
    public short readShort(String name) throws java.io.IOException {
        Object d = data.get(name);
        if (d instanceof Short) {
            return ((Short)d).shortValue();
        } else {        
            String message = "Could not read a short\nName: " + name + "\nClass: " + d.getClass()
                             + "\nValue: " + d;
            throw new IOException(message);
        }
    }
    
    public short[] readShortArray(String name) throws java.io.IOException {
        Object d = data.get(name);
        if (d instanceof short[]) {
            return ((short[])d);
        } else {        
            String message = "Could not read a short[]\nName: " + name + "\nClass: " + d.getClass()
                             + "\nValue: " + d;
            throw new IOException(message);
        }
    }
    
    public String readString(String name) throws java.io.IOException {
        Object d = data.get(name);
        if (d instanceof String) {
            return ((String)d);
        } else {        
            String message = "Could not read a String\nName: " + name + "\nClass: " + d.getClass()
                             + "\nValue: " + d;
            throw new IOException(message);
        }
    }
    
    public String[] readStringArray(String name) throws java.io.IOException {
        Object d = data.get(name);
        if (d instanceof String[]) {
            return ((String[])d);
        } else {        
            String message = "Could not read a String[]\nName: " + name + "\nClass: " + d.getClass()
                             + "\nValue: " + d;
            throw new IOException(message);
        }
    }
    
}
