/*
 * DataCompareTest.java
 *
 * Created on 19 September 2003, 17:01
 */

package Sct.TestFramework.Test;

import Sct.TestFramework.DataCompare;
import junit.framework.*;
import java.util.*;

/**
 *
 * @author  palmer
 */
public class DataCompareTest extends TestCase {
    
    static {
        //DataCompare.debug = true;
    }
    
    
    private Ob2 o1;
    private Ob2 o2;
    
    protected void setUp() {
        o1 = new Ob2();
        o2 = new Ob2();
    }
    
    public void testCompare() {        
        myAssertTrue(DataCompare.compare(o1, o2));
    }
    
    public void testPrivateChange() {
        o2.change();
        assertFalse(DataCompare.compare(o1, o2));
    }

    public void testPrimitiveArrayChange() {
        o2.floatArr[2] = 7.f;
        assertFalse(DataCompare.compare(o1, o2));
    }
    
    public void testObjectArrayChange() {
        o2.ob3.ob1Arr[2].bool1 = false;
        assertFalse(DataCompare.compare(o1, o2));
    }       
    
    public void testIgnoreObject() throws java.lang.NoSuchFieldException {
        o2.ob3.objectArr = null;
        HashSet set = new HashSet();
        set.add(Ob2.class.getDeclaredField("ob3"));
        myAssertTrue(DataCompare.compare(o1,o2,set));
    }
    
    public void testIgnorePrimitive() throws java.lang.NoSuchFieldException {
        o2.ob3.ob1Arr[1].int1 = 5;
        HashSet set = new HashSet();
        set.add(Ob1.class.getDeclaredField("int1"));
        myAssertTrue(DataCompare.compare(o1,o2,set));
    }
    
    public void testIgnoreArray() throws java.lang.NoSuchFieldException {
        o2.floatArr[2] = 5.f;
        HashSet set = new HashSet();        
        set.add(Ob2.class.getDeclaredField("floatArr"));
        myAssertTrue(DataCompare.compare(o1,o2,set));
    }
    
    public void testCompareArrays() {
        int[] arr1 = {1,2,3,4};
        int[] arr2 = {5,6,7,8};
        int[] arr3 = {9,10,11};
        String[] strs = {"One", "Two", "Three"};
        myAssertTrue(DataCompare.compare(arr1, arr1));
        assertFalse(DataCompare.compare(arr1, arr2));
        assertFalse(DataCompare.compare(arr1, arr3));
        myAssertTrue(DataCompare.compare(strs, strs));
    }
    
    public void myAssertTrue(boolean bool) {
        if (!bool) fail(DataCompare.lastFailure.toString());
    }
        
}

class Ob1 {
    int int1;
    boolean bool1;
    int[] intArr = null;
    Object object1 = null;

    Ob1() {
        int1 = 10;
        bool1 = true;
    }
}

class Ob2 extends Ob1 {
    private int int1;
    double double1;
    Ob3 ob3;
    float[] floatArr = {10.f, 7.f, 9.f};
    List l = new ArrayList();

    Ob2() {
        int1 = 2;
        ob3 = new Ob3();
        l.add(new Ob3());
        l.add(new Ob1());
        l.add(new String());
        l.add(new Integer(10));
    }

    void change() {
        int1 = 10;
    }
}

class Ob3 {
    Object[] objectArr = null;
    Ob1[] ob1Arr;
    intOb intOb1 = new intOb();

    Ob3() {
        ob1Arr = new Ob1[4];
        for (int i=0; i<ob1Arr.length-1; ++i) {
            ob1Arr[i] = new Ob1();
        }            
    }
    
    private class intOb {
        double d1 = 10;
    }
}

