/*
 * StreamableTestCase.java
 *
 * Created on 16 September 2003, 14:17
 */

package Sct.TestFramework;
import junit.framework.*;
import Sct.*;
import Sct.File.*;

/**
 * A special sort of TestCase for classes that implement the Streamable interface.
 * This will test their read and write methods.
 * @author  Matthew Palmer
 */
public abstract class StreamableTestCase extends TestCase {
    
    /**
     * This class should return a Streamable of the appropriate
     * type to be tested.
     */
    public abstract Streamable getStreamable();
        
    protected boolean compare(Object o1, Object o2) throws java.lang.NoSuchFieldException {
        boolean ret = DataCompare.compare(o1, o2);
        if (!ret) fail(DataCompare.lastFailure.toString());
        return ret;
    }
    
    /**
     * The test.
     */
    public void testStreamable() throws java.io.IOException, java.lang.NoSuchFieldException {
        //Write
        Streamable s1 = getStreamable();
        TestObjectManager manager = new TestObjectManager();
        manager.writeStreamable(s1);
        
        //Read
        Streamable s2 = manager.readStreamable();
        assertTrue(compare(s1, s2));
    }
    
    public void testViaFile() throws java.io.IOException, java.lang.NoSuchFieldException  {
        //Write
        Streamable s1 = getStreamable();
        SerializableWrapper sw = new SerializableWrapper(s1);
        ObjectManagerFile manager = ObjectManagerFile.getInstance();        
        Name name = manager.writeObject(sw);        
        
        //Read        
        Streamable s2 = ((SerializableWrapper)manager.readObject(name.getName())).get();
        assertTrue(compare(s1, s2));
        
        new java.io.File(name.getName()).delete();
    }        
}

