/*
 * NameISTest.java
 *
 * Created on 30 October 2003, 09:50
 */

package Sct.IS;

import junit.framework.*;

/**
 * @author palmer
 */
public class NameISTest extends TestCase {
    
    
    
    public void testSerializableConstructor() {
        NameIS nf1 = new NameIS(new SerializableDummy());
        compare(nf1);
    }
    
    public void testStringsConstructor() {
        NameIS nf1 = new NameIS("Sct.IS.SerializableDummy", "SomeUniqueID.1.2.3");
        compare(nf1);
    }
    
    public void testISNameConstructor() {
        NameIS nf1 = new NameIS("Default.Sct::IS::SerializableDummy.SomeUniqueID.1.2.3");
        compare(nf1);
    }
    
    private void compare(NameIS nf1) {        
        assertEquals("Sct.IS.SerializableDummy", nf1.getClassName());
        assertEquals("SomeUniqueID.1.2.3", nf1.getUniqueID());
        assertEquals("Default", nf1.getISServer());
        assertEquals("Default.Sct::IS::SerializableDummy.SomeUniqueID.1.2.3", nf1.getName());
    }
    
    
    //Note - breaks static read contract
    private class SerializableDummy implements Sct.Serializable {
        
        public String getClassName() {
            return "Sct.IS.SerializableDummy";
        }
        
        public String getUniqueID() {
            return "SomeUniqueID.1.2.3";
        }
        
        public void write(Sct.OStream s, Sct.ObjectManager o) throws java.io.IOException {
            //Do nothing of course!
        }
        
    }
}
