/*
 * StreamTest.java
 *
 * Created on 30 October 2003, 11:55
 */

package Sct.File;

import junit.framework.*;
import Sct.TestFramework.DataCompare;

/**
 * Tests the Sct.File.{I,O}Stream classes
 * @author  palmer
 */
public class StreamTest extends TestCase {
    
    public void testByte() throws java.io.IOException {
        byte outVal = 3;
        byte[] outVals = {(byte)3,(byte)6,(byte)27,(byte)199};
        startWrite("Byte");
        out.writeByte("Byte", outVal, true);
        out.writeByteArray("Bytes", outVals, true);
        endWrite("Byte");
        byte inVal = in.readByte("Byte");
        byte[] inVals = in.readByteArray("Bytes");
        assertEquals(outVal, inVal);
        boolean ret = DataCompare.compare(outVals, inVals);
        if (!ret) fail(DataCompare.lastFailure.toString());
    }
    
    public void testInt() throws java.io.IOException {
        int outVal = 5;
        int[] outVals = {3,65,7,9};
        startWrite("Int");
        out.writeInt("Int", outVal, true);
        out.writeIntArray("Ints", outVals, true);
        endWrite("Int");
        int inVal = in.readInt("Int");
        int[] inVals = in.readIntArray("Ints");
        assertEquals(outVal, inVal);
        boolean ret = DataCompare.compare(outVals, inVals);
        if (!ret) fail(DataCompare.lastFailure.toString());
    }
    
    public void testLong() throws java.io.IOException {
        long outVal = 10;
        long[] outVals = {302,565,77,899};
        startWrite("Long");
        out.writeLong("Long", outVal, true);
        out.writeLongArray("Longs", outVals, true);
        endWrite("Long");
        long inVal = in.readLong("Long");
        long[] inVals = in.readLongArray("Long");
        assertEquals(outVal, inVal);
        boolean ret = DataCompare.compare(outVals, inVals);
        if (!ret) fail(DataCompare.lastFailure.toString());
    }
    
    public void testShort() throws java.io.IOException {
        short outVal = 1;
        short[] outVals = {32,635,427,97};
        startWrite("Short");
        out.writeShort("Short", outVal, true);
        out.writeShortArray("Shorts", outVals, true);
        endWrite("Short");
        short inVal = in.readShort("Short");
        short[] inVals = in.readShortArray("Short");
        assertEquals(outVal, inVal);
        boolean ret = DataCompare.compare(outVals, inVals);
        if (!ret) fail(DataCompare.lastFailure.toString());
    }        
    
    public void testFloat() throws java.io.IOException {
        float outVal = 55.7f;
        float[] outVals = {23.3f,65.53f,7.2f,97.1f};
        startWrite("Float");
        out.writeFloat("Float", outVal);
        out.writeFloatArray("Floats", outVals);
        endWrite("Float");
        float inVal = in.readFloat("Float");
        float[] inVals = in.readFloatArray("Floats");
        assertEquals(outVal, inVal, 1e-10);
        boolean ret = DataCompare.compare(outVals, inVals);
        if (!ret) fail(DataCompare.lastFailure.toString());
    }
    
    public void testDouble() throws java.io.IOException {
        double outVal = 5.4;
        double[] outVals = {312.3,6565.34,7.45,9.9};
        startWrite("Double");
        out.writeDouble("Double", outVal);
        out.writeDoubleArray("Doubles", outVals);
        endWrite("Double");
        double inVal = in.readDouble("Double");
        double[] inVals = in.readDoubleArray("Doubles");
        assertEquals(outVal, inVal, 1e-10);
        boolean ret = DataCompare.compare(outVals, inVals);
        if (!ret) fail(DataCompare.lastFailure.toString());
    }
    
    public void testString() throws java.io.IOException {
        String outVal = "Wibble";
        String[] outVals = {"One","65","Hi","Ya"};
        startWrite("String");
        out.writeString("String", outVal);
        out.writeStringArray("Strings", outVals);
        endWrite("String");
        String inVal = in.readString("String");
        String[] inVals = in.readStringArray("Strings");
        assertEquals(outVal, inVal);
        boolean ret = DataCompare.compare(outVals, inVals);
        if (!ret) fail(DataCompare.lastFailure.toString());
    }
    
    public void testMixed() throws java.io.IOException {
        byte outVal = (byte)2;
        float[] outVals1 = {1.2f, 4.5f, 5.6f};
        int[] outVals = {3,7,8,2};
        String[] outVals6 = {"One","65","Hi","Ya"};
        double[] outVals2 = {2.6,54.2,65.78};
        long[] outVals3 = {324,55,76532,234};
        short[] outVals4 = {2,5,7,3};
        byte[] outVals5 = {(byte)3,(byte)6,(byte)27,(byte)199};
        String outVal2 = "Hi";        
        byte outVal1 = (byte)5;
        
        startWrite("Mixed");
        out.writeByte("Byte", outVal, true);
        out.writeFloatArray("Floats", outVals1);
        out.writeIntArray("Ints", outVals, true); 
        out.writeStringArray("Strings", outVals6);
        out.writeDoubleArray("Doubles",  outVals2);
        out.writeLongArray("Longs", outVals3, true);
        out.writeShortArray("Shorts", outVals4, true);
        out.writeByteArray("Bytes", outVals5, true);
        out.writeString("String", outVal2);
        out.writeByte("Byte", outVal1, true);
        endWrite("Mixed");
        
        byte inVal = in.readByte("Byte");
        float[] inVals1 = in.readFloatArray("Floats");
        int[] inVals = in.readIntArray("Ints");
        String[] inVals6 = in.readStringArray("Strings");
        double[] inVals2 = in.readDoubleArray("Doubles");
        long[] inVals3 = in.readLongArray("Longs");
        short[] inVals4 = in.readShortArray("Shorts");
        byte[] inVals5 = in.readByteArray("Bytes");
        String inVal2 = in.readString("String");
        byte inVal1 = in.readByte("Byte");
        
        assertEquals(outVal, inVal);
        assertEquals(outVal1, inVal1);
        assertEquals(outVal2, inVal2);
        boolean ret = DataCompare.compare(outVals, inVals);
        if (!ret) fail(DataCompare.lastFailure.toString());        
        
        ret = DataCompare.compare(outVals1, inVals1);
        if (!ret) fail(DataCompare.lastFailure.toString());        
        
        ret = DataCompare.compare(outVals2, inVals2);
        if (!ret) fail(DataCompare.lastFailure.toString());        
        
        ret = DataCompare.compare(outVals3, inVals3);
        if (!ret) fail(DataCompare.lastFailure.toString());        
        
        ret = DataCompare.compare(outVals4, inVals4);
        if (!ret) fail(DataCompare.lastFailure.toString());        
        
        ret = DataCompare.compare(outVals5, inVals5);
        if (!ret) fail(DataCompare.lastFailure.toString());        
        
        ret = DataCompare.compare(outVals6, inVals6);
        if (!ret) fail(DataCompare.lastFailure.toString());        
    }
    
    public void tearDown() {       
        String[] names = {"Byte", "Int", "Short", "Long", "Double", "Float", "String", "Mixed"};
        for (int i=0; i<names.length; ++i) {
            new java.io.File("/tmp/DummyClass.DummyUniqueID"+names[i]).delete();
        }        
    }
    
    void startWrite(String name) throws java.io.IOException {        
        out = new OStreamFile(new NameFile("/tmp/DummyClass.DummyUniqueID" + name));
    }
    
    void endWrite(String name) throws java.io.IOException {
        out.close();
        in = new IStreamFile(new NameFile("/tmp/DummyClass.DummyUniqueID" + name));
    }
        
    IStreamFile in;
    OStreamFile out;
}
