/*
 * NameFileTest.java
 *
 * Created on 30 October 2003, 09:50
 */

package Sct.File;

import junit.framework.*;

/**
 * @author palmer
 */
public class NameFileTest extends TestCase {
        
            
    public void testSerializableConstructor() {        
        NameFile nf1 = new NameFile(new SerializableDummy());
        compare(nf1);
    }
    
    public void testStringsConstructor() {
        NameFile nf1 = new NameFile("Sct.File.SerializableDummy", "SomeUniqueID.1.2.3");
        compare(nf1);
    }
    
    public void testFilenameConstructor() {
        NameFile nf1 = new NameFile(NameFile.getDefaultPath() + "/Sct::File::SerializableDummy.SomeUniqueID.1.2.3");
        compare(nf1);
    }
    
    public void testScratchDirProperty() {
        String scratchDir = "/tmp/myscratch/MyDir";
        System.getProperties().setProperty("Sct.Scratch.Dir", scratchDir);
        NameFile.reset();
        
        NameFile nf1 = new NameFile(new SerializableDummy());
        compare(nf1, scratchDir);
        
        NameFile nf2 = new NameFile("Sct.File.SerializableDummy", "SomeUniqueID.1.2.3");
        compare(nf2, scratchDir);
        
        NameFile nf3 = new NameFile(scratchDir + "/Sct::File::SerializableDummy.SomeUniqueID.1.2.3");
        compare(nf3, scratchDir);
    }
    
    private void compare(NameFile nf1) {
        compare(nf1, NameFile.getDefaultPath());
    }
    
    private void compare(NameFile nf1, String path) {
        assertEquals("Sct.File.SerializableDummy", nf1.getClassName());
        assertEquals("SomeUniqueID.1.2.3", nf1.getUniqueID());
        assertEquals(path, nf1.getPath());
        assertEquals(path + "/Sct::File::SerializableDummy.SomeUniqueID.1.2.3", nf1.getName());
    }
    
    //Note - breaks static read contract
    private class SerializableDummy implements Sct.Serializable {
        
        public String getClassName() {
            return "Sct.File.SerializableDummy";
        }
        
        public String getUniqueID() {
            return "SomeUniqueID.1.2.3";
        }
        
        public void write(Sct.OStream s, Sct.ObjectManager o) throws java.io.IOException {
            //Do nothing of course!
        }
        
    }
}
