// Test program to read a block of slave memory using the RW_SLAVE_MEMORY primitive

#include <iostream>
using namespace std;

#include <ctype.h>

#include "RodModule.h"

#include "primParams.h"
#include "RCCVmeInterface.h"
#include "parameters.h"

int main(int argc, char *argv[]) {

using namespace SctPixelRod;

  RodPrimList primList(1);                      // Primitive List
  long myTextLength;                            // Actual length of text message
  TEXT_BUFFER_TYPE myTextType;                  // Buffer type for latest message
  PrimState returnPState;
  TextBuffState returnTState;
  unsigned long numWords, startAddr;
  void* genPtr;
  char* textBuff;
  long slvNumber = -1;
  std::string fileName(""), option;
  int slot = -1;
  unsigned long baseAddress;

  if (argc > 1) {
    for (int i=1; i<argc; i++) {
      option = argv[i];
      if (option[0] != '-') break;
      switch (option[1]) {
        case 's': {
          slot = atoi(option.substr(2).c_str());
          break;
        }
        case 'v': {
          slvNumber = atoi(option.substr(2).c_str());
          break;
        }
        default: {
          break;
        }
      }
    }
  }
  
// Prompt for slot number
  if (slot < 0 ) {
    cout << "Enter slot number (decimal):"; 
    cin >> slot;
    while ((slot < 1) || (slot > 21)) {
      cout << "Slot number out or range [1:21], re-enter: ";
      cin >> slot;
    }
  }
  baseAddress = slot << 24;

// Create VME interface
  RCCVmeInterface *vme1;
  try {
    vme1 = new RCCVmeInterface();
  }
  catch (VmeException &v) {
    cout << "VmeException creating VME interface." << endl;
    cout << "ErrorClass = " << v.getErrorClass() << endl;
    cout << "ErrorCode = " << v.getErrorCode() << endl; 
  }
  
// Create RodModule but do not initialize it
  RodModule* rod0 = new RodModule(baseAddress, mapSize, *vme1, numSlaves);

// Create a buffer for text messages
  char * myTextBuffer;
  try {
    myTextBuffer= new char[TEXT_BUFF_SIZE];
  }
  catch (std::bad_alloc) {
    cout << "Unable to allocate text buffer in main.";
  }
// Create and Send RW_SLAVE_MEMORY primitive
// Get Slave number to read
  if (slvNumber < 0 ) {
    cout << "Enter slave number (0-3):"; 
    cin >> slvNumber;
    while ((slvNumber < 0) || (slvNumber > 3)) {
      cout << "Slave number out or range [0:3], re-enter: ";
      cin >> slvNumber;
    }
  }
     
  cout << "Enter starting address (hex without leading 0x):";
  cin >> hex >> startAddr;
  cout << "Enter number of data words (hex without leading 0x): ";
  cin >> hex >> numWords;
  long* primData;
  try {
    primData = new long[5];
  }
  catch (std::bad_alloc) {
    cout << "Unable to allocate echoData in main.";
  }
  
  primData[0] = slvNumber;
  primData[1] = 1;                // Read from slave, not write
  primData[2] = startAddr;
  primData[3] = DEFAULT;
  primData[4] = numWords;
  
  RodPrimitive* rwSlave;
  try {
    rwSlave= new RodPrimitive(9, 1, RW_SLAVE_MEMORY, R_RW_SLAVE_MEMORY, primData);
  }
  catch (std::bad_alloc) {
    cout << "Unable to allocate RW_SLAVE_MEMORY primitive in main.";
  }

  primList.insert(primList.begin(), *rwSlave);
  try {
    primList.bufferBuild();
  }
  catch (PrimListException &p) {
    cout << p.getDescriptor() << " ";
    cout << p.getData1() << ", " << p.getData2() << "\n";
  };
  try {
    rod0->sendPrimList(&primList);
  }
  catch (HpiException &h) {
    cout << h;
  }
  catch (VmeException &v) {
    cout << "VmeException in SendPrimList." << endl;
    cout << "ErrorClass = " << v.getErrorClass() << endl;
    cout << "ErrorCode = " << v.getErrorCode() << endl; 
  };
  delete [] primData;
  
// Wait for ROD to begin executing and then wait for it to finish executing
// Check for error messages in text buffer and read them out if they exist.
// Note: this is NOT how primHandler and textHandler will be used once we
// go to threads.  This is for debugging the code only.
  do {
    try {
      returnPState = rod0->primHandler();
    }
    catch (VmeException &v) {
      cout << "VmeException in first primHandler call." << endl;
      cout << "ErrorClass = " << v.getErrorClass() << endl;
      cout << "ErrorCode = " << v.getErrorCode() << endl; 
    }
    try {
      returnTState = rod0->textHandler();
    }
    catch (VmeException &v) {
      cout << "VmeException in first textHandler call." << endl;
      cout << "ErrorClass = " << v.getErrorClass() << endl;
      cout << "ErrorCode = " << v.getErrorCode() << endl; 
    }
    if (returnTState == TEXT_RQ_SET) {
      do {
        try {
          returnTState = rod0->textHandler();
          }
        catch (VmeException &v) {
          cout << "VmeException in second textHandler call." << endl;
          cout << "ErrorClass = " << v.getErrorClass() << endl;
          cout << "ErrorCode = " << v.getErrorCode() << endl; 
        }
      } while (returnTState != TEXT_READOUT);
      rod0->getTextBuffer(myTextBuffer, myTextLength, myTextType);
      rod0->clearTextBuffer();
      for (int i=0; i<myTextLength; i++) {
        cout << myTextBuffer[i];
        if (0==(i+1)%64) cout << endl;
        }
      cout << endl; 
    }
  } while (returnPState != PRIM_EXECUTING); 
  do {
    try {
      returnPState = rod0->primHandler();
    }
    catch (RodException &r) {
    cout << r;
    }
    catch (VmeException &v) {
      cout << "VmeException in second primHandler call." << endl;
      cout << "ErrorClass = " << v.getErrorClass() << endl;
      cout << "ErrorCode = " << v.getErrorCode() << endl; 
    }
  } while (returnPState != PRIM_WAITING); 
  
// Retrieve output buffer
  RodOutList* outList = rod0->getOutList();
  
// Print result
  UINT32 outLength = UINT32(outList->getLength());
  unsigned long* outBody = outList->getBody();
  UINT32 outIndex = UINT32(outBody[1]);
  UINT32 outNumPrims = outBody[2];
  UINT32 outPrimVersion = outBody[3];
  cout << "outLength = " << outLength << ", outIndex = " << outIndex << 
          ", outNumPrims = " << outNumPrims << ", outPrimVersion = " << 
          outPrimVersion <<'\n';
  int outPtr = 4;
  for (UINT32 j=0; j<outNumPrims; j++) {
    UINT32 primLength = outBody[outPtr++];
    UINT32 primIndex = outBody[outPtr++];
    UINT32 primId = outBody[outPtr++];
    UINT32 primVersion = outBody[outPtr++];
    cout << "primLength = " << primLength << ", primIndex = " << primIndex << 
            ", primId = " << primId << ", primVersion = " << primVersion << '\n';
    cout << "RW_SLAVE_MEMORY data: " << endl;
    hex(cout);
    for (UINT32 i=0; i<primLength-4; i++) {
      cout.width(8);
      cout << outBody[i+outPtr] <<" ";
      if (0 == (i+1)%8) cout << endl; 
    };
    if (0 != (primLength-4)%8) cout << endl;
    dec(cout);
// Display as text also
    cout.fill(' ');
    genPtr = static_cast<void*>(outBody);
    textBuff = static_cast<char*>(genPtr);
    cout << endl << "ASCII dump :" << endl;
    for (unsigned int itext = 0; itext< 4*numWords; itext++) {
      if ((textBuff[itext]<' ') || (textBuff[itext] > '~')) textBuff[itext] = '.';
        cout << textBuff[itext];
      if ((itext+1)%64 == 0) cout << endl;
    }
    cout << endl;
  };

// Clean up: clear primList, delete primitive, delete the outList
  primList.clear();
  delete rwSlave;
  delete [] myTextBuffer;
  rod0->deleteOutList();
  
// Delete the ROD and VME objects before exiting
  delete rod0;
  delete vme1;

  return 0;  
}


