// Test program to send multiple ECHO primitives to the PrimList.

#include <iostream>
using namespace std;

#include <ctype.h>

#include "RodModule.h"

#include "primParams.h"
#include "RCCVmeInterface.h"
#include "parameters.h"

int main(int argc, char *argv[]) {

using namespace SctPixelRod;

  RodPrimList primList(1);                      // Primitive List
  long myTextLength;                            // Actual length of text message
  TEXT_BUFFER_TYPE myTextType;                  // Buffer type for latest message
  PrimState returnPState;
  TextBuffState returnTState;

  std::string fileName(""), option;
  int slot = -1;
  unsigned long baseAddress;

  if (argc > 1) {
    for (int i=1; i<argc; i++) {
      option = argv[i];
      if (option[0] != '-') break;
      switch (option[1]) {
        case 's': {
          slot = atoi(option.substr(2).c_str());
          break;
        }
        default: {
          break;
        }
      }
    }
  }

// Prompt for slot number
  if (slot < 0 ) {
    cout << "Enter slot number (decimal):"; 
    cin >> slot;
    while ((slot < 1) || (slot > 21)) {
      cout << "Slot number out or range [1:21], re-enter: ";
      cin >> slot;
    }
  }
  baseAddress = slot << 24;

// Create VME interface
  RCCVmeInterface *vme1;
  try {
    vme1 = new RCCVmeInterface();
  }
  catch (VmeException &v) {
    cout << "VmeException creating VME interface." << endl;
    cout << "ErrorClass = " << v.getErrorClass() << endl;
    cout << "ErrorCode = " << v.getErrorCode() << endl; 
  }
  
// Create RodModule and initialize it
  RodModule* rod0 = new RodModule(baseAddress, mapSize, *vme1, numSlaves);
  try{
    rod0->initialize();
  }
  catch (HpiException &h) {
    hex(cout);
    cout << h.getDescriptor() << '\n';
    cout << "calcAddr: " << h.getCalcAddr() << ", readAddr: " << 
            h.getReadAddr() << '\n';
    dec(cout);
  }
  catch (VmeException &v) {
    cout << "VmeException creating RodModule." << endl;
    cout << "ErrorClass = " << v.getErrorClass() << endl;
    cout << "ErrorCode = " << v.getErrorCode() << endl; 
  }
  catch (RodException &r) {
  cout << r.getDescriptor() <<", " << r.getData1() << ", " << r.getData2()
          << '\n';
  }

// Create a buffer for text messages
  char * myTextBuffer;
  try {
    myTextBuffer= new char[TEXT_BUFF_SIZE];
  }
  catch (std::bad_alloc) {
    cout << "Unable to allocate text buffer in main.";
  }
// Create and Send a simple ECHO primitive
  long echoData1[2] = {0xDEADF00D,0};
  RodPrimitive* echo1;
  try {
    echo1= new RodPrimitive(6, 1, ECHO, R_ECHO, echoData1);
  }
  catch (std::bad_alloc) {
    cout << "Unable to allocate echo1 primitive in main.";
  }
  primList.insert(primList.begin(), *echo1);
  long echoData2[3] = {0x01234567, 0x89abcdef, 0xa0a0a0a0};
  RodPrimitive* echo2;
  try {
    echo2= new RodPrimitive(7, 2, ECHO, R_ECHO, echoData2);
  }
  catch (std::bad_alloc) {
    cout << "Unable to allocate echo2 primitive in main.";
  }
  primList.insert(primList.end(), *echo2);
  long echoData3[4] = {0xa5a5a5a5, 0x0f0f0f0f, 0x11111111, 0x77777777};
  RodPrimitive* echo3;
  try {
    echo3= new RodPrimitive(8, 3, ECHO, R_ECHO, echoData3);
  }
  catch (std::bad_alloc) {
    cout << "Unable to allocate echo3 primitive in main.";
  }
  primList.insert(primList.end(), *echo3);
  try {
    primList.bufferBuild();
  }
  catch (PrimListException &p) {
    cout << p.getDescriptor() << " ";
    cout << p.getData1() << ", " << p.getData2() << "\n";
  };
  try {
    rod0->sendPrimList(&primList);
  }
  catch (HpiException &h) {
    hex(cout);
    cout << h.getDescriptor() << '\n';
    cout << "calcAddr: " << h.getCalcAddr() << ", readAddr: " << 
            h.getReadAddr() << '\n';
    dec(cout);
  }
  catch (VmeException &v) {
    cout << "VmeException in SendPrimList." << endl;
    cout << "ErrorClass = " << v.getErrorClass() << endl;
    cout << "ErrorCode = " << v.getErrorCode() << endl; 
  };

// Wait for ROD to begin executing and then wait for it to finish executing
// Check for error messages in text buffer and read them out if they exist.
// Note: this is NOT how primHandler and textHandler will be used once we
// go to threads.  This is for debugging the code only.
  do {
    try {
      returnPState = rod0->primHandler();
    }
    catch (VmeException &v) {
      cout << "VmeException in first primHandler call." << endl;
      cout << "ErrorClass = " << v.getErrorClass() << endl;
      cout << "ErrorCode = " << v.getErrorCode() << endl; 
    }
    try {
      returnTState = rod0->textHandler();
    }
    catch (VmeException &v) {
      cout << "VmeException in first textHandler call." << endl;
      cout << "ErrorClass = " << v.getErrorClass() << endl;
      cout << "ErrorCode = " << v.getErrorCode() << endl; 
    }
    if (returnTState == TEXT_RQ_SET) {
      do {
        try {
          returnTState = rod0->textHandler();
          }
        catch (VmeException &v) {
          cout << "VmeException in second textHandler call." << endl;
          cout << "ErrorClass = " << v.getErrorClass() << endl;
          cout << "ErrorCode = " << v.getErrorCode() << endl; 
        }
      } while (returnTState != TEXT_READOUT);
      rod0->getTextBuffer(myTextBuffer, myTextLength, myTextType);
      rod0->clearTextBuffer();
      for (int i=0; i<myTextLength; i++) {
        cout << myTextBuffer[i];
        if (0==(i+1)%64) cout << endl;
        }
      cout << endl; 
    }
  } while (returnPState != PRIM_EXECUTING); 
  do {
    try {
      returnPState = rod0->primHandler();
    }
    catch (RodException &r) {
    cout << r.getDescriptor() <<", " << r.getData1() << ", " << r.getData2()
            << '\n';
    }
    catch (VmeException &v) {
      cout << "VmeException in second primHandler call." << endl;
      cout << "ErrorClass = " << v.getErrorClass() << endl;
      cout << "ErrorCode = " << v.getErrorCode() << endl; 
    }
  } while (returnPState != PRIM_WAITING); 
  
// Retrieve output buffer
  RodOutList* outList = rod0->getOutList();
  
// Print results (User processing of outList)
  UINT32 outLength = UINT32(outList->getLength());
  unsigned long* outBody = outList->getBody();
  UINT32 outIndex = UINT32(outBody[1]);
  UINT32 outNumPrims = outBody[2];
  UINT32 outPrimVersion = outBody[3];
  cout << "outLength = " << outLength << ", outIndex = " << outIndex << 
          ", outNumPrims = " << outNumPrims << ", outPrimVersion = " << 
          outPrimVersion <<'\n';
  int outPtr = 4;
  for (unsigned int j=0; j<outNumPrims; j++) {
    UINT32 primLength = outBody[outPtr++];
    UINT32 primIndex = outBody[outPtr++];
    UINT32 primId = outBody[outPtr++];
    UINT32 primVersion = outBody[outPtr++];
    cout << "primLength = " << primLength << ", primIndex = " << primIndex << 
            ", primId = " << primId << ", primVersion = " << primVersion << '\n';
    cout << "ECHO data: ";
    hex(cout);
    for (unsigned int i=0; i<primLength-4; i++) {
      cout.width(8);
      cout << outBody[i+outPtr] <<" ";
      if (0 == (i+1)%8) cout << endl; 
    };
    outPtr += primLength-4;
    if (0 != (primLength-4)%8) cout << endl;
    dec(cout);
  };
  
// Copy to local buffer
  unsigned long* myOutBody;
  try {
    myOutBody= new unsigned long[outLength];
  }
  catch (std::bad_alloc) {
    cout << "Unable to allocate myOutBody in main." << endl;
  }
  for (unsigned int i=0; i<outLength; i++) {
    myOutBody[i] = outBody[i];
  };

// Clean up: clear primList, delete primitive, delete the outList
  primList.clear();
  delete myOutBody;
  delete echo3;
  delete echo2;
  delete echo1;
  delete [] myTextBuffer;
  rod0->deleteOutList();
  
// Delete the ROD and VME objects before exiting
  delete rod0;
  delete vme1;

  return 0;  
}


