//File: TimDefine.h

#ifndef SCTPIXELROD_TIMDEFINE_H
#define SCTPIXELROD_TIMDEFINE_H

/*! \file
 * \brief TimDefine.h: An incomplete prototype definition of a TIM.
 *
 * NB define eg I_AM_LINUX_HOST for processor.h (eg typedef UINT32)
 *
 * Contributors: John Lane <jbl@hep.ucl.ac.uk> - originator
 *
 * $Id: TimDefine.h,v 1.4 2003/06/04 15:04:32 tmeyer Exp $
 *
 * $Log: TimDefine.h,v $
 * Revision 1.4  2003/06/04 15:04:32  tmeyer
 * Removed explicit directory structure from includes
 *
 * Revision 1.3  2002/12/11 21:30:49  jbl
 * TimModule major update
 *
 *
 *
 * Reference: http://www.hep.ucl.ac.uk/~jbl/SCT/TIM_registers.html
 */

namespace SctPixelRod {

#include "processor.h"

//! Define timing in clock cycles for SCT, Pixel is different

enum TimTimingSCT {
     TIM_L1A_DEADTIME =  3,
     TIM_ECR_DEADTIME =  7,
     TIM_BCR_DEADTIME =  7,
     TIM_CAL_DEADTIME = 27,
     TIM_BCID_OFFSET  =  6
};

const INT32 TIM_L1ID_FIRST = 0; //!< triggers

/*! Sequencer RAM is 16K bytes for both source and sink memory.
 *  They are accessed together as 16K 16-bit words.
 */
const INT32 TIM_SEQ_SIZE = 0x4000; //!< bytes
const INT32 TIM_SEQ_ADDR = 0x8000; //!< bytes

//! Define register offsets in bytes

enum TimRegister {
     TIM_REG_ENABLES      = 0x00,
     TIM_REG_COMMAND      = 0x02,
     TIM_REG_BURST_COUNT  = 0x04,
     TIM_REG_FREQUENCY    = 0x06,
     TIM_REG_WINDOW       = 0x08,
     TIM_REG_DELAY        = 0x0A,
     TIM_REG_STATUS       = 0x0C,
     TIM_REG_FIFO_STATUS  = 0x0E,
     TIM_REG_TRIGGER_IDLO = 0x10,
     TIM_REG_TRIGGER_IDHI = 0x12,
     TIM_REG_TRIGGER_BCID = 0x14,
     TIM_REG_TRIGGER_TYPE = 0x16,
     TIM_REG_RUN_ENABLES  = 0x18,
     TIM_REG_SEQ_CONTROL  = 0x1A,
     TIM_REG_SEQ_END      = 0x1C,
     TIM_REG_ROD_MASK     = 0x1E,
     TIM_REG_ROD_BUSY     = 0x20,
     TIM_REG_ROD_LATCH    = 0x22,
     TIM_REG_ROD_MONITOR  = 0x24,
     TIM_REG_TTC_DATA     = 0x26,
     TIM_REG_TTC_SELECT   = 0x28,
     TIM_REG_TTC_BCID     = 0x2A,
     TIM_REG_TTC_RX       = 0x2C,
     TIM_REG_TTC_STATUS   = 0x2E,
     TIM_REG_OUTPUT       = 0x30,
     TIM_REG_TIM_ID       = 0x32
};

//! Define register bits as masks

enum TimBitEnables {
     TIM_BIT_EN_INT_TRIG = 0x0002,  //!< Enable internal repetitive Trigger
     TIM_BIT_EN_INT_ECR  = 0x0004,  //!< Enable internal repetitive ECReset
     TIM_BIT_EN_INT_BCR  = 0x0008,  //!< Enable internal repetitive BCReset
     TIM_BIT_EN_RANDOM   = 0x0010,  //!< Enable internal trigger randomizer
     TIM_BIT_EN_INT_FER  = 0x0020,  //!< Enable internal repetitive FEReset
     TIM_BIT_EN_WINDOW   = 0x0040,  //!< Enable trigger window
     TIM_BIT_EN_INT_BUSY = 0x0080,  //!< Enable internal Busy

     TIM_BIT_EN_EXT_CLK  = 0x0100,  //!< Enable external inputs: clock
     TIM_BIT_EN_EXT_TRIG = 0x0200,  //!< Enable external inputs: trigger
     TIM_BIT_EN_EXT_ECR  = 0x0400,  //!< Enable external inputs: ECReset
     TIM_BIT_EN_EXT_BCR  = 0x0800,  //!< Enable external inputs: BCReset
     TIM_BIT_EN_EXT_CAL  = 0x1000,  //!< Enable external inputs: Calibrate
     TIM_BIT_EN_EXT_FER  = 0x2000,  //!< Enable external inputs: FEReset
     TIM_BIT_EN_EXT_SEQ  = 0x4000,  //!< Enable external inputs: Sequencer Go
     TIM_BIT_EN_EXT_BUSY = 0x8000   //!< Enable external inputs: Busy
};

enum TimMaskFrequency {
     TIM_MASK_TRIG_100_KHZ = 0x0006,
     TIM_MASK_TRIG_10_0KHZ = 0x000E,
     TIM_MASK_TRIG_1_00KHZ = 0x0016,
     TIM_MASK_TRIG_0_10KHZ = 0x001E,

     TIM_MASK_FER_10_00HZ  = 0x0600,
     TIM_MASK_FER_1_000HZ  = 0x0E00,
     TIM_MASK_FER_0_100HZ  = 0x1600,
     TIM_MASK_FER_0_010HZ  = 0x1E00
};
                       //!  Applies to Sequencer and Output
enum TimBitBackplane {
     TIM_L1A = 0x01,       //!< Level-1 Accept trigger
     TIM_ECR = 0x02,       //!< Event Counter Reset
     TIM_BCR = 0x04,       //!< Bunch Counter Reset
     TIM_CAL = 0x08,       //!< Calibrate strobe
     TIM_SID = 0x10,       //!< Serial event ID
     TIM_STT = 0x20,       //!< Serial Trigger Type
     TIM_CMD = 0xCF,       //!< Commands available
     TIM_RES = 0xC0,       //!< Commands reserved
     TIM_FER = 0x40,       //!< Front-End Reset - reserved
     TIM_SPA = 0x80,       //!< Spare command   - reserved
     TIM_TRG = 0x31        //!< Trigger and serial streams
};
                       //!  Applies to Command register
enum TimBitCommand {
     TIM_VTRG = 0x02,      //!< Single VME Trigger
     TIM_VECR = 0x04,      //!< Single VME ECR
     TIM_VBCR = 0x08,      //!< Single VME BCR
     TIM_VCAL = 0x10,      //!< Single VME CAL
     TIM_VFER = 0x20,      //!< Single VME FER
     TIM_VSPA = 0x40,      //!< Single VME SPA

     TIM_BIT_VRESET = 0x8000
};

enum TimBitRunEnables {
     TIM_BIT_EN_ID   = 0x0200,
     TIM_BIT_EN_TYPE = 0x0400
};

enum TimBitSeqControl {
     TIM_BIT_SEQ_EN_ALL = 0x00FF,
     TIM_BIT_SEQ_RESET  = 0x0200,
     TIM_BIT_SEQ_GO     = 0x0400,
     TIM_BIT_EN_CYCLIC  = 0x0800
};

} // End namespace SctPixelRod

#endif // SCTPIXELROD_TIMDEFINE_H
