// File: RodPrimitive.h

#ifndef SCTPIXELROD_RODPRIMITIVE_H
#define SCTPIXELROD_RODPRIMITIVE_H

/*! 
 * @class RodPrimitive  
 *
 * @brief This is a class for primtives which control ROD execution.
 *
 * This class contains the primitives which are sent as a list to the RODs. They control 
 * almost all aspects of the ROD DSP behavior. New primitives can be defined to perform
 * user-defined actions, but corresponding DSP code must also be written, compiled and
 * loaded into the DSPs before the primitive can be executed.
 *
 * @author Tom Meyer (meyer@iastate.edu) - originator
 */

namespace SctPixelRod {

class RodPrimitive
{
public:
	RodPrimitive();                                               // Default constructor
	RodPrimitive( long length, long index, long id, long version, 
                      long * body);                                   // Alternate constructor
	RodPrimitive( const RodPrimitive& );                          // Copy constructor
	~RodPrimitive();                                              // Destructor
	RodPrimitive& operator=( const RodPrimitive&);                //Overload = operator

	//! Accessor function to set length
	void setLength( long len) { m_length = len; }
	//! Accessor function to get length
	long getLength() const { return m_length; }
	
	//! Accessor function to set index
	void setIndex( long ind) { m_index = ind; }
	//! Accessor function to get index
	long getIndex() const { return m_index; }
	
	//! Accessor function to set ID
	void setId( long id) { m_id = id; }
	//! Accessor function to get ID
	long getId() const { return m_id; }
	
	//! Accessor function to set version
	void setVersion( long version) { m_version = version; }
	//! Accessor function to get version
	long getVersion() const { return m_version; }
	
	//! Accessor function to set pointer to data body.
	void setBody( long *body) { m_body = body;}
	//! Accessor function to get pointer to data body.
	long* getBody() const {return m_body; }
 
        //! Figure checksum
        long checkSum();

private:
    //! The length of the primitive (may need to be filled after primitive is defined.) 
	long m_length;
    //! The index of the primitive. This is an accounting ID giving a unique numerical identifier. 
	long m_index;
    //! The ID which says what kind of primitive this is (echo, memory test, etc.).
	long m_id;
    //! The version number for this primitive
        long m_version;
    //! A pointer to the body of the primitive. Storage is allocated in the calling routine, do
    //! not delete the body from within this class. Watch for memory leaks!!!
	long *m_body;

};                                    // End of RodPrimitive declaration
} // End namespace SctPixelRod

#endif  // SCTPIXELROD_RodPrimitive_H
