#ifndef SERIAL_STREAMS
	#define SERIAL_STREAMS

	#if   defined(SCT_ROD)
		#include "ABCD/ABCDchip.h"
		#include "sctStructure.h"

		#define N_CHIPS             (N_SCT_CHIPS)

		#define N_MODULES           (N_SCT_MODULES)
		#define N_EXTMODULES        (N_SCT_EXTMODULES)
		#define N_TOTMODULES        (N_SCT_TOTMODULES)
		
		typedef ABCDModule Module;
		typedef ABCDChip   Chip;

	#elif defined(PIXEL_ROD)
		#include "pixelCommands.h"
		#include "pixelConfigStructures.h"

		#define N_CHIPS             (N_PIXEL_FE_CHIPS)

		#define N_MODULES           (N_PIXEL_MODULES)
		#define N_EXTMODULES        (N_PIXEL_EXTMODULES)
		#define N_TOTMODULES        (N_PIXEL_TOTMODULES)

		typedef PixelModule   Module;
		typedef PixelFEConfig Chip;
	#endif

	/* maximum length of a command stream to configure one module= 3240 words= 0xca8;
	   a small amount of padding is added. dpsf: true for pixels too? */
	#define CMD_STREAM_WMAX 0xd00

	struct CMD_BUFF {
		UINT32 *data;				  /* command stream buffer */
		UINT32 bufferSizeWords; /* word is 32bits wide */
		UINT32 bitIndex; /* current write bit index (number of full bits in
		                          the data buffer) */
		UINT8  port, unused[3];
	};

	#define WORD_INDEX(bitIndex) ((bitIndex)/32) /* returns 32bit word index */


	/* A timing structure for sendConfigSet: */
	typedef struct CfgTiming {
		/* *_mk: construction time, *_len: bit length, 
		   *_il: interleaving time  *_xm: transmission time */
		UINT32  total, setup, cfg;
		UINT32  current;
		UINT32  enableDT_mk, enableDT_len, enableDT_il, enableDT_xm;
		UINT32  gbl_mk, gbl_len, gbl_il, gbl_xm;
		UINT32  reg_mk, reg_len, reg_il, reg_xm;
		UINT32  ngbl, nreg;
	} CfgTiming;


#endif
