typedef struct InitTiming {
	UINT32 dt_cfg, dt_cfg_setup;
	UINT32 dt[10];
	UINT32 total;
} InitTiming;

typedef struct NewbinSubTiming {
	UINT32 nExe;
	UINT32 dt_calc[2], dt_cfg;
	UINT32 avg, total;
} NewbinSubTiming;

typedef struct NewbinTiming {
	UINT32 nExe;
	UINT32 dt_task;

	UINT32 dt_setup, dt_sdsp_setup;

	UINT32 dt_calc, dt_cfg;

	UINT32 dt_edt, dt_resets;
	UINT32 dt_trigBuild;

	NewbinSubTiming loop[4]; //0: stage, 1:inner, 2: outer, 3:chip

	UINT32 avg, total;
} NewbinTiming;

typedef struct DspTiming {
	UINT32 nExe;
	UINT32 dt_pulses[2], nReady;
	UINT32 nNotReady, nrAvg;
	UINT32 dt_xmit;            
	UINT32 lastTrigger, nrCnt; /* Used internally. */
} DspTiming; 

typedef struct PulseTiming {
	UINT32 nExe, nReady;
	UINT32 dt_task;
	UINT32 dt_setup; /* (measured for 1st SDSP only) */
	UINT32 avg, total;

	UINT32 dspDwell;
	DspTiming dsp[4];
	
	/* measured for 1st SDSP only when ready: */
	UINT32 dt_ready;
	UINT32 dt_setRegs, dt_trig;
	UINT32 dt_evtCheck, dt_update;
} PulseTiming;

typedef struct SectionTiming {
	UINT32 nExe;
	UINT32 dt_task;
	UINT32 avg, total;
} SectionTiming;

typedef struct ScanTimingInfo {
	UINT32 dt_total;

	InitTiming    init;
	NewbinTiming  nb;
	SectionTiming wexp;
	PulseTiming   pulse[256];
	SectionTiming wait;
	SectionTiming prep;
	SectionTiming done;
} ScanTimingInfo;

