/************************************************************************************
 * bocStructure.h                                            
 *
 *  synopsis:  Collects together all the BOC settings for a given set of command &
 *             data links. This structure is intended to be incorporated into the
 *             ABCDModule & PixelModule structures.    
 *
 *  Douglas Ferguson, UW Madison                              dpferguson@lbl.gov
 *  Peter W Phillips, Oxford University                       P.W.Phillips@rl.ac.uk
 *  John Richardson, Lawrence Berkeley Laboratory             john.richardson@cern.ch
 *  Joseph Virzi, University of California                    jsvirzi@lbl.gov
 ************************************************************************************/
#ifndef BOC_STRUCTURE_H
#define BOC_STRUCTURE_H
/* register definitions for the BOC setting routines' case statements; note that some
   of these closely match the RRIF register definitions in registerIndices.h they are
   abbreviated here. (Some of the indices in rI.h are for register sets and so do not
   work well in the case statement). */
#define BOC_TXFINE       0x00
#define BOC_TXCOARSE     0x01
#define BOC_TXMARKSPACE  0x02
#define BOC_TXINHIBIT    0x03
#define BOC_TXCURRENT    0x04

#define BOC_RXTHRESHOLD  0x10
#define BOC_RXDELAY      0x11

#define BOC_BPM_CLOCK_PHASE            0x20
#define BOC_BREG_CLOCK_PHASE           0x21
#define BOC_VERNIER_CLOCK_STEPPHASE0   0x22
#define BOC_VERNIER_CLOCK_STEPPHASE1   0x23
#define BOC_VERNIER_CLOCK_FINEPHASE    0x24

#define BOC_BOCRESET       0x30
#define BOC_BPMRESET       0x31
#warning "These conflict with BocCard!!!!"
/* #define BOC_TXDAC_CLEAR    0x32 */
/* #define BOC_RXDAC_CLEAR    0x33 */

#define BOC_STAT           0x40
#define BOC_RXDATAMODE     0x41
#define BOC_CLOCKCTRLBITS  0x42

#define BOC_FIRMWARE_REV    0x50
#define BOC_HARDWARE_REV    0x51
#define BOC_MODULETYPE      0x52
#define BOC_MNFT            0x53
#define BOC_SERIALNO        0x54

typedef struct {
  UINT8 txFineDelay;      //transmitter fine delay. 
  UINT8 txCoarseDelay;    //transmitter coarse delay.
  UINT8 txMarkSpace;      //transmitter markSpace ratio.
  UINT8 txStreamInhibit;  //0 ==> inhibit channel.

  UINT8 txCurrent;        //Laser current.
  UINT8 unused[3];
} BOCTxParams;

typedef struct {
  UINT8 rxThreshold;      //receiver threshold.
  UINT8 rxDelay;          //receiver delay.
} BOCRxParams;

typedef struct {
  UINT8 bpmClockPhase;
  UINT8 bRegClockPhase;
  UINT8 vernierClockStepPhase[2];
  UINT8 vernierClockFinePhase;

  UINT8 bocReset;  //needed?
  UINT8 bpmReset;  //  "
  UINT8 txDacClear; // " 
  UINT8 rxDacClear; // " 

  UINT8 status;
  UINT8 rxDataMode;
  UINT8 clockCtrlBits;

  UINT8 firmwareRev;
  UINT8 hardwareRev;
  UINT8 moduleType;
  UINT8 manufacturer;
  UINT8 serialNumber;

  UINT8 unused[3];    //data alignment.
  UINT32 unused1[3];
} BOCGlobalParams;

typedef struct {
  BOCTxParams      bocTxParams[48];
  BOCRxParams      bocRxParams[96];
  BOCGlobalParams  bocGlobalParams;
} BOCConfig;

#endif

