/******************************************************************************
 * 
 *  Title  : ABCDscans.h 
 *  Version: 07 January 2003
 *  Revised: 25 March 2003
 *   
 *  Description:   Definitions of variable type numbers
 *                 Extracted from SCTDAQ's "sct_scans.h"
 *                 The numbering scheme is largely historic and may seem crazy
 *                 but I wish to keep it for reasons of backward compatibility
 *                   
 *  Related files: ABCDconfig.c
 *  Documentation: http://s.home.cern.ch/s/sct/public/sctdaq/sctdaq.html
 *
 *  Author: Peter W Phillips, P.W.Phillips@rl.ac.uk
 *
 ******************************************************************************/

#ifndef ABCD_SCANS_H	 /* multiple inclusion protection */
#define ABCD_SCANS_H

#include "processor.h"

/******************************************************************************
 *                             Definitions                                    *
 ******************************************************************************/ 

/* Elapsed == elapsed time; equivalent of a NOP to permit general monitoring */
#define ST_ELAPSED       0

/*
 * ABCD3T DAC and Delay Settings
 */

#define ST_VTHR          1
#define ST_VCAL          2
#define ST_STROBE_DELAY  3
#define ST_PREAMP        4
#define ST_SHAPER        5

#define ST_TRIM          6  /* set trim value of all channels */
#define ST_MASK          7  /* predefined mask patterns used during testing */
#define ST_ROLE          8
#define ST_NMASK         9  /* number of channels to be masked */

/*
 * ABCD3T Config Register Settings
 */
#define ST_CAL_MODE      10  /* calibMode   */
#define ST_COMPRESSION   11  /* readoutMode */
#define ST_TRIM_RANGE    12  /* trimRange   */
#define ST_EDGE_DETECT   13  /* edgeDetect  */
#define ST_SEND_MASK     14  /* mask        */
#define ST_ACCUMULATE    15  /* accumulate  */

#define ST_BYPASS        17   /* predefined redundancy configurations
                                 to be used during production testing
                                 PWP 01.11.00 */
#define ST_ACTIVE        18  /* set ACTIVE or INACTIVE */

#define ST_TOKEN         19  /* a bit pattern that defines the bypass 
				 scheme allowing all combinations. A '1'
				 means that the chip is read out, a '0' 
			         means that the chip is bypassed/dead */

/*
 * Adjustment of ABCD3T DAC settings using the calibration (RC) data
 */

#define ST_QTHR          41
#define ST_QCAL          42
#define ST_TARGET        43   /* Record of Trim Target PWP 06.12.02 */
#define ST_TTHR          44   /* Threshold in mV set wrt Trim Target PWP 06.12.02 */

/* 
 * BOC parameters
 * Several of these have direct parallels in SCTDAQ
 * - hence this might look a little wierd PWP 25.03.03
 */

#define ST_RX_DELAY      20 /* same as ST_STREAM_DELAY  in SCTDAQ */
#define ST_RX_DELAY0     21 /* same as ST_STREAM_DELAY0 in SCTDAQ */
#define ST_RX_DELAY1     22 /* same as ST_STREAM_DELAY1 in SCTDAQ */

#define ST_RX_THRESHOLD  50 /* same as ST_OPTO_RX_THR  in SCTDAQ */
#define ST_RX_THRESHOLD0 51 /* same as ST_OPTO_RX_THR0 in SCTDAQ */
#define ST_RX_THRESHOLD1 52 /* same as ST_OPTO_RX_THR1 in SCTDAQ */

#define ST_TX_CURRENT    53  /* same as ST_OPTO_TX_DAC in SCTDAQ */
#define ST_TX_MARKSPACE  54  /* ??? ST_OPTO_TX_MKSNEG ??? */
#define ST_TX_DELAY      55  /* *** no direct parallel *** */
#define ST_TX_COARSE     56  /* same as ST_OPTO_TX_CDELAY */
#define ST_TX_FINE       57  /* same as ST_OPTO_TX_FDELAY */

#define SCAN_STATIC      1

typedef struct {
	/* options for resetting modules (beginning of scan & between bins) */
	UINT8 moduleInit;
	UINT8 binReset;
	UINT8 ECR;
	UINT8 BCR;
} SCTScanReset; /* Start of scan reset options */	


#endif /* ABCD_SCANS_H */
