/******************************************************************************
 * 
 *  Title  : ABCDcommands.h  ==> ABCDchip.h, ABCDfxn.h
 *  Version: 15 June 2002
 *   
 *  Description:  
 *  Related files: ABCDcommands.c
 *  Documentation: http://s.home.cern.ch/s/sct/public/sctdaq/sctdaq.html
 *
 *  Author: Lukas Tomasek, tomasekl@fzu.cz
 *
 *  modifications/bugs:
 *
 *  Merged in the definitions from ABCDconfig.h                  14.01.03 dpsf
 ******************************************************************************/

#ifndef ABCD_CHIP_H	 /* multiple inclusion protection */
#define ABCD_CHIP_H
 
 /* chip address (bits 5:4) */
#define PRIMARY_FIBRE     0x2
#define ADJACENT_FIBRE    0x3
/* chip address (bits 3:0) */ 
#define ALL_CHIPS	        0x3F   
#define CHIP_ADDR_LOOP		0xFF    

#define M0_CHIP		0x0
#define S1_CHIP    	0x1  
#define S2_CHIP   	0x2  
#define S3_CHIP   	0x3  
#define S4_CHIP   	0x4  
#define E5_CHIP   	0x5  
#define M8_CHIP   	0x8  
#define S9_CHIP   	0x9 
#define S10_CHIP  	0xA  
#define S11_CHIP  	0xB  
#define S12_CHIP  	0xC  
#define E13_CHIP  	0xD  

/* full chip address (bits 5:0) */
#define CHIP_ADDRESS(fibre, addressBits3to0) (((fibre)<<4)|(addressBits3to0))

#define CHIP_ALLCHIPS_ADDR_CONSTRUCT  0xf

/* readout mode */
#define RM_HIT     0x0   /* detector alignment */
#define RM_LEVEL   0x1   /* normal data taking */ 
#define RM_EDGE    0x2   /* normal data taking */
#define RM_TEST    0x3   /* test mode */

/* calibration mode */
#define CAL_IN3      0x0  
#define CAL_IN2      0x1  
#define CAL_IN1      0x2
#define CAL_IN0      0x3

/* trim DAC range */
#define TRIM_DAC_RANGE_60mV    0x0
#define TRIM_DAC_RANGE_120mV   0x1  
#define TRIM_DAC_RANGE_180mV   0x2  
#define TRIM_DAC_RANGE_240mV   0x3

/* command length in bits */
#define L1_TRIGGER_LENGTH  3
#define FAST_CMD_LENGTH    7
#define SLOW_CMD_LENGTH   27
#define DATA_CMD_LENGTH   64
#define MASK_CMD_LENGTH  192

#define NO_CMD           100

typedef enum { 
	L1_TRIGGER		    =101,
	SOFT_RESET		    =102,
	BC_RESET		    =103
} FAST_CMD_ID;

typedef enum { 
	PULSE_INPUT_REG     =104,
	ENABLE_DATA_TAKING  =105, 
	CALIBRATION_PULSE   =106
} SLOW_CMD_ID;

typedef enum {
	CONFIG_REG         =107,
	STROBE_DELAY_REG   =108, 
	THRESHOLD_REG      =109, 
	BIAS_DAC_REG       =110,  
	TRIM_DAC_REG       =111 
} DATA_CMD_ID;

typedef enum {
	DELAY              =112,
	MASK               =113
} EXTRA_CMD_ID;


/* merged from ABCDconfig.h */
typedef enum {
  MISSING = 0,
  DEAD = 1,
  END = 2,
  MASTER = 3,
  SLAVE = 4,
  LONELY = 5,
  PARANOID = 6
} ABCD_ROLES;

#endif /* ABCD_CHIP_H */
