#include <iostream>
using namespace std;

#include <ctype.h>

#include <unistd.h>

#include "RodModule.h"
#include "BocCard.h"

#include "RCCVmeInterface.h"

using namespace SctPixelRod;

int main(int argc, char **argv) {
  const unsigned long mapSize=0xc00040;         // Map size
  const long numSlaves=4;                       // Number of slaves

  int slot = -1;
  unsigned long baseAddress;

  if (argc > 1) {
    for (int i=1; i<argc; i++) {
      string option;
      option = argv[i];
      if (option[0] != '-') break;
      switch (option[1]) {
        case 's': {
          slot = atoi(option.substr(2).c_str());
          break;
        }
        default: {
          break;
        }
      }
    }
  }

// Prompt for slot number
  if (slot < 0) {
    cout << "Enter slot number (decimal):"; 
    cin >> slot;
    while ((slot < 1) || (slot > 21)) {
      cout << "Slot number out or range [1:21], re-enter: ";
      cin >> slot;
    }
  }
  baseAddress = slot << 24;
  
// Create VME interface
  RCCVmeInterface *vme1 = new RCCVmeInterface();
  
// Create RodModule
  RodModule* rod0 = new RodModule(baseAddress, mapSize, *vme1, numSlaves);

  rod0->initialize(false);

  BocCard* boc = rod0->getBocCard();

  if(!boc) {
    cout << "No BOC object found aborting\n";
    return 1;
  }

  boc->initialize();

  cout << "Turning off all lasers ...\n";
  for(int ch=0; ch<48; ch++) {
    boc->setLaserCurrent(ch, 0);
  }
  cout << " ... done\n";

// Clean up before exiting
  delete rod0;
  delete vme1;

  return 0;  
}


