/*
 * JythonInterpreter.java
 *
 * Created on 13 August 2003, 15:11
 */

package GuiComponents.scripting;
import org.apache.bsf.*;
import GuiComponents.Console.*;

/**
 *
 * @author  palmer
 */
public class JythonInterpreter extends DefaultInterpreter {
    private int lastLevel = 0;
        
    public JythonInterpreter(JConsole console, BSFEngine engine, NameCompleter name) {
        super(console, engine, name);
        lineContinueChar = '\\';
        blockStartChar = ':';
        
    }
    
    /*Different algorithm for Python - count the number of tab characters and
     *see if it is less than the number of indents
     */
    protected boolean endBlock(String line) {        
        if (indentLevel(line) < nestLevel()) return true;
        else return false;
    }
    
    /** Return the indent level of this line
     */
    private int indentLevel(String line) {
        lastLevel = 0;
        while (line.charAt(lastLevel) == '\t') ++lastLevel;        
        return lastLevel;
    }
    
    protected void decIndent() {         
        int nTimes = nestLevel() - lastLevel;
        System.out.println(nTimes);
        while (nTimes-- > 0) {
            super.decIndent();
        }
    }
    
    /* Try twice - once with eval and once with exec
     */
    public void exec(String s, String source, int row, int column) {
        try {            
            Object retVal = engine.eval(source, row, column, s);                        
            if (printObject(retVal))
                console.println(retVal.toString());
        } catch (BSFException be1) {
            try {
                engine.exec(source, row, column, s);
            } catch (BSFException be) {
                console.println(be.toString());                
                be.printStackTrace();
            }
        }     
    }
}
