/*
 * JythonFactory.java
 *
 * Created on 13 August 2003, 10:04
 */

package GuiComponents.scripting;
import org.apache.bsf.*;
import GuiComponents.Console.*;

/**
 *
 * @author  palmer
 */
public class JythonFactory implements ScriptFactory {
    
    public JConsole createConsole() {
        return new JConsole();
    }    

    public BSFEngine createEngine(BSFManager manager) {
        try {
            return manager.loadScriptingEngine("jython");
        } catch (BSFException be) {
            System.err.println("Error loading jython scripting engine: " + be);
            return null;
        }
    }    
        
    public NameCompleter createNameCompleter(BSFEngine engine, SearchableObjectRegistry registry) {
        return registry;
    }
    
    public Interpreter createInterpreter(BSFManager manager) {
	BSFEngine engine = createEngine(manager);
	JConsole console = new JConsole();
        NameCompleter nc = createNameCompleter(engine, (SearchableObjectRegistry)manager.getObjectRegistry());
        return new JythonInterpreter(console, engine, nc);
    }    
    
}
