/*
 * BeanShellNameCompleter.java
 *
 * Created on 12 August 2003, 15:53
 */

package GuiComponents.scripting;
import java.util.*;
import bsh.*;
import bsh.util.*;
import org.apache.bsf.*;
/**
 *
 * @author  palmer
 */
public class BeanShellNameCompleter implements NameCompleter {
    
    private NameCompletionTable nct;
    
    /** Creates a new instance of BeanShellNameCompleter */
    public BeanShellNameCompleter(BSFEngine engine) {
        nct = new NameCompletionTable();
        try {
            This t = (This)engine.eval("internal" , -1, -1, "bsh");            
            nct.add(t.getNameSpace());
        } catch (BSFException e) {
            e.printStackTrace();
        }
    }
    
    public List completeName(String context, String part) {
        System.out.println("BeanShellNameCompleter");
        String[] vals = nct.completeName(part);
        ArrayList al = new ArrayList();
        for (int i=0; i<vals.length; ++i) {
            al.add(vals[i]);
        }
        
        return al;
    }
    
    public List provideHelp(String method) {
        return null;
    }
    
}
