package GuiComponents.SctConf;

import java.util.Enumeration;
import java.util.Vector;
import java.awt.Dimension;
import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.*;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeModelEvent;

import org.omg.CORBA.IntHolder;

import Sct.gui.SelectionDialog;

import sctConf.Configuration;
import sctConf.ConfigurationException;
import sctConf.MURType;
import sctConf.RodConfig;
import sctConf.SlaveConfig;

public class TreeView extends JPanel {
    private Proxies configGui;
    private sctConf.Configuration config;

    private JTree tree;

    private JPopupMenu popup;

    private MyModel treeModel;

    public TreeView(Proxies cGui, Configuration conf) {
        configGui = cGui;
        config = conf;

        treeModel = new MyModel(config);

        tree = new JTree(treeModel);

        JScrollPane treeView = new JScrollPane(tree);

        enableEvents(java.awt.AWTEvent.WINDOW_EVENT_MASK);
        tree.addMouseListener(new MouseClickHandler());

        setLayout(new BorderLayout());

        popup = new JPopupMenu();
        popup.add(new JMenuItem("Do nothing"));

        treeView.setPreferredSize(new Dimension(500, 300));
        add(treeView, BorderLayout.CENTER);

        System.out.println("Set up GUI, wait for it to run");
    }

    private class MouseClickHandler extends MouseAdapter {
        private JMenuItem menuWithAction(String name, Object thing) {
            JMenuItem result = new JMenuItem(name);
            result.addActionListener(new ActionHandler(name, thing));

            return result;
        }

        private void checkPopup(MouseEvent event) {
            if(event.isPopupTrigger()){
                TreePath path = tree.getPathForLocation(event.getX(), event.getY());
                if(path != null){
                    tree.setSelectionPath(path);
                    Object thing = path.getLastPathComponent();

                    System.out.println("Last in path is: " + thing);

                    try {
                        while(true) {
                            popup.remove(0);
                        }
                    } catch(IllegalArgumentException e) {
                        // There must be a better way of doing this!
                    }

                    if(thing == null) {
                    } else if(thing == "Partitions") {
                        popup.add(menuWithAction("Add ROD", thing));
                        popup.add(menuWithAction("Add TIM", thing));
                        popup.add(menuWithAction("Clear everything", thing));
                    } else if(thing instanceof Proxies.PartitionProxy) { 
                        popup.add(menuWithAction("Clear crates", thing));
//                         popup.add(menuWithAction("Add crate to Partition", thing));
                    } else if(thing instanceof Proxies.CrateProxy) { 
                        popup.add(menuWithAction("Clear RODs in crate", thing));
                        popup.add(menuWithAction("Add ROD to crate", thing));
                    } else if(thing instanceof Proxies.RodProxy) { 
                        popup.add(menuWithAction("View ROD info", thing));
                        popup.add(menuWithAction("Add MUR to ROD", thing));
                    } else if(thing instanceof Proxies.MurProxy) { 
                        popup.add(menuWithAction("Add Module to MUR", thing));
                        popup.add(menuWithAction("Edit MUR mappings", thing));
                    } else if(thing instanceof Proxies.ModuleProxy) { 
                        popup.add(menuWithAction("View module configuration", thing));
                        popup.add(menuWithAction("Edit module mappings", thing));
                        popup.add(menuWithAction("Unmap module", thing));
                        popup.add(menuWithAction("Refresh", thing));
                    } else if(thing instanceof String) { 
                        String name = (String)thing;
                    }
                    if(popup.getComponents().length > 0) {
                        popup.show(tree, event.getX(), event.getY());
                    }
                }
            }
        }
        public void mousePressed(MouseEvent event){
            checkPopup(event);
        }
        public void mouseReleased(MouseEvent event){
            checkPopup(event);
        }
    }   

    private class ActionHandler implements ActionListener {
        Object target;
        public ActionHandler(String name, Object thing) {
            target = thing;
        }

        public void actionPerformed(ActionEvent e) {
            String action = e.getActionCommand();

            System.out.println("Do " + action + " on " + target);

            if(target instanceof Proxies.CrateProxy) {
                Proxies.CrateProxy crate = (Proxies.CrateProxy)target;
                if(action.equals("Clear RODs in crate")) {
                    JOptionPane.showMessageDialog(null, "Don't know that one yet");
                } else if(action.equals("Add ROD to crate")) {
                    try {
                        int [] RODs = config.listRodsInCrate(crate.partition(), crate.index());
                        RodConfig rConf = new RodConfig();

                        rConf.slaves = new sctConf.SlaveConfig[4];
                        for(int i=0; i<4; i++) {
                            rConf.slaves[i] = new SlaveConfig();
                            rConf.slaves[i].ipramFile = "";
                            rConf.slaves[i].idramFile = "";
                            rConf.slaves[i].extFile = "";
                        }

                        config.configureROD(crate.partition(), crate.index(), RODs.length, rConf);

                        Object [] path = new Object[3];

                        path[0] = "Partitions";
                        path[1] = configGui.getPartition(crate.partition());
                        path[2] = target;

                        treeModel.modified(path);
                    } catch(ConfigurationException c) {
                        JOptionPane.showMessageDialog(null, "ROD creation failed: " + c.detail);
                    }
                } else {
                    System.out.println("Unknown action " + action + " on Crate " + crate);
                }
            } else if(target instanceof Proxies.RodProxy) {
                Proxies.RodProxy r = (Proxies.RodProxy)target;
                if(action.equals("View ROD info")) {
                    JFrame frame = new JFrame("Modules in a ROD");
                    frame.getContentPane().add(new RODView(config, r));

                    frame.addWindowListener(new WindowAdapter() {
                            public void windowClosing(WindowEvent e) {
                                e.getWindow().dispose();
                            }
                        });
                    frame.pack();
                    frame.setVisible(true);
                } else if(action.equals("Add MUR to ROD")) {
                    // Need an MUR and a position // and a serial number 
                    // Would also like RMUR !
                    int [] myConf;
                    myConf = new int[100];

//                     MURSelectDialog dia = new MURSelectDialog(this);

                    System.out.println("Adding MUR in ROD " + r);

                    String [] labels = {"MUR index", "MUR position with ROD (0-7)"};
                    String [] defaults = {"0", "0"};

                    SelectionDialog dialog = new SelectionDialog(null, "Select MUR for ROD", labels, defaults);
//                     dialog.setROD(r); // (Proxies.RodProxy)target);
                    dialog.pack();
                    dialog.setVisible(true); 

                    try {
                        System.out.println("Got back some selections");
                        for(int i=0; i<2; i++) {
                            System.out.println(labels[i] + ": " + dialog.getIntFieldValue(i));
                        }

                        try {
                            config.mapRODMUR(r.partition(), r.crate(), r.index(), 
                                             dialog.getIntFieldValue(0), dialog.getIntFieldValue(1));

                            Object [] path = new Object[4];

                            path[0] = "Partitions";
                            path[1] = configGui.getPartition(r.partition());
                            path[2] = configGui.getCrate(r.crate(), r.partition());
                            path[3] = target;

                            treeModel.modified(path);
                        } catch(ConfigurationException ex) {
                            JOptionPane.showMessageDialog(null, "mapRODMUR failed with: " + ex.detail);
                        }
                    } catch(SelectionDialog.InvalidDialogException ide) {
                        JOptionPane.showMessageDialog(null, "Invalid entry for MUR");
                    } catch(SelectionDialog.CancelledDialogException i) {
                        // Cancel pressed
                    }
                } else {
                    System.out.println("Unknown action " + action + " on ROD ");
                }
            } else if(target instanceof Proxies.MurProxy) {
                Proxies.MurProxy mur = (Proxies.MurProxy)target;
                if(action.equals("Add Module to MUR")) {
                    String moduleName = null;
                    int position = -1;
                    {
                        ModuleListView moduleList = new ModuleListView(config);

                        Vector list = moduleList.getList();

                        if(list.size() == 0) {
                            JOptionPane.showMessageDialog(null, "No modules to select, add in module list");
                            return;
                        } else {
                            Object [] objList = new Object[list.size()];

                            list.copyInto(objList);

                            String item = (String)JOptionPane.showInputDialog((JComponent)(e.getSource()),
                                                                              "Select an unused module",
                                                                              "Module selector",
                                                                              JOptionPane.OK_CANCEL_OPTION,
                                                                              null, // JOptionPane.PLAIN_MESSAGE,
                                                                              objList,
                                                                              objList[0]);

                            System.out.println("Found a module! " + item); //  + ": " + list.get(item));

                            moduleName = item;
                        }
                    }

                    try {
                        String [] modules = config.listModulesInMUR(mur.partition(), mur.id());

                        int [] check = new int[6];
                        for(int i=0; i<modules.length; i++) {
                            IntHolder MUR = new IntHolder(), mod = new IntHolder();
                            config.translateFromSN(modules[i].toString(), MUR, mod);
                            check[mod.value-1] = 1;
                        }

                        Integer [] numList = new Integer[6 - modules.length];
                        int index = 0;
                        for(int i = 1; i<=6; i++) {
                            if(check[i-1] == 0) {
                                numList[index++] = new Integer(i);
                            }
                        }

                        if(modules.length < 6) {
                            Integer item = (Integer)JOptionPane.showInputDialog((JComponent)(e.getSource()),
                                                                                "Select an unused position",
                                                                                "Position selector",
                                                                                JOptionPane.OK_CANCEL_OPTION,
                                                                                null, 
                                                                                numList,
                                                                                numList[0]);

                            position = item.intValue();
                        } else {
                            JOptionPane.showMessageDialog(null, "No positions free in selected MUR");
                        }

                        System.out.println("Got position " + position);
                    } catch(ConfigurationException c) {
                        JOptionPane.showMessageDialog(null, "Bad configuration for getting MUR list: " + c.detail);
                    }

                    if(moduleName != null && position != -1) {
                        System.out.println("Mapping module " + moduleName + " in MUR " + mur.id() + " to number " + position);
                        try {
                            config.mapModuleMUR(mur.id(), position, mur.id(), (position%6)+1, moduleName);

                            Object [] path = new Object[5];

                            path[0] = "Partitions";
                            path[1] = configGui.getPartition(mur.partition());
                            path[2] = configGui.getCrate(mur.crate(), mur.partition());
                            path[3] = configGui.getRod(mur.rod(), mur.partition(), mur.crate());
                            path[4] = target;

                            for(int i=0; i<5; i++) {
                                System.out.println(i + ": " + path[i]);
                            }

                            treeModel.modified(path);
                        } catch(ConfigurationException c) {
                            JOptionPane.showMessageDialog(null, "Failed to map module to MUR: " + c.detail);
                        }
                    }
                } else if(action.equals("Edit MUR mappings")) {
                    System.out.println("Unsupported action " + action + " on MUR " + mur);
                } else {
                    System.out.println("Unknown action " + action + " on MUR " + mur);
                }
            } else if(target instanceof Proxies.ModuleProxy) {
                Proxies.ModuleProxy module = (Proxies.ModuleProxy)target;
                if(action.equals("View module configuration")) {
                    JFrame frame = new JFrame("Module view");

                    frame.getContentPane().add(new GuiComponents.Panels.ModuleConfigurationPanel(module.getSN()));

                    frame.addWindowListener(new WindowAdapter() {
                            public void windowClosing(WindowEvent e) {
                                e.getWindow().dispose();
                            }
                        });

                    frame.pack();

                    frame.setVisible(true);
                } else if(action.equals("Edit module mappings")) {
                    JFrame frame = new JFrame("Module " + module);
                    frame.getContentPane().add(new ModuleView(config, module));

                    frame.addWindowListener(new WindowAdapter() {
                            public void windowClosing(WindowEvent e) {
                                e.getWindow().dispose();
                            }
                        });

                    frame.pack();

                    frame.setVisible(true);
                } else if(action.equals("Unmap module")) {
                    try {
                        IntHolder MUR = new IntHolder(), num = new IntHolder();
                        config.translateFromSN(module.toString(), MUR, num);

                        Object [] path = new Object[6];

                        int realLength = 1;

                        path[0] = "Partitions";

                        try {
                            path[1] = configGui.getPartition(module.partition());
                            realLength ++;
                            path[2] = configGui.getCrate(module.crate(), module.partition());
                            realLength ++;
                            path[3] = configGui.getRod(module.rod(), module.partition(), module.crate());
                            realLength ++;
                            path[4] = configGui.getMUR(module.getMUR());
                            realLength ++;
                        } catch(ConfigurationException c) {
                            // Can't get value for this module (probably disappeared...?)
                        }

                        Object [] realPath = new Object[realLength];
                        for(int i=0; i<realLength; i++) { 
                            realPath[i] = path[i];
                            System.out.println(i + ": " + realPath[i]);
                        }

                        config.unmapModuleMUR(MUR.value, num.value);

                        treeModel.modified(realPath);
                    } catch(ConfigurationException c) {
                        // Couldn't unmap module...
                    }
                } else if(action.equals("Refresh")) {
                    Object [] path = new Object[6];

                    int realLength = 1;

                    path[0] = "Partitions";

                    try {
                        path[1] = configGui.getPartition(module.partition());
                        realLength ++;
                        path[2] = configGui.getCrate(module.crate(), module.partition());
                        realLength ++;
                        path[3] = configGui.getRod(module.rod(), module.partition(), module.crate());
                        realLength ++;
                        path[4] = configGui.getMUR(module.getMUR());
                        realLength ++;
                        path[5] = target;
                        realLength ++;
                    } catch(ConfigurationException c) {
                        // Can't get value for this module (probably disappeared...?)
                    }

                    Object [] realPath = new Object[realLength];
                    for(int i=0; i<realLength; i++) { 
                        realPath[i] = path[i];
                        System.out.println(i + ": " + realPath[i]);
                    }

                    treeModel.modified(realPath);
                } else {
                    System.out.println("Unknown action " + action + " on module " + module);
                }
            } else if(target.equals("Partitions")) { 
                if(action.equals("Clear everything")) {
                    try {
                        config.clearAll();

                        Object [] path = new Object[1];
                        path[0] = "Partitions";
                        treeModel.modified(path);

                    } catch(ConfigurationException c) {
                        JOptionPane.showMessageDialog(null, "Failed to clear all! " + c.detail);
                    }
                } else if(action.equals("Add ROD")) {
                    String [] labels = {"Partition", "Crate", "Index"};
                    String [] defaults = {"0", "0", "0"};
                    SelectionDialog dia = new SelectionDialog(null, "Add ROD", labels, defaults);

                    dia.pack();
                    dia.setVisible(true);

                    try {
                        for(int i=0; i<3; i++) {
                            System.out.println(labels[i] + ": " + dia.getIntFieldValue(i));
                        }

                        try {
                            sctConf.RodConfig rodConf = new sctConf.RodConfig();
                            rodConf.baseAddress = 0x01000000 * dia.getIntFieldValue(2);

                            rodConf.slaves = new sctConf.SlaveConfig[4];
                            for(int s=0; s<4; s++) {
                                rodConf.slaves[s] = new sctConf.SlaveConfig();
                                rodConf.slaves[s].ipramFile = "slaveRun_IPRAM.bin";
                                rodConf.slaves[s].idramFile = "slaveRun_IDRAM.bin";
                                rodConf.slaves[s].extFile = "slaveRun_xcode.bin";
                            }

                            config.configureROD(dia.getIntFieldValue(0), dia.getIntFieldValue(1), dia.getIntFieldValue(2), 
                                                rodConf);

                            System.out.println("ROD created");

                            Object [] path = new Object[1];
                            path[0] = "Partitions";
                            treeModel.modified(path);
                        } catch(ConfigurationException cex) {
                            JOptionPane.showMessageDialog(null, "Failed to create ROD: " + cex.detail);
                        }
                    } catch(SelectionDialog.InvalidDialogException ide) {
                        JOptionPane.showMessageDialog(null, "Invalid dialog values, ROD creating aborted");
                    } catch(SelectionDialog.CancelledDialogException i) {
                        // Cancel pressed
                    }
                } else if(action.equals("Add TIM")) {
                    String [] labels = {"Partition", "Crate"};
                    String [] defaults = {"0", "0"};
                    SelectionDialog dia = new SelectionDialog(null, "Add TIM", labels, defaults);

                    dia.pack();
                    dia.setVisible(true);

                    try {
                        for(int i=0; i<2; i++) {
                            System.out.println(labels[i] + ": " + dia.getIntFieldValue(i));
                        }

                        try {
                            sctConf.TimConfig timConf = new sctConf.TimConfig();
                            timConf.baseAddress = 0x0d000000;
                            timConf.trigFrequency = 60;    // kHz
                            timConf.resetFrequency = 10;   // Hz

                            config.configureTIM(dia.getIntFieldValue(0), dia.getIntFieldValue(1),
                                                timConf);

                            System.out.println("Tim created");

                            Object [] path = new Object[1];
                            path[0] = "Partitions";
                            treeModel.modified(path);
                        } catch(ConfigurationException cex) {
                            JOptionPane.showMessageDialog(null, "Failed to create TIM: " + cex.detail);
                        }
                    } catch(SelectionDialog.InvalidDialogException ide) {
                        JOptionPane.showMessageDialog(null, "Invalid dialog values, TIM creation aborted");
                    } catch(SelectionDialog.CancelledDialogException i) {
                        // Cancel pressed
                    }
                } else {
                    System.out.println("Unknown action " + action + " on Tree Root");
                }
            } else {
                System.out.println("Can't do that yet!");
            }
        }
    }

    public class MyModel implements TreeModel { // extends DefaultTreeModel {
        Configuration conf;

        java.util.Vector listeners;

        public MyModel(Configuration c) {
            //            super(new DefaultMutableTreeNode("Partitions"));
            conf = c;
            listeners = new java.util.Vector();
        }

        public Object getRoot() {
            return "Partitions";
        }

        public Object getChild(Object parent, int index) {
            System.out.print("getChild " + index + " of \"" + parent + "\": ");

            Object ret = null;
            try {
                if(parent.equals("Partitions")) {
                    ret = configGui.getPartition(index);
                } else if(parent instanceof Proxies.PartitionProxy) {
                    Proxies.PartitionProxy p = (Proxies.PartitionProxy)parent;
                    ret = configGui.getCrate(index, p.index());
                } else if(parent instanceof Proxies.CrateProxy) {
                    Proxies.CrateProxy c = (Proxies.CrateProxy)parent;
                    int[] RODs = config.listRodsInCrate(c.partition(), c.index());
                    ret = configGui.getRod(RODs[index], c.index(), c.partition());
                } else if(parent instanceof Proxies.RodProxy) {
                    Proxies.RodProxy r = (Proxies.RodProxy)parent;
                    int[] MURs = config.listMURSInRod(r.partition(), r.crate(), r.index());

                    IntHolder mapPart = new IntHolder(), mapCrate = new IntHolder(), mapROD = new IntHolder(), mapOrder = new IntHolder();
                    config.getMapMURROD(MURs[index], mapPart, mapCrate, mapROD, mapOrder);

                    // Is mapPart.value, mapCrate.value, mapROD.value == r.partition(), r.crate(), r.index() ??

                    ret = configGui.getMUR(mapOrder.value, MURs[index], r.partition(), r.crate(), r.index());
                } else if(parent instanceof Proxies.MurProxy) {
                    Proxies.MurProxy mur = (Proxies.MurProxy)parent;

                    System.out.print(" Asked for child " + index + " of MUR " + mur);

                    int moduleCount = 0;
                    String[] modules = config.listModulesInMUR(mur.partition(), mur.id());

                    ret = configGui.getModule(modules[index]);
                } else if(parent instanceof Proxies.ModuleProxy) {
                    Proxies.ModuleProxy m = (Proxies.ModuleProxy)parent;
                    IntHolder MUR = new IntHolder(), num = new IntHolder();
                    config.translateFromSN(m.toString(), MUR, num);
                    switch(index) {
                    case 0:
                        {
                            try {
                                MURType type = config.getMURType(MUR.value);

                                if(type == sctConf.MURType.BARREL) {
                                    IntHolder barrel = new IntHolder(), row = new IntHolder(), number = new IntHolder();
                                    config.translateToBarrel(MUR.value, num.value, 
                                                             barrel, row, number);
                                    ret = "Barrel " + barrel.value + " Row " + row.value + " Number " + number.value;
                                } else if(type == sctConf.MURType.ENDCAP) {
                                    IntHolder disk = new IntHolder(), quadrant = new IntHolder(), number = new IntHolder();
                                    config.translateToEndcap(MUR.value, num.value, 
                                                             disk, quadrant, number);
                                    ret = "Disk " + disk.value + " quadrant " + quadrant.value + " Number " + number.value;
                                } else {
                                    ret = "Unknown physical mapping";
                                } 
                            } catch(ConfigurationException e) {
                                ret = "Inconsistent physical mapping";
                            }
                            break;
                        }
                    case 1:
                        {
                            try {
                                IntHolder partition = new IntHolder(), crate = new IntHolder(), 
                                    rod = new IntHolder(), channel = new IntHolder();
                                config.translateToROD(MUR.value, num.value, 
                                                    partition, rod, crate, channel);
                                ret = partition.value + " " + rod.value + " " + crate.value + " " + channel.value;
                            } catch(ConfigurationException e) {
                                ret = "No ROD mapping defined";
                            }
                            break;
                        }
                    case 2:
                        {
                            try {
                                IntHolder partition = new IntHolder(), crate = new IntHolder(), 
                                    channel = new IntHolder();
                                config.translateToPowerSupply(MUR.value, num.value, 
                                                            partition, crate, channel);
                                ret = "Power: " + partition.value + " " + crate.value + " " + channel.value;
                            } catch(ConfigurationException e) {
                                ret = "No power mapping defined";
                            }
                            break;
                        }
                    case 3:
                        {
                            ret = "MUR " + MUR.value + ": " + num.value;
                            break;
                        }
                    case 4:
                        {
                            try {
                                config.getModuleConfig(m.getSN());
                                ret = "Module Configuration defined";
                            } catch(ConfigurationException e) {
                                ret = "No module configuration defined!";
                            }
                            break;
                        }
                    default:
                    }
                } else if(parent instanceof String) {
                    // Default?
                }
            } catch(ConfigurationException e) {
                ret = "Exception getting result";
            }

            System.out.println(".");
            return ret;
        }

        public int getChildCount(Object parent) {
            System.out.print("getChildCount of " + parent + ": ");

            int ret = 0;
            try {
                if(parent == null) {
                    ret = 0;
                } else if(parent.equals("Partitions")) {   // String
                    int[] parts = config.listPartitions();
                    ret = parts.length;
                } else if(parent instanceof Proxies.PartitionProxy) { 
                    Proxies.PartitionProxy p = (Proxies.PartitionProxy)parent;
                    int[] crates = config.listCratesInPartition(p.index());
                    ret = crates.length;
                } else if(parent instanceof Proxies.CrateProxy) { 
                    Proxies.CrateProxy c = (Proxies.CrateProxy)parent;
                    int[] rods = config.listRodsInCrate(c.partition(), c.index());
                    ret = rods.length;
                } else if(parent instanceof Proxies.RodProxy) {
                    Proxies.RodProxy r = (Proxies.RodProxy)parent;
                    int[] MURs = config.listMURSInRod(r.partition(), r.crate(), r.index());
                    ret = MURs.length;
                } else if(parent instanceof Proxies.MurProxy) {
                    Proxies.MurProxy mur = (Proxies.MurProxy)parent;

                    ret = config.listModulesInMUR(mur.partition(), mur.id()).length;
                } else if(parent instanceof Proxies.ModuleProxy) {
                    ret = 5;   // Number of mappings listed under a module
                } else if(parent instanceof String) {
                    ret = 0;
                } 
            } catch(ConfigurationException e) {
                ret = 0;
            }

            System.out.println(" " + ret + ".");
            return ret;
        }

        public int getIndexOfChild(Object parent,
                                   Object child) {
            System.out.print("getIndexOfChild (" + child + " within " + parent + "): ");
            int ret = -1;

            try {
                if(parent == null) {
                    ret = -1;
                } else if(parent.equals("Partitions")) {    // String
                    int[] parts = config.listPartitions();
                    int partition = ((Proxies.PartitionProxy)child).index();
                    for(int i=0; i<parts.length; i++) {
                        if(parts[i] == partition) 
                            ret = i;
                    }
                } else if(parent instanceof Proxies.PartitionProxy) { 
                    Proxies.CrateProxy c = (Proxies.CrateProxy)child;
                    Proxies.PartitionProxy p = (Proxies.PartitionProxy)parent;
                    int[] crates = config.listCratesInPartition(p.index());

                    int crate = c.index();
                    for(int i=0; i<crates.length; i++) {
                        if(crates[i] == crate) 
                            ret = i;
                    }
                } else if(parent instanceof Proxies.CrateProxy) { 
                    Proxies.RodProxy r = (Proxies.RodProxy)child;
                    Proxies.CrateProxy c = (Proxies.CrateProxy)parent;
                    int[] rods = config.listRodsInCrate(c.partition(), c.index());

                    int rod = r.index();
                    for(int i=0; i<rods.length; i++) {
                        if(rods[i] == rod) 
                            ret = i;
                    }
                } else if(parent instanceof Proxies.RodProxy) { 
                    Proxies.MurProxy mur = (Proxies.MurProxy)child;
                    Proxies.RodProxy r = (Proxies.RodProxy)parent;
                    int[] murs = config.listMURSInRod(r.partition(), r.crate(), r.index());

                    int murId = mur.id();
                    for(int i=0; i<murs.length; i++) {
                        if(murs[i] == murId) 
                            ret = i;
                    }
                } else if(parent instanceof Proxies.MurProxy) { 
                    Proxies.ModuleProxy module = (Proxies.ModuleProxy)child;
                    Proxies.MurProxy mur = (Proxies.MurProxy)parent;
                    String[] modules = config.listModulesInMUR(mur.partition(), mur.index());

                    String sn = module.getSN();
                    for(int i=0; i<modules.length; i++) {
                        if(modules[i].equals(sn)) {
                            ret = i;
                            break;
                        }
                    }

                    // Aside
                    IntHolder MUR = new IntHolder(), mod = new IntHolder();
                    config.translateFromSN(module.toString(), MUR, mod);

                    if(MUR.value != mur.id()) {
                        System.out.print("\n  (translateFromSN returned MUR " + MUR.value + " Stored is " + mur.id() + "!)");
                    }
                } else if(parent instanceof Proxies.ModuleProxy) { 
                    ret = 0; 

                    System.out.print("(Count strings...)");

                    for(int i=0; i<5; i++) {
                        if(getChild(parent, i).equals(child)) {
                            ret = i;
                            break;
                        }
                    }
                } else if(parent instanceof String) { 
                    // Already checked for being "Partitions"
                    ret = -1;
                } 
            } catch(ConfigurationException e) {
                ret = 0;
            }
            System.out.println(" " + ret + ".");
            return ret;
        }

        public boolean isLeaf(Object node) {
            if(node instanceof String) {
                if(node != "Partitions") {
                    return true;
                }
            }
            return false;
        }

        public void valueForPathChanged(TreePath path,
                                        Object newValue) {
        }

        public void addTreeModelListener(TreeModelListener l) {
            System.out.println("Add listener " + l);
            listeners.add(l);
        }

        public void removeTreeModelListener(TreeModelListener l) {
            System.out.println("Remove listener " + l);
            listeners.remove(l);
        }

        // Everything has changed (ignores o!)
        public void modified(Object o) {
            for(Enumeration e = listeners.elements(); e.hasMoreElements(); ) {
                TreeModelListener t = (TreeModelListener)e.nextElement();

                Object [] path = new Object[1];

                path[0] = "Partitions";

                TreeModelEvent ev = new TreeModelEvent(this, path);

                t.treeStructureChanged(ev);
            }
        }

        // Structure has changed around specified node
        public void modified(Object [] path) {
            for(Enumeration e = listeners.elements(); e.hasMoreElements(); ) {
                TreeModelListener t = (TreeModelListener)e.nextElement();

                TreeModelEvent ev = new TreeModelEvent(this, path);

                // Use structureChanged because eg NodesChanged requires more information (ie where the changed nodes are in the parent...)
                t.treeStructureChanged(ev);
            }
        }
    }
}
