package GuiComponents.SctConf;

import sctConf.*;
import ipc.*;

// import java.util.Enumeration;
// import java.util.Vector;

import org.omg.CORBA.IntHolder;

public class Proxies {
    protected sctConf.Configuration config;

    public Proxies(sctConf.Configuration conf) {
        config = conf;

	if (config==null) {
	    System.err.println("Error (check configuration running)");
	    System.exit(0);
	}
        System.out.println("Found configuration");
    }

    public PartitionProxy getPartition(int i) {
        return new PartitionProxy(i);
    }

    public class PartitionProxy { // implements ActionListener, TreeNode {
        private int m_i;

        PartitionProxy(int i) { m_i = i; }

        public int index() { return m_i; }
        public String toString() {
            return "Partition " + m_i;
        }
    }

    public CrateProxy getCrate(int i, int part) {
        return new CrateProxy(i, part);
    }

    public class CrateProxy {
        int m_i;
        int p;
        CrateProxy(int i, int part) { m_i = i; p = part; }
        public int index() { return m_i; }
        public int partition() { return p; }
        public String toString() {
            return "Crate " + p + " " + m_i;
        }
    }

    public RodProxy getRod(int i, int part, int crate) {
        return new RodProxy(i, part, crate);
    }

    public class RodProxy {
        int m_i;
        int p, c;
        RodProxy(int i, int crate, int part) { m_i = i; c = crate; p = part; }
        public int partition() { return p; }
        public int crate() { return c; }
        public int index() { return m_i; }
        public String toString() {
            return "Rod " + p + " " + c + " " + m_i;
        }
    }

    public MurProxy getMUR(int order, int mur, int part, int crate, int rod) {
        return new MurProxy(order, mur, part, crate, rod);
    }

    public MurProxy getMUR(int mur) throws ConfigurationException {
        IntHolder mapPart = new IntHolder(), mapCrate = new IntHolder(), mapROD = new IntHolder(), mapOrder = new IntHolder();
        config.getMapMURROD(mur, mapPart, mapCrate, mapROD, mapOrder);

        return new MurProxy(mapOrder.value, mur, mapPart.value, mapCrate.value, mapROD.value);
    }

    public class MurProxy {
        int m_MUR, m_i;
        int m_p, m_c, m_r;
        MurProxy(int i, int mur, int partition, int crate, int rod) { m_MUR = mur; m_i = i; m_c = crate; m_p = partition; m_r = rod; }
        public int partition() { return m_p; }
        public int crate() { return m_c; }
        public int rod() { return m_r; }
        /// Index within ROD
        public int index() { return m_i; }
        /// Global ID
        public int id() { return m_MUR; }
        public String toString() {
            return "MUR " + m_MUR + " at " + m_i + " in " + m_p + " " + m_c + " " + m_r;
        }
    }

    public ModuleProxy getModule(String sn) {
        return new ModuleProxy(sn);
    }

    public class ModuleProxy {
        String sn;
        ModuleProxy(String sNum) { sn = sNum; }
        public String toString() {
            return sn;
        }
        public String getSN() {
            return sn;
        }

        public String getMURString() {
            try {
                IntHolder MUR = new IntHolder(), num = new IntHolder();
                config.translateFromSN(sn, MUR, num);
                return "MUR: " + MUR.value + " index: " + num.value;
            } catch(ConfigurationException e) {
                return "No mapping to MUR";
            }
        }

        public sctConf.MURType getMURType() {
            try {
                IntHolder MUR = new IntHolder(), num = new IntHolder();
                config.translateFromSN(sn, MUR, num);
                return config.getMURType(MUR.value);
            } catch(ConfigurationException c) {
                return sctConf.MURType.UNKNOWN;
            }
        }

        public int getMUR() throws ConfigurationException {
            IntHolder MUR = new IntHolder(), num = new IntHolder();
            config.translateFromSN(sn, MUR, num);
            return MUR.value;
        }

        public String getPowerString() {
            try {
                IntHolder MUR = new IntHolder(), num = new IntHolder();
                config.translateFromSN(sn, MUR, num);

                IntHolder partition = new IntHolder(), crate = new IntHolder(), 
                    channel = new IntHolder();
                config.translateToPowerSupply(MUR.value, num.value, partition, crate, channel);
                return "Power: " + partition.value + " " + crate.value + " " + channel.value;
            } catch(ConfigurationException e) {
                return "Power mapping undefined";
            }
        }

        public String getRODString() {
            try {
                IntHolder MUR = new IntHolder(), num = new IntHolder();
                config.translateFromSN(sn, MUR, num);

                IntHolder partition = new IntHolder(), crate = new IntHolder(), 
                    rod = new IntHolder(), channel = new IntHolder();
                config.translateToROD(MUR.value, num.value, 
                                    partition, rod, crate, channel);
                return "Partition: " + partition.value + " Crate: " + crate.value 
                    + " ROD: " + rod.value + " Channel: " + channel.value;
            } catch(ConfigurationException e) {
                return "No mapping for ROD";
            }
        }

        public int partition() throws ConfigurationException {
            IntHolder MUR = new IntHolder(), num = new IntHolder();
            config.translateFromSN(sn, MUR, num);

            IntHolder partition = new IntHolder(), crate = new IntHolder(), 
                rod = new IntHolder(), channel = new IntHolder();
            config.translateToROD(MUR.value, num.value, 
                                partition, rod, crate, channel);
            return partition.value;
        }

        public int crate() throws ConfigurationException {
            IntHolder MUR = new IntHolder(), num = new IntHolder();
            config.translateFromSN(sn, MUR, num);

            IntHolder partition = new IntHolder(), crate = new IntHolder(), 
                rod = new IntHolder(), channel = new IntHolder();
            config.translateToROD(MUR.value, num.value, 
                                partition, rod, crate, channel);
            return crate.value;
        }

        public int rod() throws ConfigurationException {
            IntHolder MUR = new IntHolder(), num = new IntHolder();
            config.translateFromSN(sn, MUR, num);

            IntHolder partition = new IntHolder(), crate = new IntHolder(), 
                rod = new IntHolder(), channel = new IntHolder();
            config.translateToROD(MUR.value, num.value, 
                                partition, rod, crate, channel);
            return rod.value;
        }

        public String getRRODString() {
            try {
                IntHolder MUR = new IntHolder(), num = new IntHolder();
                config.translateFromSN(sn, MUR, num);

                IntHolder partition = new IntHolder(), crate = new IntHolder(), 
                    rod = new IntHolder(), channel = new IntHolder();
                config.translateToRROD(MUR.value, num.value, 
                                    partition, rod, crate, channel);
                return "Redundant connection to:\nPartition: " + partition.value + " Crate: " + crate.value 
                    + " ROD: " + rod.value + " Channel: " + channel.value;
            } catch(ConfigurationException e) {
                return "No redundant mapping for ROD";
            }
        }

        public String getPhysicalString() {
            try {
                IntHolder MUR = new IntHolder(), num = new IntHolder();
                config.translateFromSN(sn, MUR, num);

                if(getMURType() == sctConf.MURType.BARREL) {
                    IntHolder barrel = new IntHolder(), row = new IntHolder(), number = new IntHolder();
                    config.translateToBarrel(MUR.value, num.value, 
                                           barrel, row, number);
                    return "Barrel: " + barrel.value + " Row: " + row.value + " Position: " + number.value;
                } else if(getMURType() == sctConf.MURType.ENDCAP) {
                    IntHolder disk = new IntHolder(), quadrant = new IntHolder(), number = new IntHolder();
                    config.translateToEndcap(MUR.value, num.value, 
                                           disk, quadrant, number);
                    return "Disk: " + disk.value + " Quadrant: " + quadrant.value + " Position: " + number.value;
                } else if(getMURType() == sctConf.MURType.UNMAPPED) {
                    return "No mapping to physical structure";
                } else if(getMURType() == sctConf.MURType.UNKNOWN) {
                    return "MUR of module is unknown (database inconsistent)";
                } else {
                    return "Unknown MUR type returned";
                }
            } catch(ConfigurationException e) {
                return "No mapping to physical structure";
            }
        }
    }
}
