package GuiComponents.SctConf;

import java.util.Enumeration;
import java.util.Vector;
import java.awt.Dimension;
import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;

import org.omg.CORBA.IntHolder;

import sctConf.Configuration;
import sctConf.ConfigurationException;

public class PowerMappings extends JPanel {
    private sctConf.Configuration config;

//     private JTable table;

    private JPopupMenu popup;

    private FullModel fullModel;
    private DefaultModel defaultModel;

    String paramList[];

    String runMode;

    public PowerMappings(Configuration conf) {
        config = conf;

        try {
            paramList = config.listDefaultPowerParams();
        } catch(ConfigurationException cex) {
            paramList = new String[0];
        }

        fullModel = new FullModel(config);
        defaultModel = new DefaultModel(config);

/*        JTable fullTable = new JTable(fullModel);
        JTable defaultTable = new JTable(defaultModel);

        setLayout(new BorderLayout());

        JScrollPane tableView1 = new JScrollPane(defaultTable);
        tableView1.setPreferredSize(new Dimension(100, 100));

        JScrollPane tableView2 = new JScrollPane(fullTable);
        tableView2.setPreferredSize(new Dimension(500, 300));

        JSplitPane split = new JSplitPane(JSplitPane.VERTICAL_SPLIT, tableView1, tableView2);

        add(split); */


//         enableEvents(java.awt.AWTEvent.WINDOW_EVENT_MASK);
// //         tree.addMouseListener(new MouseClickHandler());


//         popup = new JPopupMenu();
//         popup.add(new JMenuItem("Do nothing"));

        initComponents();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        jSplitPane1 = new javax.swing.JSplitPane();
        jScrollPane1 = new javax.swing.JScrollPane();
        jTable1 = new javax.swing.JTable();
        jScrollPane2 = new javax.swing.JScrollPane();
        jTable2 = new javax.swing.JTable();
        jPanel1 = new javax.swing.JPanel();
        stateCombo = new javax.swing.JComboBox();

        setLayout(new java.awt.BorderLayout());

        jSplitPane1.setOrientation(javax.swing.JSplitPane.VERTICAL_SPLIT);
        jScrollPane1.setPreferredSize(new java.awt.Dimension(100, 100));
        jTable1.setModel(defaultModel);
        jScrollPane1.setViewportView(jTable1);

        jSplitPane1.setLeftComponent(jScrollPane1);

        jScrollPane2.setPreferredSize(new java.awt.Dimension(500, 300));
        jTable2.setModel(fullModel);
        jScrollPane2.setViewportView(jTable2);

        jSplitPane1.setRightComponent(jScrollPane2);

        add(jSplitPane1, java.awt.BorderLayout.CENTER);

        stateCombo.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "OFF", "STANDBY", "ON" }));
        jPanel1.add(stateCombo);

        add(jPanel1, java.awt.BorderLayout.NORTH);

    }//GEN-END:initComponents

    private class MouseClickHandler extends MouseAdapter {
        private JMenuItem menuWithAction(String name, Object thing) {
            JMenuItem result = new JMenuItem(name);
//             result.addActionListener(new ActionHandler(name, thing));

            return result;
        }

        private void checkPopup(MouseEvent event) {
        }
        public void mousePressed(MouseEvent event){
            checkPopup(event);
        }
        public void mouseReleased(MouseEvent event){
            checkPopup(event);
        }
    }   

    /**
     * Table model for upper table:
     *  Default parameters
     */
    public class DefaultModel extends AbstractTableModel {
        String columnNames[] = {"Parameter", "Nominal", "LowWarning", "LowError", "HighWarning", "HighError"};
        
        Configuration conf;

//         java.util.Vector listeners;

//         String [] defaultList;

        public DefaultModel(Configuration c) {
            conf = c;
//             listeners = new java.util.Vector();
        }

        public int getColumnCount() { 
            return 2; 
        }

        public int getRowCount() { 
//             String [] defaultList = config.listDefaultPowerParams();
            return paramList.length + 1;
        }

        public Object getValueAt(int row, int col) { 
            if(row == paramList.length) {
                return "";
            } else {
                switch(col) {
                case 0:
                    return paramList[row];
                case 1:
//                     try {
//                         return "";// new Float(config.getDefaultPowerParam(paramList[row]));
//                     } catch(ConfigurationException c) {
                    return "Undefined!";
//                     }
                default:
                    return null;
                }
            }
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            if(rowIndex == paramList.length) {
                if(columnIndex == 0) {
                    return true;
                } else {
                    return false;
                }
            } else {
                if(columnIndex > 0) {
                    return true;
                } else {
                    return false;
                }
            }
        }

        public String getColumnName(int column) {
            if(column > 0 && column < columnNames.length) {
                return columnNames[column];
            } else {
                return "Unknown";
            }
        }

        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if(columnIndex == 0) {
//                 try {
//                     float val = 0.0f;
//                     // config.modifyDefaultPowerParam((String)aValue, val);

//                     try {
//                         paramList = config.listDefaultPowerParams();
//                     } catch(ConfigurationException cex) {
//                         // Hmmm...
//                     }

//                     // Rather over the top...
//                     fireTableStructureChanged();
//                 } catch(ConfigurationException c) {
                    JOptionPane.showMessageDialog(null, "Failed to configure default power param: Bad GUI");
//                 }
            } else {
//                 try {
//                     // config.modifyDefaultPowerParam(paramList[rowIndex], Float.parseFloat((String)aValue));
//                 } catch(ConfigurationException c) {
                    JOptionPane.showMessageDialog(null, "Failed to configure default power param: Bad GUI");
//                 }
            }
        }
    }

    /**
     * Table model for lower table:
     *  All parameters including module mappings
     */
    public class FullModel extends AbstractTableModel {
        String columnNames[] = {"Module", "Crate", "Channel", "Parameter", "Nominal", "LowWarning", "LowError", "HighWarning", "HighError"};

        Configuration config;

//         java.util.Vector listeners;

//         String [] paramList;
        String [] moduleList;

        public FullModel(Configuration c) {
            config = c;
//             listeners = new java.util.Vector();

            try {
                paramList = config.listDefaultPowerParams();
            } catch(ConfigurationException cex) {
                paramList = null;
            }

            try {
                moduleList = config.listAllModules();
            } catch(ConfigurationException cex) {
                moduleList = null;
            }
        }

        public int getColumnCount() { 
            return columnNames.length; 
        }

        public int getRowCount() { 
            return paramList.length * moduleList.length;
        }

        public Object getValueAt(int row, int col) { 
            String name = columnNames[col];

            if(name.equals("Module")) {
                return moduleList[row / paramList.length];
            } else if(name.equals("Parameter")) {
                return paramList[row % paramList.length];
            } else if(name.equals("Crate")) {
                return crateForModule(row);
            } else if(name.equals("Channel")) {
                return channelForModule(row);
            } else if(name.equals("Nominal")) {
                return parameterForModule(row, "N");
            } else if(name.equals("HighWarning")) {
                return parameterForModule(row, "HW");
            } else if(name.equals("LowWarning")) {
                return parameterForModule(row, "LW");
            } else if(name.equals("HighError")) {
                return parameterForModule(row, "HE");
            } else if(name.equals("LowError")) {
                return parameterForModule(row, "LE");
            } else {
                return "Unknown";
            }
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            if(columnIndex > 1) {
                return true;
            } else {
                return false;
            }
        }

        public String getColumnName(int column) {
            if(column > 0 && column < columnNames.length) {
                return columnNames[column];
            } else {
                return "Unknown";
            }
        }

        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if(columnIndex == 2) {
                try {
                    IntHolder MUR = new IntHolder(), num = new IntHolder();
                    config.translateFromSN(moduleList[rowIndex / paramList.length], MUR, num);
//                 return new Float(config.getPowerParam(MUR.value, num.value, paramList[row % paramList.length]));
//                 } catch(ConfigurationException c) {

                    // config.modifyPowerParam(MUR.value, num.value, paramList[rowIndex % paramList.length], 
                    //                                       Float.parseFloat((String)aValue));
                } catch(ConfigurationException c) {
                    JOptionPane.showMessageDialog(null, "Failed to configure power param: " + c.detail);
                }
            } else {
                // Impossible!
            }
        }

        Object crateForModule(int row) {
            return "unimplemented";
        }

        Object channelForModule(int row) {
            return "unimplemented";
        }

        Object parameterForModule(int row, String code) {
            String sn = moduleList[row / paramList.length];
            String param = paramList[row % paramList.length] + "_" + code;
            
            IntHolder MUR = new IntHolder(), num = new IntHolder();
            try {
                config.translateFromSN(sn, MUR, num);
            } catch(ConfigurationException c) {
                return "UnMapped!";
            }
//             try {
//                 return ""; // new Float(config.getPowerParam(MUR.value, num.value, param));
//             } catch(ConfigurationException c) {
                return "Undefined!";
//             }
        }
    }  // End FullTableModel

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel jPanel1;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JScrollPane jScrollPane2;
    private javax.swing.JSplitPane jSplitPane1;
    private javax.swing.JTable jTable1;
    private javax.swing.JTable jTable2;
    private javax.swing.JComboBox stateCombo;
    // End of variables declaration//GEN-END:variables
    
}
