package GuiComponents.SctConf;

import javax.swing.*;
import javax.swing.event.*;
import java.awt.*;
import java.awt.event.*;

import java.util.Vector;

public class ModuleListView extends JPanel {
    sctConf.Configuration config;
//      ConfigGui.Module module;

    JList moduleList;

    boolean unused;

    public ModuleListView(sctConf.Configuration conf) {
//          module = mod;
        config = conf;

        unused = true;

        setLayout(new BorderLayout());
        JPanel buttons = new JPanel();

        JCheckBox unusedCheck = new JCheckBox("Unused", unused);
        unusedCheck.addChangeListener(new ChangeListener() {
                public void stateChanged(ChangeEvent e) {
                    System.out.println("CheckBox state changed");

                    boolean tempUnused = ((ButtonModel)((JCheckBox)(e.getSource())).getModel()).isSelected();
                    System.out.println("To " + tempUnused);

                    if(tempUnused != unused) {
                        System.out.println("Updating");
                        unused = tempUnused;
                        updateList();
                    }
                }
            });
        buttons.add(unusedCheck);

        JButton addButton = new JButton("Add");
        addButton.addActionListener(new ActionListener() {
                public void actionPerformed(ActionEvent e) {
                    String fileNames[] = getFileNames();

                    if(fileNames != null) {
                        for(int f=0; f<fileNames.length; f++) {
                            System.out.println("Add a module to the list using the configuration in file " + fileNames[f]);

                            try {
                                config.configureModuleFromFile(fileNames[f]);
                            } catch(sctConf.ConfigurationException ex) {
                                JOptionPane.showMessageDialog(null, "Failed to add " + fileNames[f] + " due to " + ex.detail);
                            }
                        }
                        updateList();
                    }
                }
            });
        buttons.add(addButton);

        JButton close = new JButton("Close");
        close.addActionListener(new ActionListener() {
                public void actionPerformed(ActionEvent e) {
                    ((Window)getTopLevelAncestor()).dispose();
                }
            });
        buttons.add(close);

        add(buttons, BorderLayout.SOUTH);

        moduleList = new JList(getList());
        moduleList.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        moduleList.setSelectedIndex(0);

        JScrollPane listScrollPane = new JScrollPane(moduleList);
        add(listScrollPane, BorderLayout.CENTER);
        validate();

        updateList();
    }

    void updateList() {
        moduleList.setListData(getList());
    }

    public Vector getList() {
        Vector result = new Vector();

        try {
            String[] modules;

            if(unused) modules = config.listUnusedModules();
            else modules = config.listAllModules();

            for(int i=0; i<modules.length; i++) {
                result.addElement(modules[i]);
                System.out.println(modules[i]);
            }

//             int[] parts = config.listPartitions();
//             for(int p=0; p<parts.length; p++) {
//                 int[] crates = config.listCratesInPartition(parts[p]);
//                 for(int c=0; c<crates.length; c++) {
//                     int[] rods = config.listRodsInCrate(parts[p], crates[c]);
//                     for(int r=0; r<rods.length; r++) {
//                         int[] MURs = config.listMURSInRod(parts[p], crates[c], rods[r]);
//                         for(int mur=0; mur<MURs.length; mur++) {
//                             String[] modules = config.listModulesInMUR(parts[p], MURs[mur]);
//                             for(int m=0; m<modules.length; m++) {
//                                 result.addElement(modules[m]);
//                             }
//                         }
//                     }
//                 }
//             }
        } catch(sctConf.ConfigurationException e) {
            System.out.println("Java caught an exception!: " + e.detail);
        }

        System.out.println("Returned list of " + result.size() + " modules");

        return result;
    }

    /// Return selected module
    public String getSelected() {
        return (String)(moduleList.getSelectedValue());
    }

    static JFileChooser fileChooser;

    { fileChooser = null; }

    static String[] getFileNames() {
        if(fileChooser == null) {
            fileChooser = new JFileChooser();
        }

        fileChooser.setMultiSelectionEnabled(true);

        if(fileChooser.showDialog(null, "Pick module configuration file(s)") == JFileChooser.APPROVE_OPTION) {
          java.io.File files[] = fileChooser.getSelectedFiles();
          String [] result = new String[files.length];

          for(int i=0; i<files.length; i++) {
              result[i] = files[i].toString();
          }
          return result;
        } else {
          return null;
        }
    }
}

