package GuiComponents.SctConf;

import javax.swing.event.AncestorListener;
import javax.swing.event.AncestorEvent;

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;

import java.io.File;

import java.util.Vector;

import org.omg.CORBA.IntHolder;
import org.omg.CORBA.StringHolder;

import sctConf.*;
import Sct.gui.SelectionDialog;

public class MURPanelBrief extends JPanel {
    sctConf.Configuration config;
    Proxies.RodProxy rod;

    int mur;
    int order;

    /// If type is 1 then read only sub-panel otherwise editable
    public MURPanelBrief(Configuration conf, Proxies.RodProxy r, int o) {
        rod = r;
        config = conf;
        order = o;

        try {
            IntHolder MUR = new IntHolder();

            config.getMapRODMUR(rod.partition(), rod.crate(), rod.index(), order, MUR);
            mur = MUR.value;
        } catch(NullPointerException e) {
            mur = 1;
        } catch(ConfigurationException e) {
            mur = -1;
        }

        initComponents();
        buildGUI();
    }

    public static void main(String args[]) {
        JFrame frame = new JFrame("Test Brief MUR Panel");
        frame.getContentPane().add(new MURPanelBrief(null, null, 1));
        frame.pack();
        frame.setVisible(true);
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        jLabel1 = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        jLabel3 = new javax.swing.JLabel();
        jLabel4 = new javax.swing.JLabel();
        jLabel5 = new javax.swing.JLabel();
        jLabel6 = new javax.swing.JLabel();
        jButton1 = new javax.swing.JButton();

        setLayout(new javax.swing.BoxLayout(this, javax.swing.BoxLayout.Y_AXIS));

        setBorder(new javax.swing.border.TitledBorder(getTitle()));
        jLabel1.setText(getModuleName(0));
        add(jLabel1);

        jLabel2.setText(getModuleName(1));
        add(jLabel2);

        jLabel3.setText(getModuleName(2));
        add(jLabel3);

        jLabel4.setText(getModuleName(3));
        add(jLabel4);

        jLabel5.setText(getModuleName(4));
        add(jLabel5);

        jLabel6.setText(getModuleName(5));
        add(jLabel6);

        jButton1.setText("Edit");
        jButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                editButtonPerformed(evt);
            }
        });

        add(jButton1);

    }//GEN-END:initComponents

    private void editButtonPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_editButtonPerformed
        JFrame frame = new JFrame("MUR editor");

        frame.getContentPane().add(new MURPanel(config, rod, getPosition()), BorderLayout.CENTER);

        frame.pack();
        frame.setVisible(true);
    }//GEN-LAST:event_editButtonPerformed

    void buildGUI() {
        validate();
    }

    String getTitle() {
        if(mur == -1) {
            return " position " + getPosition();
        } else {
            return "MUR " + mur;
        }
    }

    String getModuleName(int id) {
        int channel = order*6 + id;

        StringHolder serial = new StringHolder();

        IntHolder MUR = new IntHolder(), num = new IntHolder();

        try {
            config.translateFromROD(rod.partition(), rod.crate(), rod.index(), channel, MUR, num);
            config.translateToSN(MUR.value, num.value, serial);
        } catch(ConfigurationException e) {
            return "No module";
        }

        return serial.value;
    }

    int getPosition() {
        return order;
    }

    static JFileChooser fileChooser;

    { fileChooser = null; }

    static String getFileName() {
        if(fileChooser == null) {
            fileChooser = new JFileChooser();
        }

        if(fileChooser.showDialog(null, "Pick module configuration file") == JFileChooser.APPROVE_OPTION) {
          File file = fileChooser.getSelectedFile();
          return file.toString();
        } else {
          return null;
        }
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButton1;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabel6;
    // End of variables declaration//GEN-END:variables
}
