package GuiComponents.SctApi;

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;

public class TriggerSelect extends JDialog {
    Sct_SctApi.SctApi api;
    Sct_SctApi.Trigger trigger;

    String [] comboStrings = {"L1A", "L1A+L1A", "CAL+L1A", "P+L1A", 
                              "SR+L1A", "SR+CAL+L1A", "SR+P+L1A", 
                              "BCR+L1A", "BCR+CAL+L1A", "BC+P+L1A"};

    JComboBox combo;

    JTextField delay1Text;
    JTextField delay2Text;
    JTextField delayText;
    JTextField incText;

    TriggerSelect(Sct_SctApi.SctApi a, Sct_SctApi.Trigger trig) {
        super((JFrame)null, "Edit trigger", true);

        api = a;
        trigger = trig;

//         setLayout(new BorderLayout());

        JPanel controls = new JPanel();

        combo = new JComboBox(comboStrings);
        controls.add(new JLabel("Trigger Type"));
        controls.add(combo);

        controls.add(new JLabel("Delay1"));
        delay1Text = new JTextField("0", 5);
        controls.add(delay1Text);
        controls.add(new JLabel("Delay2"));
        delay2Text = new JTextField("0", 5);
        controls.add(delay2Text);

        controls.add(new JLabel("Delay To Increment"));
        delayText = new JTextField("0", 5);
        controls.add(delayText);
        controls.add(new JLabel("Increment"));
        incText = new JTextField("0", 5);
        controls.add(incText);

        getContentPane().add(controls);
    }

    void modifyTrigger() {
        String type = (String)combo.getSelectedItem();

        short delay1 = Short.parseShort(delay1Text.getText());
        short delay2 = Short.parseShort(delay2Text.getText());

        if(type.equals("L1A")) { trigger.singleL1A(); }
        else if(type.equals("L1A+L1A")) { trigger.doubleL1A(delay1); }
        else if(type.equals("CAL+L1A")) { trigger.calL1A(delay1); }
        else if(type.equals("P+L1A")) { trigger.pulseL1A(delay1); }
        else if(type.equals("SR+L1A")) { trigger.softL1A(delay1); }
        else if(type.equals("SR+CAL+L1A")) { trigger.softCalL1A(delay1, delay2); }
        else if(type.equals("SR+P+L1A")) { trigger.softPulseL1A(delay1, delay2); }
        else if(type.equals("BCR+L1A")) { trigger.bcL1A(delay1); }
        else if(type.equals("BCR+CAL+L1A")) { trigger.bcCalL1A(delay1, delay2); }
        else if(type.equals("BC+P+L1A")) { trigger.bcPulseL1A(delay1, delay2); }
        else {
            // Bad trigger type...
        }

        short delayIncr = Short.parseShort(delayText.getText());
        short increment = Short.parseShort(incText.getText());

        if(delayIncr == 0) {
            trigger.setCommIncr((short)1, increment);
        } else if(delayIncr == 1) {
            trigger.setCommIncr((short)3, increment);
        }
    }
}
