package GuiComponents.SctApi;

import javax.swing.*;
import javax.swing.table.*;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.JTableHeader;
import java.lang.Math;
import java.lang.Object;

import GuiComponents.System.SystemInterface;
//for cell color
import java.awt.Component;
import java.awt.Color;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;


//this class represent the main panel
public class HarnessTestView extends JPanel {
    Sct_SctApi.SctApi api;

    SystemInterface sys;
    sctConf.Configuration conf;

    int maxHarnessOnROD = 8;
    int maxDoglegNumberInHarness = 6;

    short ps_state = 2; //Deafult = STANDBY STATE (ps_state=2)
    String passedFailed;
    String dataFile;

    org.omg.CORBA.IntHolder  murID;

    int m_partition = 0;
    int m_crate = 0;
    int m_rod = 0;
    int m_select = -1;

    int [] m_harnessList;
    int m_harnessMax = 0;
    int m_rxThreshold = 128;
    int m_txCurrent = 160;
    short [][] m_daq_scanResults;  
    float [][] m_dcs_scanResults; 
    String[][] m_daq_scanResultsTable;
    String[][] m_dcs_scanResultsTable;
    String[][][] m_summary_scanResults;
    /*
    String [] psChannelParametersList = {"LVchCLKS","LVch_Vcc", "LVch_Icc", "LVch_Vdd", "LVch_Idd", 
					 "LVchVCSV", "LVchVCSI", "LVchPINV", "LVchPINI", 
					 "MOch_Tm0", "MOch_Tm1", "LVps_Vcc", "LVps_Vdd",    
					 "LVretVcc", "LVretVdd", "HVchVolt", "HVchCurr"};*/

    String [] psChannelParametersList = {"LVchStat", "LVch_Icc", "LVch_Idd", "LVchVCSI", "LVchPINI","MOch_Tm0", 
					 "MOch_Tm1", "HVchCurr"};
    /*
    String [] psChannelParametersList_short = {"CLKS","Vcc","Icc", "Vdd", "Idd", 
					       "VCSV", "VCSI", "PINV", "PINI", 
					       "Tm0", "Tm1", "psVcc", "psVdd",    
					       "retVcc", "retVdd", "HV", "HVCu"};*/

    String [] psChannelParametersList_short = {"Status", "Icc", "Idd", "VCSI", "PINI", "Tm0", "Tm1", "HVCu"};

    //upper and lower limits for each parameter in the previous list
float psChannelParametersLimits[][] = 
    { 
	{(float)-999999, (float)999999},     //"LVchStat"// nosense limits
	{(float)35, (float)105},     //"LVch_Icc"
	{(float)175, (float)245},    //"LVch_Idd"
	{(float)1.80,(float)2.40 },  //"LVchVCSI"
	{(float)0.1, (float)0.3},    //"VchPINI"
	{(float)20, (float)30},      //"MOch_Tm0"
	{(float)5, (float)15},        //"MOch_Tm1"
	{(float)19, (float)21},      //"HVchCurr"
    };
    /*
    float psChannelParametersLimits[][] = 
    { 
	{(float)0, (float)1},        //"LVchCLKS"
	{(float)3.45, (float)3.55},  //"LVch_Vcc"
	{(float)35, (float)105},     //"LVch_Icc"
	{(float)3.95, (float)4.05},  //"LVch_Vdd"
	{(float)175, (float)245},    //"LVch_Idd"
	{(float)3.90, (float)4.20},  //"LVchVCSV"
	{(float)1.80,(float)2.40 },  //"LVchVCSI"
	{(float)5.95, (float)6.05},  //"VchPINV"
	{(float)0.1, (float)0.3},    //"VchPINI"
	{(float)24, (float)26},      //"MOch_Tm0"
	{(float)7, (float)9},        //"MOch_Tm1"
	{(float)3.5, (float)3.6},    //"LVps_Vcc"
	{(float)4.1, (float)4.3},    //"LVps_Vdd"
	{(float)0.02, (float)0.1},   //"LVretVcc"
	{(float)0.10, (float)0.18},  //"LVretVdd"
	{(float)19, (float)21},      //"HVchVolt"
	{(float)19, (float)21},      //"HVchCurr"
    };
    */
    //DCS Parameters:
    org.omg.CORBA.IntHolder ps_partition;
    org.omg.CORBA.IntHolder ps_crate;
    org.omg.CORBA.IntHolder [] [] ps_channel;

    public HarnessTestView(Sct_SctApi.SctApi a) 
    {
        api = a;
	
	murID = new org.omg.CORBA.IntHolder();
	ps_partition = new org.omg.CORBA.IntHolder();
	ps_crate = new org.omg.CORBA.IntHolder();
	ps_channel = new org.omg.CORBA.IntHolder[8][maxDoglegNumberInHarness];
	for(int i=0; i<8; i++){
           for(int j=0;j<maxDoglegNumberInHarness;j++){
              ps_channel[i][j]= new org.omg.CORBA.IntHolder();
           }
        }

        m_daq_scanResults = new short[0][0]; 
	m_daq_scanResultsTable = new String[25][12];

      	m_dcs_scanResults = new float[psChannelParametersList.length][maxDoglegNumberInHarness];
	//.length+1, below, because of the last table column "P/F" giving the test results
        m_dcs_scanResultsTable =  new String[psChannelParametersList.length+1][maxDoglegNumberInHarness];

	for(int row=0; row<25; row++)
	    for(int column=0; column<12; column++)
	         m_daq_scanResultsTable[row][column] = "?";
	
	sys = SystemInterface.getInstance();
	conf = sys.getConfigurationService();
       
        // How many harnesses are in the configuration?
        // For each that exists, obtain DCS map information

        m_harnessMax=0;
	m_harnessList = new int[8];

        if(conf!=null){
           for(int harness=0; harness<maxHarnessOnROD; harness++){
               try{
	           System.out.println("part " + m_partition + " crate " + m_crate + " rod " + m_rod + " harness " + harness);
                   conf.getMapRODMUR(m_partition, m_crate, m_rod, harness, murID);
	           System.out.println(" harness " + harness + " MUR " + murID.value);

                   m_harnessList[m_harnessMax] = harness;
                   m_harnessMax++;

                   for(int module=1; module<=6; module++){ //different numbering convention: module 1-6
                      conf.translateToPowerSupply(murID.value, module, ps_partition, ps_crate, ps_channel[m_harnessMax-1][module-1]);
	              System.out.println("Map for harness "+harness +" chan " + module + "ps chan " + ps_channel[m_harnessMax-1][module-1].value);
                   }
                }
                catch(sctConf.ConfigurationException e) {
	           System.out.println("No MUR at harness " + harness);
                }
            } 
        }else{
            javax.swing.JOptionPane.showMessageDialog(null, "Unable to connect to the configuration service");
        }
 
	passedFailed = "?";
        initComponents();

	//this is just to create an empty file!!
	dataFile = fileNameValue.getText();
	try{BufferedWriter out = new BufferedWriter(new FileWriter(dataFile, false));	out.close();}
	catch(IOException e) {javax.swing.JOptionPane.showMessageDialog(null, "Failed to Open File");}



       modifyComponents();
    }//end of constructor HarnessTestView

    // For beanability
    public HarnessTestView() 
    {
        initComponents();
        modifyComponents();
    }

    public void modifyComponents() {
        //updateResultsPanel();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() 
{
   topPanel = new javax.swing.JPanel();
   panelForLabels = new javax.swing.JPanel();
   partitionLabel = new javax.swing.JLabel();
   crateLabel = new javax.swing.JLabel();
   rodLabel = new javax.swing.JLabel();
   harnessMaxLabel = new javax.swing.JLabel();
   rxLabel = new javax.swing.JLabel();
   txLabel = new javax.swing.JLabel();
   fileNameLabel = new javax.swing.JLabel();

   partitionValue = new javax.swing.JTextField();
   crateValue = new javax.swing.JTextField();
   rodValue = new javax.swing.JTextField();
   harnessMaxValue = new javax.swing.JTextField();
   rxThValue = new javax.swing.JTextField();
   txCurrentValue = new javax.swing.JTextField();
   fileNameValue = new javax.swing.JTextField();
   panelForClose = new javax.swing.JPanel();
   closeButton = new javax.swing.JButton();
   //the tab panels: we have three main tabs: "Test", "DAQ Data" and "DCS Data"
   jTabbedPaneTest = new javax.swing.JTabbedPane();
   jTabbedPaneDAQData = new javax.swing.JTabbedPane();
   jTabbedPaneDCSData = new javax.swing.JTabbedPane();

   setLayout(new java.awt.BorderLayout());
   
   add(panelForClose, java.awt.BorderLayout.SOUTH);
      panelForClose.setOpaque(false);
      panelForClose.add(closeButton);
	 closeButton.setText("Close");
	 closeButton.addActionListener(
              new java.awt.event.ActionListener() 
		  {
		      public void actionPerformed(java.awt.event.ActionEvent evt) 
			 {
			     closeButtonPerformed(evt);
			 }
		 });

   add(topPanel, java.awt.BorderLayout.NORTH);
      topPanel.setLayout(new javax.swing.BoxLayout(topPanel, javax.swing.BoxLayout.Y_AXIS));
      topPanel.add(panelForLabels);
         panelForLabels.setLayout(new javax.swing.BoxLayout(panelForLabels, javax.swing.BoxLayout.X_AXIS));

         panelForLabels.add(partitionLabel);
            partitionLabel.setText("  Partition ");
         panelForLabels.add(partitionValue);
            partitionValue.setText(Integer.toString(m_partition));
            partitionValue.addActionListener
            (new java.awt.event.ActionListener(){
              public void actionPerformed(java.awt.event.ActionEvent evt) {
                m_partition = Integer.parseInt(partitionValue.getText());
              }
            });

         panelForLabels.add(crateLabel);
            crateLabel.setText("  Crate ");
         panelForLabels.add(crateValue);
            crateValue.setText(Integer.toString(m_crate));
            crateValue.addActionListener
            (new java.awt.event.ActionListener(){
              public void actionPerformed(java.awt.event.ActionEvent evt) {
                m_crate = Integer.parseInt(crateValue.getText());
              }
            });

         panelForLabels.add(rodLabel);
            rodLabel.setText("  ROD ");
         panelForLabels.add(rodValue);
            rodValue.setText(Integer.toString(m_rod));
            rodValue.addActionListener
            (new java.awt.event.ActionListener(){
              public void actionPerformed(java.awt.event.ActionEvent evt) {
                m_rod = Integer.parseInt(rodValue.getText());
              }
            });

         panelForLabels.add(harnessMaxLabel);
            harnessMaxLabel.setText("  HarnessMax ");
         panelForLabels.add(harnessMaxValue);
            harnessMaxValue.setText(Integer.toString(m_harnessMax));
            harnessMaxValue.addActionListener
            (new java.awt.event.ActionListener(){
              public void actionPerformed(java.awt.event.ActionEvent evt) {
                m_harnessMax = Integer.parseInt(harnessMaxValue.getText());
                createTabs(m_harnessMax);
              }
            });

         panelForLabels.add(rxLabel);
            rxLabel.setText("  Rx Threshold ");
         panelForLabels.add(rxThValue);
            //rxThValue.setText(Integer.toString(m_rxThreshold));
            rxThValue.setText("?");
            rxThValue.addActionListener
            (new java.awt.event.ActionListener(){
              public void actionPerformed(java.awt.event.ActionEvent evt) {
                if(api!=null){
                  m_rxThreshold = Integer.parseInt(rxThValue.getText());
                  for(int harness = 0;  harness < m_harnessMax; harness++){
                    for(int channel = (m_harnessList[harness]*6); channel < ((m_harnessList[harness]+1)*6); channel++){
                      api.modifyBOCParam(m_partition,m_crate,m_rod,channel,50,m_rxThreshold); // ST_RX_THRESHOLD
                    }
                  }
                  //api.saveBOCSetup(m_partition,m_crate,m_rod);
                }
              }
            });

         panelForLabels.add(txLabel);
            txLabel.setText("  Tx Current ");
         panelForLabels.add(txCurrentValue);
            //txCurrentValue.setText(Integer.toString(m_txCurrent));
            txCurrentValue.setText("?");
            txCurrentValue.addActionListener
            (new java.awt.event.ActionListener(){
              public void actionPerformed(java.awt.event.ActionEvent evt) {
                m_txCurrent = Integer.parseInt(txCurrentValue.getText());
                if(api!=null){
                  for(int harness = 0;  harness < m_harnessMax; harness++){
                    for(int channel = (m_harnessList[harness]*6); channel < ((m_harnessList[harness]+1)*6); channel++){
                      api.modifyBOCParam(m_partition,m_crate,m_rod,channel,53,m_txCurrent); // ST_TX_CURRENT 
                    }
                  }
                }
              }
            });

         panelForLabels.add(fileNameLabel);
            fileNameLabel.setText("  FileName ");
         panelForLabels.add(fileNameValue);
            fileNameValue.setText("harnessData.txt");

   //create the Tabs
   createTabs(m_harnessMax);
}//end of void initComponents() 

private void createTabs(int harnessMax)
{ 
    //some initialisation
    m_summary_scanResults = new String[m_harnessMax][6][6];
    for(int harness=0; harness<m_harnessMax; harness++){
        for(int test=0; test<6; test++){
            for(int module=0; module<6; module++){
                m_summary_scanResults[harness][test][module] = "?";
            }
        }
    }
    //this is the main tab (here one puts the main tabs: Test, DAQ Data,...etc.)
    add(jTabbedPaneTest, java.awt.BorderLayout.CENTER);
    //remove all the tabs (to put others)
    jTabbedPaneTest.removeAll();

    //=============== this is the "Test" tab ============================================================

    summaryScrollPanelForTable = new javax.swing.JScrollPane[m_harnessMax];
    summaryHarnessTable = new javax.swing.JTable[m_harnessMax];
    summaryHarnessTableModels = new HarnessTestsSummaryTableModel[m_harnessMax];

    summaryHarnessPanel = new javax.swing.JPanel();
    jTabbedPaneTest.addTab("Test", summaryHarnessPanel);
        summaryHarnessPanel.setLayout(new javax.swing.BoxLayout(summaryHarnessPanel, javax.swing.BoxLayout.Y_AXIS));
        summaryHarnessPanel.setPreferredSize(new Dimension(150,180));
        performHarnessTestButton = new javax.swing.JButton();
        summaryHarnessPanel.add(performHarnessTestButton, java.awt.BorderLayout.CENTER);
	      performHarnessTestButton.setText("Perform Harness Test");
              performHarnessTestButton.addActionListener(
              new java.awt.event.ActionListener() {
                  public void actionPerformed(java.awt.event.ActionEvent evt) {
                      doTestsForAllHarnesses();
                  }
              });

        for(int index=0; index<m_harnessMax; index++){
            summaryScrollPanelForTable[index] = new javax.swing.JScrollPane();
            summaryHarnessPanel.add(summaryScrollPanelForTable[index], java.awt.BorderLayout.CENTER);
            summaryHarnessTable[index] = new javax.swing.JTable();
            summaryScrollPanelForTable[index].setViewportView(summaryHarnessTable[index]);

            summaryHarnessTable[index].setFont(new java.awt.Font("Monospaced", 0, 12));
            String[] columnsNames = {"Harness ","DAQ Select 0","DAQ Select 1","DCS Select 0","DCS Select 1",
				     "DCS S0vsS1", "RESULTS"};
            columnsNames[0] =  columnsNames[0]+m_harnessList[index];
            summaryHarnessTableModels[index] =  new HarnessTestsSummaryTableModel(m_harnessList[index],columnsNames);
            summaryHarnessTableModels[index].newData(m_summary_scanResults[index]);
            summaryHarnessTable[index].setModel(summaryHarnessTableModels[index]);
            //for cell color
            changeSummaryTableCellsColor(summaryHarnessTable[index]);
        }

    //============== this is the "DAQ Data" tab =========================================================

    jTabbedPaneTest.addTab("DAQ Data",jTabbedPaneDAQData);
    //remove all the tabs (to put others)
    jTabbedPaneDAQData.removeAll();

    daqHaernessPanels = new javax.swing.JPanel[m_harnessMax];
    daqPanelForLabels = new javax.swing.JPanel[m_harnessMax];
    daqSelectLineLabel = new javax.swing.JLabel[m_harnessMax];
    daqSelectLineChoices = new javax.swing.JComboBox[m_harnessMax];
    performDAQScanButton = new javax.swing.JButton[m_harnessMax];
    daqScrollPanelForTable_Select0 = new javax.swing.JScrollPane[m_harnessMax];
    daqHarnessTable_Select0 = new javax.swing.JTable[m_harnessMax];
    daqHarnessTableModels_Select0 =  new SamplingDataTableModel[m_harnessMax];
    daqPanelForSecondTable = new javax.swing.JPanel[m_harnessMax];
    daqScrollPanelForTable_Select1 = new javax.swing.JScrollPane[m_harnessMax];
    daqHarnessTable_Select1 = new javax.swing.JTable[m_harnessMax];
    daqHarnessTableModels_Select1 =  new SamplingDataTableModel[m_harnessMax];
   
    for(int index=0; index<m_harnessMax; index++) {
        daqHaernessPanels[index] = new javax.swing.JPanel();
        jTabbedPaneDAQData.addTab("Harness "+ m_harnessList[index], daqHaernessPanels[index]);
        daqPanelForLabels[index] = new javax.swing.JPanel();
	daqHaernessPanels[index].setLayout(new java.awt.BorderLayout());
	daqHaernessPanels[index].add(daqPanelForLabels[index], java.awt.BorderLayout.NORTH);
	daqPanelForLabels[index].setLayout(new javax.swing.BoxLayout(daqPanelForLabels[index], 
									 javax.swing.BoxLayout.X_AXIS));
	daqSelectLineLabel[index] = new javax.swing.JLabel();
        daqPanelForLabels[index].add(daqSelectLineLabel[index]);
	    daqSelectLineLabel[index].setText("  Select Line  ");
	    daqSelectLineChoices[index] = new javax.swing.JComboBox();
        daqPanelForLabels[index].add(daqSelectLineChoices[index]);
	    daqSelectLineChoices[index].setModel(
                new javax.swing.DefaultComboBoxModel(new String[] 
                { "Normal + Redundant", "Normal", "Redundant" }));

        performDAQScanButton[index] = new javax.swing.JButton();
        daqPanelForLabels[index].add(performDAQScanButton[index]);
            performDAQScanButton[index].setText("Perform DAQ scan");
            performDAQScanButton[index].addActionListener(new java.awt.event.ActionListener() {
                public void actionPerformed(java.awt.event.ActionEvent evt) {
                    //get the selected tab (ie selected harness number)
                    int selectedHarness = jTabbedPaneDAQData.getSelectedIndex();
                    //get the selected select line
                    String selectLine = 
			     (String)daqSelectLineChoices[selectedHarness].getSelectedItem();
			 //do the daq scan and fill the corresponding graphic table(s)
			 if(selectLine.equals("Normal"))
			     {
                                 changeSelect(0);
				 daqHarnessTableModels_Select0[selectedHarness].
				     newData(probeScanHarnessWithTrigger(selectedHarness, (short)0), 
					     dataFile, getTimeStamp());//select line 0
			     }
			 else if(selectLine.equals("Redundant"))
			     {
                                 changeSelect(1);
				 daqHarnessTableModels_Select1[selectedHarness].
				     newData(probeScanHarnessWithTrigger(selectedHarness, (short)1), 
					     dataFile, getTimeStamp());//select line 1
			     }
			 else if(selectLine.equals("Normal + Redundant"))
			     {
                                 changeSelect(0);
				 daqHarnessTableModels_Select0[selectedHarness].
				     newData(probeScanHarnessWithTrigger(selectedHarness, (short)0), 
					     dataFile, getTimeStamp());//select line 0

                                 changeSelect(1);
				 daqHarnessTableModels_Select1[selectedHarness].
				     newData(probeScanHarnessWithTrigger(selectedHarness, (short)1), 
					     dataFile, getTimeStamp());//select line 1
			     }
		     }
		 });

	daqHaernessPanels[index].setPreferredSize(new Dimension(850,550));
	//table1: for selectLine 0 (in a given harness)
	daqScrollPanelForTable_Select0[index] = new javax.swing.JScrollPane();
	daqHaernessPanels[index].add(daqScrollPanelForTable_Select0[index], java.awt.BorderLayout.CENTER);
	  daqHarnessTable_Select0[index] = new javax.swing.JTable();
	  daqScrollPanelForTable_Select0[index].setViewportView(daqHarnessTable_Select0[index]);
            daqHarnessTable_Select0[index].setFont(new java.awt.Font("Monospaced", 0, 12));
	    //create the harness0 tables: they are  tow, one for select line 0 and for line 1
	    daqHarnessTableModels_Select0[index] =  new SamplingDataTableModel(m_harnessList[index], 0);//selectLine=0
            daqHarnessTable_Select0[index].setModel(daqHarnessTableModels_Select0[index]);
	    changeDAQTableCellsColor(daqHarnessTable_Select0[index]);
	//table2: for selectLine 1 (in a given harness)
	daqPanelForSecondTable[index] = new javax.swing.JPanel();
        daqHaernessPanels[index].add(daqPanelForSecondTable[index], java.awt.BorderLayout.SOUTH);
	daqPanelForSecondTable[index].setLayout(new java.awt.BorderLayout());
	daqPanelForSecondTable[index].setPreferredSize(new Dimension(550,250));
	     daqScrollPanelForTable_Select1[index] = new javax.swing.JScrollPane();
	     daqPanelForSecondTable[index].add(daqScrollPanelForTable_Select1[index], java.awt.BorderLayout.CENTER);
	      daqHarnessTable_Select1[index] = new javax.swing.JTable();
	      daqScrollPanelForTable_Select1[index].setViewportView(daqHarnessTable_Select1[index]);
                  daqHarnessTable_Select1[index].setFont(new java.awt.Font("Monospaced", 0, 12));
		  //TODO: Implement Select Line
		  daqHarnessTableModels_Select1[index] =  new SamplingDataTableModel(m_harnessList[index], 1);//selectLine=1
		  daqHarnessTable_Select1[index].setModel(daqHarnessTableModels_Select1[index]);
		  changeDAQTableCellsColor(daqHarnessTable_Select1[index]);
    }//end of for(int index=0....)
//==================================== DCS Data tab ========================================
 jTabbedPaneTest.addTab("DCS Data", jTabbedPaneDCSData);
 //remove all the tabs (to put others)
 jTabbedPaneDCSData.removeAll();

 dcsHarnessPanels = new javax.swing.JPanel[harnessMax];
 dscScrollPanelForTable_Select0 = new javax.swing.JScrollPane[harnessMax];
 dcsHarnessTable_Select0 = new javax.swing.JTable[harnessMax];
 dcsHarnessTableModels_Select0 =  new DCSDataTableModel[harnessMax];
 dcsPanelForSecondTable = new javax.swing.JPanel[harnessMax];
 dscScrollPanelForTable_Select1 = new javax.swing.JScrollPane[harnessMax];
 dcsHarnessTable_Select1 = new javax.swing.JTable[harnessMax];
 dcsHarnessTableModels_Select1 =  new DCSDataTableModel[harnessMax];
 dcsPanelForLabels = new javax.swing.JPanel[harnessMax];
 stateTransitionLabel = new javax.swing.JLabel[harnessMax];
 transitionStateChoices = new javax.swing.JComboBox[harnessMax];
 changePSStateButton = new javax.swing.JButton[harnessMax];
 dcsSelectLineLabel = new javax.swing.JLabel[harnessMax];
 dcsSelectLineChoices = new javax.swing.JComboBox[harnessMax];
 performDCSScanButton = new javax.swing.JButton[harnessMax];

for(int index=0; index<harnessMax; index++)
    {
      dcsHarnessPanels[index] = new javax.swing.JPanel();
      jTabbedPaneDCSData.addTab("Harness "+ m_harnessList[index], dcsHarnessPanels[index] );
         dcsHarnessPanels[index].setLayout(new java.awt.BorderLayout());
	 dcsHarnessPanels[index].setPreferredSize(new Dimension(350,550));
	 dcsHarnessPanels[index].setPreferredSize(new Dimension(250,350));
	 //Select Line 0
         dscScrollPanelForTable_Select0[index] = new javax.swing.JScrollPane();
	 dcsHarnessPanels[index].add(dscScrollPanelForTable_Select0[index], java.awt.BorderLayout.CENTER);
         dcsHarnessTable_Select0[index] = new javax.swing.JTable();
            dscScrollPanelForTable_Select0[index].setViewportView(dcsHarnessTable_Select0[index]);
	       dcsHarnessTable_Select0[index].setFont(new java.awt.Font("Monospaced", 0, 12));
	       dcsHarnessTableModels_Select0[index] =  new DCSDataTableModel(m_harnessList[index], 0);//selectLine=0
	       dcsHarnessTable_Select0[index].setModel(dcsHarnessTableModels_Select0[index]);
	       changeDCSTableCellsColor(dcsHarnessTable_Select0[index]);
	 //Select Line 1
	 dcsPanelForSecondTable[index] = new javax.swing.JPanel();
	 dcsHarnessPanels[index].add(dcsPanelForSecondTable[index], java.awt.BorderLayout.SOUTH);
	    dcsPanelForSecondTable[index].setLayout(new java.awt.BorderLayout());
	    dcsPanelForSecondTable[index].setPreferredSize(new Dimension(350,250));
	    dscScrollPanelForTable_Select1[index] = new javax.swing.JScrollPane();
	    dcsPanelForSecondTable[index].add(dscScrollPanelForTable_Select1[index], 
					      java.awt.BorderLayout.CENTER);
	    dcsHarnessTable_Select1[index] = new javax.swing.JTable();
	       dscScrollPanelForTable_Select1[index].setViewportView(dcsHarnessTable_Select1[index]);
	          dcsHarnessTable_Select1[index].setFont(new java.awt.Font("Monospaced", 0, 12));
		  dcsHarnessTableModels_Select1[index] =  new DCSDataTableModel(m_harnessList[index], 1);//selectLine=0
                  dcsHarnessTable_Select1[index].setModel(dcsHarnessTableModels_Select1[index]);
		  changeDCSTableCellsColor(dcsHarnessTable_Select1[index]);
	 dcsPanelForLabels[index] = new javax.swing.JPanel();
	 dcsHarnessPanels[index].add(dcsPanelForLabels[index], java.awt.BorderLayout.NORTH);
	    dcsPanelForLabels[index].setLayout(new javax.swing.BoxLayout(dcsPanelForLabels[index], 
									 javax.swing.BoxLayout.X_AXIS));
	    stateTransitionLabel[index] = new javax.swing.JLabel();
	    dcsPanelForLabels[index].add(stateTransitionLabel[index]);
	       stateTransitionLabel[index].setText("  Select PS State  ");
	       transitionStateChoices[index] = new javax.swing.JComboBox();
	    dcsPanelForLabels[index].add(transitionStateChoices[index]);
               transitionStateChoices[index].setModel(
                   new javax.swing.DefaultComboBoxModel(new String[] { "STANDBY", "ON", "OFF" }));
	    changePSStateButton[index] = new javax.swing.JButton();
	    dcsPanelForLabels[index].add(changePSStateButton[index]);
 	       changePSStateButton[index].setText("Change STATE");
	       changePSStateButton[index].addActionListener(
                   new java.awt.event.ActionListener() 
                       {
			   public void actionPerformed(java.awt.event.ActionEvent evt) 
			      {
				  //get the selected tab (ie selected harness number)
				  int selectedHarness = jTabbedPaneDCSData.getSelectedIndex();
				  //get the selected select line
				  String state = 
				      (String)transitionStateChoices[selectedHarness].getSelectedItem();
				  short stateNumber = 0;
				  if(state.equals("ON")) {
				      stateNumber = 1;
				  } else if(state.equals("OFF")) {
				      stateNumber = 0;
				  } else if(state.equals("STANDBY")) {
				      stateNumber = 2;
				  }
				  //set the PS to the required state
				  changePSState(selectedHarness, stateNumber);
			      }
		       });
	    dcsSelectLineLabel[index] = new javax.swing.JLabel();
	    dcsPanelForLabels[index].add(dcsSelectLineLabel[index]);
 	       dcsSelectLineLabel[index].setText("  Select Line  ");
	       dcsSelectLineChoices[index] = new javax.swing.JComboBox();
	    dcsPanelForLabels[index].add(dcsSelectLineChoices[index]);
	       dcsSelectLineChoices[index].setModel(new javax.swing.DefaultComboBoxModel(
                             new String[] { "Normal + Redundant",  "Normal", "Redundant" }));

	    performDCSScanButton[index] = new javax.swing.JButton();
	    dcsPanelForLabels[index].add(performDCSScanButton[index]);
	       performDCSScanButton[index].setText("Perform DCS scan");
               performDCSScanButton[index].addActionListener(
                   new java.awt.event.ActionListener() 
		       {
			   public void actionPerformed(java.awt.event.ActionEvent evt) 
			      {
				  //get the selected tab (ie selected harness number)
				  int selectedHarness = jTabbedPaneDCSData.getSelectedIndex();
				  //get the selected select line
				  String selectLine = 
				      (String)dcsSelectLineChoices[selectedHarness].getSelectedItem();
				  //read DCS data and fill the corresponding graphic table(s)
				  if(selectLine.equals("Normal"))
				      {
                                          changeSelect(0);
					  dcsHarnessTableModels_Select0[selectedHarness].
					      newData(readDCSData(selectedHarness, (short)0), 
						      dataFile, getTimeStamp());//select line 0
				      }
				  else if(selectLine.equals("Redundant"))
				      {
                                          changeSelect(1);
					  dcsHarnessTableModels_Select1[selectedHarness].
					      newData(readDCSData(selectedHarness, (short)1), 
						      dataFile, getTimeStamp());//select line 1
				      }
				  else if(selectLine.equals("Normal + Redundant"))
				      {
                                          changeSelect(0);
					  dcsHarnessTableModels_Select0[selectedHarness].
					      newData(readDCSData(selectedHarness, (short)0), 
						      dataFile, getTimeStamp());//select line 0

                                          changeSelect(1);
					  dcsHarnessTableModels_Select1[selectedHarness].
					      newData(readDCSData(selectedHarness, (short)1), 
						      dataFile, getTimeStamp());//select line 1
					  //must be called after the two table has been filled 
					  daqDcsAnalyse(selectedHarness);
				      }
			      }
		       });
    }//end of for(int index=0....)
}//end of  createTabs()

//
// Here are the methods that perform and analyse the tests
//

private String[][] probeScanHarnessWithTrigger(int selectedHarness, short selectLine) 
{
    if(api == null){ // protection against case where DAQ not running
        System.out.println("Error: api pointer is NULL");
        return m_daq_scanResultsTable;
    }

    Sct_SctApi.Scan probeScan = api.createScan();
    probeScan.getTrigger1().doubleL1A((short)10);
    probeScan.configure((short)20, 0.0, 24.0, 1.0);

    try {
        m_daq_scanResults = api.probeScanHarnessWithTrigger(m_partition, m_crate, m_rod,
                                                        probeScan, m_harnessList[selectedHarness]);
    } 
    catch(NumberFormatException e) {
        javax.swing.JOptionPane.showMessageDialog(null, "Failed to interpet harness value");
    }

    // Analyse the results
    harnessDAQTestAnalyse(selectedHarness, selectLine);

    // Return the result table
    return m_daq_scanResultsTable;

}//end of String[][] probeScanHarnessWithTrigger

private void changePSState(int selectedHarness, short stateNumber) {

    // Set PS to the required state:
    //  0 = "OFF"
    //  1 - "ON"
    //  2 = "STANDBY"

    if(api == null){ // protection against case where DAQ not running
        System.out.println("Error: api pointer is NULL");
        return;
    }

    for(int dogleg=0; dogleg<=5; dogleg++) {
       System.out.println("Requesting PS state change: " + getPSCrate().value + " " + 
           getPSChannel(selectedHarness, dogleg).value + " " + stateNumber);    
       api.ddcChangeState(getPSCrate().value, getPSChannel(selectedHarness, dogleg).value, stateNumber);
    }
}//end of void changePSState

private void changeSelect(int selection) {

    //change select line in DCS
    //convert int to boolean

    boolean select;
    if(selection == 1) select = true;
    else select = false;

    if(api == null){ // protection against case where DAQ not running
        System.out.println("Error: api pointer is NULL");
        return;
    }

    if(selection == m_select){
      System.out.println("changeSelect: select already set to " + selection + ". No action taken.");
      return;
    }

    short oldTimeout = api.ddcGetMultipleTimeout();
    short newTimeout = 60;
    api.ddcSetMultipleTimeout(newTimeout);

    System.out.println("changeSelect: Requesting Select " + selection + " Timeout " + newTimeout);
    api.setSelectAllInCrate(getPSCrate().value, select);

    api.ddcSetMultipleTimeout(oldTimeout);

    m_select = selection;

}//end of void changeSelect

private String[][] readDCSData(int selectedHarness, short selectLine) {  

    // Read DCS values for the selected harness
    // Values are stored in the table selected by selectLine.
    // The select line must have been set externally.
 
    if(api == null){ // protection against case where DAQ not running
        System.out.println("Error: api pointer is NULL");
        return m_dcs_scanResultsTable;
    }

    for(int dogleg=0; dogleg<=5; dogleg++){
        System.out.println("DOGLEG N = " + dogleg);

        for( int parameter=0; parameter<psChannelParametersList.length; parameter++){

            System.out.println("  Parameter: " + psChannelParametersList[parameter] + " channel " + 
                              getPSChannel(selectedHarness,dogleg).value);
            m_dcs_scanResults[parameter][dogleg] =
                 api.ddcGetChannelParameterFloat(getPSCrate().value, getPSChannel(selectedHarness, dogleg).value, 
                              psChannelParametersList[parameter]);
            System.out.println("  ParameterValue = " + m_dcs_scanResults[parameter][dogleg]);
        }
    }
    // Analyse the results
    harnessDCSTestAnalyse(selectedHarness, selectLine);

    // Return the result table
    return m_dcs_scanResultsTable;
}//end of readDCSData

private void doTestsForAllHarnesses() {

    // Changing SELECT is slow so we do it outside the harness loop

    changeSelect(0);
	
    for(int harness=0; harness<m_harnessMax; harness++) {

	daqHarnessTableModels_Select0[harness].newData(probeScanHarnessWithTrigger(harness, (short)0), 
			   dataFile, getTimeStamp());
	dcsHarnessTableModels_Select0[harness].newData(readDCSData(harness, (short)0), 
			   dataFile, getTimeStamp());
	//update the summary tables
	summaryHarnessTableModels[harness].newData(m_summary_scanResults[harness], 
                           dataFile, getTimeStamp());
    }

    changeSelect(1);
	
    for(int harness=0; harness<m_harnessMax; harness++) {

	daqHarnessTableModels_Select1[harness].newData(probeScanHarnessWithTrigger(harness, (short)1), 
			   dataFile, getTimeStamp());

 	dcsHarnessTableModels_Select1[harness].newData(readDCSData(harness, (short)1), 
			   dataFile, getTimeStamp());

        //update the summary tables
	summaryHarnessTableModels[harness].newData(m_summary_scanResults[harness], 
                           dataFile, getTimeStamp());
	//should be called after the two table has been filled 
	daqDcsAnalyse(harness);
    }

    //Save summary data to File
    // saveHarnessDataToFile();

}// end of doTestsForAllHarnesses

public void harnessDAQTestAnalyse(int selectedHarness, short selectLine)
{
    //get the summary table (to be updated)
    m_summary_scanResults[selectedHarness] = summaryHarnessTableModels[selectedHarness].getData();

    int clk;

    for(int link=0; link<12; link++) {
        int numberL=0;
        int number1=0;
        int number2=0;
        int numberE=0;
        int numberJunk=0;
        int number0=0;
        int numberUnidentified=0;

        for(clk=0; clk<24; clk++) {
		    
            char linkResult = (char)m_daq_scanResults[clk][link];

            if((linkResult == 'L') || (linkResult == 'l')) numberL++;
            else if(linkResult == '1') number1++;
            else if(linkResult == '2') number2++;
            else if(linkResult == 'E') numberE++;
            else if(linkResult == 'J') numberJunk++;
            else if(linkResult == '0') number0++;
            else numberUnidentified++;

            // Fill the result table
            m_daq_scanResultsTable[clk][link]  = "" + linkResult;
        }

        // Generate a summary comment for the last column
        if(number0 >= 22) m_daq_scanResultsTable[clk][link] = "Dead";
        else if(number1 >= 22) m_daq_scanResultsTable[clk][link] = "Stuck";
        else if(number1+number0>=20 && number0<=15) m_daq_scanResultsTable[clk][link] = "CLK"; 
        else if(number2 >= 20) m_daq_scanResultsTable[clk][link] = "Clock by 2";
        else if(numberE >= 20) m_daq_scanResultsTable[clk][link] = "Event";
        else if(numberL >= 20) m_daq_scanResultsTable[clk][link] = "L1A";		    
        else m_daq_scanResultsTable[clk][link] = "Junk";	  
    }

    // Analyse the state of the two links of each dogleg
    //  - set PASS only if both links returned the correct data

    for(int dogleg=0; dogleg<6; dogleg++) {
        String link0Result = m_daq_scanResultsTable[24][(dogleg*2)];
        String link1Result = m_daq_scanResultsTable[24][(dogleg*2)+1];

        String linksState = "FAIL";
        if(selectLine == 1){
          // correct state has CLK on link0 and L1A on link1
          if     (link0Result == "CLK"  &&  link1Result == "L1A") linksState = "PASS";
          else if(link0Result == "L1A"  &&  link1Result == "CLK") linksState = "SWAP";
        }else{
          // correct state has L1A on link0 and CLK on link1
          if     (link0Result == "L1A"  &&  link1Result == "CLK") linksState = "PASS";
          else if(link0Result == "CLK"  &&  link1Result == "L1A") linksState = "SWAP";
        }

        if( link0Result == "Dead" &&  link1Result == "Dead") linksState = "Both Dead";
        else if( link0Result == "Dead") linksState = "Link0 Dead";
        else if( link1Result == "Dead") linksState = "Link1 Dead";

        if( link0Result == "Stuck" &&  link1Result == "Stuck") linksState = "Both Stuck";
        else if( link0Result == "Stuck") linksState = "Link0 Stuck";
        else if( link1Result == "Stuck") linksState = "Link1 Stuck";

        m_summary_scanResults[selectedHarness][selectLine][dogleg] = linksState;
    }

    //update the summary table
    summaryHarnessTableModels[selectedHarness].newData(m_summary_scanResults[selectedHarness], 
						       dataFile, getTimeStamp());
}//end harnessDAQTestAnalyse

public void harnessDCSTestAnalyse(int selectedHarness, short selectLine)
{
    //get the summary table (to be upadated)
    m_summary_scanResults[selectedHarness] = summaryHarnessTableModels[selectedHarness].getData();

    for(int dogleg=0; dogleg<6; dogleg++) {
        // If any parameter is outside tolerance, report FAIL
        // If LV has tripped, report TRIP
        // - otherwise report PASS
        String  parametersState = "PASS";

        for(int parameter=0; parameter<psChannelParametersList.length; parameter++) {
	    float thisParameterLowerLimit = psChannelParametersLimits[parameter][0];
	    float thisParameterUpperLimit = psChannelParametersLimits[parameter][1];
		   
            if(m_dcs_scanResults[parameter][dogleg]<thisParameterLowerLimit ||
               m_dcs_scanResults[parameter][dogleg]>thisParameterUpperLimit) {
                parametersState="FAIL";
            }

            // fill the (selectecHarness, selectLine) table
            if(parameter==0){
                m_dcs_scanResultsTable[parameter][dogleg] = "0x" + Integer.toHexString((int)m_dcs_scanResults[parameter][dogleg]);
            }else{
                m_dcs_scanResultsTable[parameter][dogleg] = "" + m_dcs_scanResults[parameter][dogleg];
            }
        }

        int status = (int) m_dcs_scanResults[0][dogleg];
        if((status&0x20)==0x20){
            parametersState="TRIP";
        }

        // Fill the overall PASS/FAIL status
	m_dcs_scanResultsTable[psChannelParametersList.length][dogleg] = parametersState;

        //update the corresponding column in the harness summary table in the "Test" panel
        //we add 2 below, because we want to fill the third and fourth columns
        m_summary_scanResults[selectedHarness][selectLine+2][dogleg] = parametersState;
    }

    //update the summary table
    summaryHarnessTableModels[selectedHarness].newData(m_summary_scanResults[selectedHarness], 
						       dataFile, getTimeStamp());
}//end of harnessDCSTestAnalyse

public void daqDcsAnalyse(int selectedHarness) {
    //get the summary table (to be updated)
    m_summary_scanResults[selectedHarness] = summaryHarnessTableModels[selectedHarness].getData();

    //compare the DCS scan results for the two select lines for the actual harness
    String[][] select0_table = dcsHarnessTableModels_Select0[selectedHarness].getData();
    String[][] select1_table = dcsHarnessTableModels_Select1[selectedHarness].getData();

    if(select0_table==null ||  select0_table==null) {
        System.out.println("pointer select0_table or select1_table is null. this means one select line table is empty");
        return;
    }
 
    //compare the DCS data for the two selects line (in a harness). both select lines should have the 
    //same data.
    //remember that row column table are not as [row][column] but the way round [column][row]!!!
    for(int row=0; row<select0_table[0].length; row++) {
        String compareParameterValue =  "";
        for(int column=1; column<select0_table.length-1; column++){ // temporary fix for LvchStat
            float value1= Float.parseFloat(select0_table[column][row]);
            float value2= Float.parseFloat(select1_table[column][row]);
            float valuesComparison = 0;

            if(value2 != 0) 
                valuesComparison = value1/value2;
            else if(value1<-0.05 || value1>0.05)// value2 is 0, then value1 should be also 0 (to 5%)
                valuesComparison = 0; //this means, of course, "FAIL";
            else 
                valuesComparison = 1; //this means "PASS";
	    
            if(valuesComparison>1.05 || valuesComparison<0.95)
                compareParameterValue = "FAIL";
            else
                compareParameterValue = "PASS";
        }

        //fill the "DCS S0vsS1" column (this is the fifth column)
        //if(compareParameterValue != "PASS" || select0_table[column][row] != "PASS") //enough to test one slect table
        if(compareParameterValue != "PASS" ) //enough to test one slect table
            m_summary_scanResults[selectedHarness][4][row] = "FAIL";
        else 
            m_summary_scanResults[selectedHarness][4][row] = "PASS"; 
    }

    //Overall PASS/FAIL status (last column of the summary table) 
    String daq_dcs_result = "PASS";

    for(int row=0; row<6; row++) {
        for(int column=0; column<6; column++) {
	    if(m_summary_scanResults[selectedHarness][column][row] != "PASS"){
                daq_dcs_result = "FAIL";
            }
	}
	m_summary_scanResults[selectedHarness][5][row] = daq_dcs_result; 
    }

    //update the summary table
    summaryHarnessTableModels[selectedHarness].newData(m_summary_scanResults[selectedHarness], 
						       dataFile, getTimeStamp());
}//end of daqDcsAnalyse

private void closeButtonPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_closeButtonPerformed
    ((Window)getTopLevelAncestor()).dispose();
}//GEN-LAST:event_closeButtonPerformed

public org.omg.CORBA.IntHolder  getPSPartition() {return ps_partition;}

public org.omg.CORBA.IntHolder getPSCrate() {return ps_crate;}

public org.omg.CORBA.IntHolder getPSChannel(int selectedHarness, int dogleg) {return ps_channel[selectedHarness][dogleg];}

//here are the tables models: we need, at most, three models. one for sampling test (DAQ Data tab), one for DCS test
//(DCS Data tab) and one as a summary tet (Test tab)
//1) this is the sampling model it's a 12X24 table

//
// Table model for DAQ data table
//

class SamplingDataTableModel extends javax.swing.table.AbstractTableModel 
{
    //private variables
    int m_harness;
    int m_selectLine;
    String[][] m_harnessSamplingData;
    
    // default constructor
    public SamplingDataTableModel(int harness, int selectLine) {
        m_harness = m_harness;
        m_selectLine = selectLine;
	m_harnessSamplingData = new String[25][12];
	for(int column=0; column< (getColumnCount()-1); column++){
	    for(int row=0; row< getRowCount(); row++){
	        m_harnessSamplingData[column][row] = "?";
            }
        }
    }

    public Class getColumnClass(int column) {
        return getValueAt(0, column).getClass();
    }

    public void newData(String[][] harnessSamplingData, String dataFile, String timeStamp) {
	for(int column=0; column< (getColumnCount()-1); column++){
	    for(int row=0; row< getRowCount(); row++){
	        m_harnessSamplingData[column][row] = harnessSamplingData[column][row];
            }
        }
	fireTableStructureChanged();
	saveDataToFile(dataFile, timeStamp);
    }

    public String[][] getData() {
	return m_harnessSamplingData;
    }

    public int getColumnCount() {
	return (1+m_harnessSamplingData.length);
    }
    
    public int getRowCount() {
	return m_harnessSamplingData[0].length; 
    }
    
    public Object getValueAt(int rowIndex, int columnIndex) {                
	if(columnIndex == 0) 
	    return "Ln" + rowIndex;
	else 
	    return "" + m_harnessSamplingData[columnIndex-1][rowIndex];
    }
        
    public String getColumnName(int columnIndex) {
	String retValue;
	
	if(columnIndex == 0) {
	    retValue = "Select"+m_selectLine;
	} else if(columnIndex == 25) {
	    retValue ="P/F";
	} else {
	    columnIndex--;
	    retValue = "" + columnIndex;
	}

	return retValue;
    }

    public void saveDataToFile(String dataFile, String timeStamp) {
	try
	    {
		BufferedWriter out = new BufferedWriter(new FileWriter(dataFile, true));
		
		out.write("---- DAQ Data for harness "+m_harness+ " Select Line "+m_selectLine);
		out.newLine();
		out.write(timeStamp);
		out.newLine();
		out.newLine();
		//print column titles
		out.write(getColumnName(0) + " ");//only one space here
		for (int column =1; column<m_harnessSamplingData.length; column++)
		    if(column<10) out.write(getColumnName(column) + "  ");//two space here (for allignement!)
		    else  out.write(getColumnName(column) + " ");//one space here 
		out.newLine();
		out.newLine();
		//print the tables entries
		for (int row =0; row<m_harnessSamplingData[0].length; row++) 
		    {		
			if(row<10) out.write("Link" + row+"   ");
			else out.write("Link" + row+"  ");//remove one blanc for allignement
			for(int column=0; column<m_harnessSamplingData.length; column++)
			    out.write(m_harnessSamplingData[column][row]+"  ");
			out.newLine();
		    }
		//space before the next writing in this file
		out.newLine();
		out.newLine();
		out.close();  
	    }
	catch(IOException e) 
	    {
		javax.swing.JOptionPane.showMessageDialog(null, "Failed to Open File");
	    }
    }
}//end of  class SamplingDataTableModel extends javax.swing.table.AbstractTableModel 

//
// Table model for DCS data table
//

class DCSDataTableModel extends javax.swing.table.AbstractTableModel 
{
    //private variables
    int m_harness;
    int m_selectLine;
    String[][] m_harnessDCSData;

    // default constructor
    public DCSDataTableModel(int harness, int selectLine) {
        m_harness = harness;
        m_selectLine = selectLine;
        m_harnessDCSData = new String[psChannelParametersList.length+1][maxDoglegNumberInHarness];
	for(int column=0; column< (getColumnCount()-1); column++){
	    for(int row=0; row< getRowCount(); row++){
	        m_harnessDCSData[column][row] = "?";
            }
        }
    }
    
    public void newData(String[][] harnessDCSData, String dataFile, String timeStamp) {
	for(int column=0; column< (getColumnCount()-1); column++){
	    for(int row=0; row< getRowCount(); row++){
	        m_harnessDCSData[column][row] = harnessDCSData[column][row];
            }
        }
	fireTableStructureChanged();
	saveDataToFile(dataFile, timeStamp);
    } 

    public Class getColumnClass(int column) {
        return getValueAt(0, column).getClass();
    }

    public String[][] getData() {
	return m_harnessDCSData;
    }
    
    public int getColumnCount() {
	return (1+m_harnessDCSData.length);
    }
    
    public int getRowCount() {
	return m_harnessDCSData[0].length;
    }
    
    public Object getValueAt(int rowIndex, int columnIndex) {
	if(columnIndex == 0) 
	    return "Dogleg " + rowIndex;
	else 
	    return "" + m_harnessDCSData[columnIndex-1][rowIndex];
    }
    
    public String getColumnName(int columnIndex) {
	String retValue;

	if(columnIndex == 0) 
	    retValue = "Select"+m_selectLine;
	else if(columnIndex == psChannelParametersList_short.length+1) 
	    retValue = "P/F";
	else 
	    retValue = "" + psChannelParametersList_short[columnIndex-1];
	
	return retValue;
    }

    public void saveDataToFile(String dataFile, String timeStamp) {
	try
	    {
		BufferedWriter out = new BufferedWriter(new FileWriter(dataFile, true));
		
		out.write("---- DCS Data for harness "+m_harness+ " Select Line "+m_selectLine);
		out.newLine();
		out.write(timeStamp);
		out.newLine();
		out.newLine();
		//print column titles
		out.write(getColumnName(0)+" ");//don't the first name (Select..)
		for (int column =1; column<m_harnessDCSData.length; column++) 
		    out.write(getColumnName(column) + " ");//one space here 
		out.newLine();
		out.newLine();
		//print the tables entries
		for (int row =0; row<m_harnessDCSData[0].length; row++) 
		    {		
			out.write("Module" + row+"   ");
			for(int column=0; column<m_harnessDCSData.length; column++)
			    out.write(m_harnessDCSData[column][row]+"  ");
			out.newLine();
		    }
		//space before the next writing in this file
		out.newLine();
		out.newLine();
		out.close();  
	    }
	catch(IOException e) 
	    {
		javax.swing.JOptionPane.showMessageDialog(null, "Failed to Open File");
	    }
    }
}
   
//
// Table model for Summary data table
//

class HarnessTestsSummaryTableModel extends javax.swing.table.AbstractTableModel 
{
    String[][] m_HarnessTestsSummaryData;
    String[] m_columnsNames;

    int m_harness;

    public HarnessTestsSummaryTableModel(int harness, String[] columsNames) {
        m_harness = harness;
        m_columnsNames = columsNames;
    }

    public void newData(String[][] harnessTestsSummaryData) {
	m_HarnessTestsSummaryData = harnessTestsSummaryData;
	fireTableStructureChanged();
    }

    public void newData(String[][] harnessTestsSummaryData, String dataFile, String timeStamp) {
	m_HarnessTestsSummaryData = harnessTestsSummaryData;
	fireTableStructureChanged();
	saveDataToFile(dataFile, timeStamp);
    }

    public Class getColumnClass(int column) {
        return getValueAt(0, column).getClass();
    }

    public String[][] getData() {
	return m_HarnessTestsSummaryData ;
    }
    
    public int getColumnCount() { return 7; }
    
    public int getRowCount() { return 6; }
    
    public Object getValueAt(int rowIndex, int columnIndex) 
    {
	String retValue = "UNKNOWN";
	if(m_HarnessTestsSummaryData == null) return "Ptr Null";
	else
	    {
		if(columnIndex == 0) 
		    retValue = "Module " + rowIndex;
		else 
		    retValue = ""+ m_HarnessTestsSummaryData[columnIndex-1][rowIndex];
	    }
	return retValue;  
    }
    
    public String getColumnName(int columnIndex) 
    {
	return m_columnsNames[columnIndex];
    }
    public void saveDataToFile(String dataFile, String timeStamp) 
    {
	try
	    {
		BufferedWriter out = new BufferedWriter(new FileWriter(dataFile, true));
		
		out.write("---- DAQ-DCS Data Summary for harness "+m_harness);
		out.newLine();
		out.write(timeStamp);
		out.newLine();
		out.newLine();

		//print column titles
		for (int column =0; column<m_HarnessTestsSummaryData.length; column++) 
		    out.write(getColumnName(column) + " ");//one space here 
		out.newLine();
		out.newLine();
		//print the tables entries
		for (int row =0; row<m_HarnessTestsSummaryData[0].length; row++) 
		    {		
			out.write("Module" + row+"   ");
			for(int column=0; column<m_HarnessTestsSummaryData.length; column++)
			    out.write(m_HarnessTestsSummaryData[column][row]+"  ");
			out.newLine();
		    }
		//space before the next writing in this file
		out.newLine();
		out.newLine();
		out.close();  
	    }
	catch(IOException e) 
	    {
		javax.swing.JOptionPane.showMessageDialog(null, "Failed to Open File");
	    }
    }
}

public String getTimeStamp() 
{
    // Apparently java.util.Date is deprecated so we should use the Calendar methods instead
    //   but why produce day like 8/7/104 instead of 8/7/2004?
//     java.util.Calendar now = java.util.Calendar.getInstance();
//     String timestamp =  Integer.toString(now.get(java.util.Calendar.DAY_OF_MONTH)) +
//         "/" + Integer.toString(now.get(java.util.Calendar.MONTH)) +
//         "/" + Integer.toString(now.get(java.util.Calendar.YEAR) - 1900) +
//         "   " + Integer.toString(now.get(java.util.Calendar.HOUR)) +
//         ":" + Integer.toString(now.get(java.util.Calendar.MINUTE)) +
//         ":" + Integer.toString(now.get(java.util.Calendar.SECOND));

//     return timestamp;

    java.util.Date date = new java.util.Date();
    
    String timestamp = date.getDate()+"/"+ date.getMonth()+"/"+date.getYear()+ "   "+
	date.getHours()+":"+ date.getMinutes()+":"+date.getSeconds();
    return timestamp;
}

//
// Methods to set the colour of cells in the DCS table
//

public void changeDCSTableCellsColor(JTable table)
{
    TableCellRenderer	cellRenderer = new DCSTableCellRenderer();
    try {
        table.setDefaultRenderer(Class.forName("java.lang.String"), cellRenderer);
    }
    catch( ClassNotFoundException ex ) {	
        System.exit( 0 );
    }
}

class DCSTableCellRenderer  extends DefaultTableCellRenderer 
{
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, 
						   int row, int column) 
    {
	Component cell = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);

        String cellValue = (String)value;
        String stripped;

        if(cellValue.equals("?")){
            return cell;
        }

        switch(column){
            case 0:  // row name
		cell.setForeground(Color.black);
                break;

            case 1:  // LV status
        	stripped = cellValue.substring(2, cellValue.length());
                int status = Integer.parseInt(stripped,16);  // base 16 - hex

                if((status & 0x20)==0){ // OK
		    cell.setForeground(Color.black);
                }else{                  // FAIL
		    cell.setForeground(Color.red);
                }
                break;

            case 9:  // PASS/FAIL/TRIP
	
        	if(cellValue.equals("PASS")){
        	    cell.setForeground(Color.green);
        	}else{
        	    cell.setForeground(Color.red);
                }
                break;

            default:
                float valueFloat = Float.parseFloat(cellValue);
        	float thisParameterLowerLimit = psChannelParametersLimits[column-1][0];
        	float thisParameterUpperLimit = psChannelParametersLimits[column-1][1];
       
        	if(valueFloat<thisParameterLowerLimit || valueFloat>thisParameterUpperLimit) {
                    cell.setForeground(Color.red);
                }else{
                    cell.setForeground(Color.black);
                }
                break;
        }
	return cell;	
    }
}

//
// Methods to set the colour of cells in the DAQ table
//

public void changeDAQTableCellsColor(JTable table)
{
    TableCellRenderer	cellRenderer = new DAQTableCellRenderer();
    try {
        table.setDefaultRenderer(Class.forName("java.lang.String"), cellRenderer);
    }
    catch( ClassNotFoundException ex ) {	
        System.exit( 0 );
    }
}

class DAQTableCellRenderer  extends DefaultTableCellRenderer 
{
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, 
						   int row, int column) 
    {
        Component cell = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);

        String cellValue = (String)value;

        if(cellValue.equals("PASS")) {
            cell.setForeground(Color.green);
        }else if(cellValue.equals("FAIL")) {
            cell.setForeground(Color.red);
        }else if(cellValue.equals("Dead")) {
            cell.setForeground(Color.blue);
        }else{
            cell.setForeground(Color.black);
        }

        return cell;	
    }
}

//
// Methods to set the colour of cells in the Summary table
//

public void changeSummaryTableCellsColor(JTable table)
{
    TableCellRenderer	cellRenderer = new SummaryTableCellRenderer();
    try {
        table.setDefaultRenderer(Class.forName("java.lang.String"), cellRenderer);
    }
    catch( ClassNotFoundException ex ) {	
        System.exit( 0 );
    }
}

class SummaryTableCellRenderer  extends DefaultTableCellRenderer 
{
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, 
						   int row, int column) 
    {
	Component cell = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);

	String cellValue = (String)value;

        if(cellValue.equals("PASS")) {
            cell.setForeground(Color.green);
        }else if(cellValue.equals("FAIL")){
            cell.setForeground(Color.red);
        }else{
            cell.setForeground(Color.black);
        }

        return cell;	
    }
}
//the Graphis items definition
private javax.swing.JPanel topPanel;
private javax.swing.JPanel panelForLabels;
private javax.swing.JLabel partitionLabel;
private javax.swing.JLabel crateLabel;
private javax.swing.JLabel rodLabel;
private javax.swing.JLabel harnessMaxLabel;
private javax.swing.JLabel rxLabel;
private javax.swing.JLabel txLabel;
private javax.swing.JLabel fileNameLabel;
private javax.swing.JTextField partitionValue;
private javax.swing.JTextField crateValue;
private javax.swing.JTextField rodValue;
private javax.swing.JTextField harnessMaxValue;
private javax.swing.JTextField rxThValue;
private javax.swing.JTextField txCurrentValue;
private javax.swing.JTextField fileNameValue;
private javax.swing.JTabbedPane jTabbedPaneTest;
private javax.swing.JPanel panelForClose;
private javax.swing.JButton closeButton;
//summary Stuff
private javax.swing.JPanel summaryHarnessPanel;
private javax.swing.JButton performHarnessTestButton;
private javax.swing.JScrollPane[] summaryScrollPanelForTable;
private javax.swing.JTable[] summaryHarnessTable;
private HarnessTestsSummaryTableModel[] summaryHarnessTableModels;

//daq stuff
private javax.swing.JTabbedPane jTabbedPaneDAQData;
private javax.swing.JPanel[] daqHaernessPanels;
private javax.swing.JPanel[] daqPanelForLabels;
private javax.swing.JLabel[] daqSelectLineLabel;
private javax.swing.JComboBox[] daqSelectLineChoices;
private javax.swing.JButton[] performDAQScanButton;
private javax.swing.JScrollPane[] daqScrollPanelForTable_Select0;
private javax.swing.JTable[] daqHarnessTable_Select0;
private SamplingDataTableModel[] daqHarnessTableModels_Select0;
private javax.swing.JPanel[] daqPanelForSecondTable;
private javax.swing.JScrollPane[] daqScrollPanelForTable_Select1;
private javax.swing.JTable[] daqHarnessTable_Select1;
private SamplingDataTableModel[] daqHarnessTableModels_Select1;

//dcs stuff
private javax.swing.JTabbedPane jTabbedPaneDCSData;
private javax.swing.JPanel[]  dcsHarnessPanels;
private javax.swing.JScrollPane[] dscScrollPanelForTable_Select0;
private javax.swing.JTable[] dcsHarnessTable_Select0;
private DCSDataTableModel[] dcsHarnessTableModels_Select0;
private javax.swing.JPanel[] dcsPanelForSecondTable;
private javax.swing.JScrollPane[] dscScrollPanelForTable_Select1;
private javax.swing.JTable[] dcsHarnessTable_Select1;
private DCSDataTableModel[] dcsHarnessTableModels_Select1;
private javax.swing.JPanel[] dcsPanelForLabels;
private javax.swing.JLabel[] stateTransitionLabel;
private javax.swing.JComboBox[] transitionStateChoices;
private javax.swing.JButton[] changePSStateButton;
private javax.swing.JLabel[] dcsSelectLineLabel;
private javax.swing.JComboBox[] dcsSelectLineChoices;
private javax.swing.JButton[] performDCSScanButton;
}

