/*
 * BocDiagnostics.java
 *
 * Created on 07 January 2004, 14:12
 */

package GuiComponents.SctApi;

import java.awt.Window;

import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.table.TableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.JTableHeader;

import Sct_SctApi.SctApi;

/**
 * Panel for low level BOC diagnostics
 *
 * @author  gallop
 */
public class BocDiagnostics extends JPanel implements java.io.Serializable {
    BocSetupTableModel bocTableModel;

    int partition;
    int crate;
    int rod;
    Sct_SctApi.SctApi api;
    
    /** Make it beanable... */
    public BocDiagnostics() {
        initComponents();
        modifyComponents();
    }

    /** Creates new form BocDiagnostics */
    public BocDiagnostics(int p, int c, int r, Sct_SctApi.SctApi a) {
        partition = p;
        crate = c;
        rod = r;
        api = a;

        initComponents();
        modifyComponents();
    }

    public static void main(String [] args) {
        javax.swing.JFrame f = new javax.swing.JFrame("BOC Diag test");
        
        f.getContentPane().add(new BocDiagnostics());
        f.pack();
        f.setVisible(true);
    }

    void modifyComponents() {
        JTableHeader tableHeader = bocSetupTable.getTableHeader();
        tableHeader.setReorderingAllowed(false);
        tableHeader.setResizingAllowed(false);

        int columnWidth = bocSetupTable.getFontMetrics(bocSetupTable.getFont()).stringWidth("mmmmmm");

        bocTableModel.newData(api.currentBOCSetup(partition, crate, rod));
        refreshRegisterFields();
/*        TableColumn column = null;
        for (int i = 0; i < 9; i++) {
            column = bocSetupTable.getColumnModel().getColumn(i);
            if (i == 17) {
                // The ASCII column at the end
                column.setPreferredWidth(columnWidth * 8);
            } else {
                column.setPreferredWidth(columnWidth);
                column.setMaxWidth(columnWidth);
                column.setMinWidth(columnWidth);
            }
        } */
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        jPanel2 = new javax.swing.JPanel();
        jLabel3 = new javax.swing.JLabel();
        jTextField2 = new javax.swing.JTextField();
        jLabel4 = new javax.swing.JLabel();
        jTextField3 = new javax.swing.JTextField();
        jLabel5 = new javax.swing.JLabel();
        jTextField4 = new javax.swing.JTextField();
        jLabel7 = new javax.swing.JLabel();
        jTextField6 = new javax.swing.JTextField();
        jTabbedPane1 = new javax.swing.JTabbedPane();
        jPanel3 = new javax.swing.JPanel();
        jScrollPane1 = new javax.swing.JScrollPane();
        bocSetupTable = new javax.swing.JTable();
        jButton1 = new javax.swing.JButton();
        jButton2 = new javax.swing.JButton();
        jPanel5 = new javax.swing.JPanel();
        jPanel6 = new javax.swing.JPanel();
        refreshButton = new javax.swing.JButton();
        jPanel1 = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        clkCText = new javax.swing.JTextField();
        jLabel2 = new javax.swing.JLabel();
        rxDataText = new javax.swing.JTextField();
        jLabel6 = new javax.swing.JLabel();
        rxDacText = new javax.swing.JTextField();
        jLabel8 = new javax.swing.JLabel();
        txDacText = new javax.swing.JTextField();
        jLabel9 = new javax.swing.JLabel();
        vFineText = new javax.swing.JTextField();
        jLabel10 = new javax.swing.JLabel();
        vClock0Text = new javax.swing.JTextField();
        jLabel11 = new javax.swing.JLabel();
        vClock1Text = new javax.swing.JTextField();
        jLabel12 = new javax.swing.JLabel();
        bpmPhaseText = new javax.swing.JTextField();
        jLabel13 = new javax.swing.JLabel();
        bregPhaseText = new javax.swing.JTextField();

        setLayout(new java.awt.BorderLayout());

        jPanel2.setLayout(new javax.swing.BoxLayout(jPanel2, javax.swing.BoxLayout.X_AXIS));

        jLabel3.setText("Partition");
        jPanel2.add(jLabel3);

        jTextField2.setEditable(false);
        jTextField2.setText(new Integer(getPartition()).toString());
        jPanel2.add(jTextField2);

        jLabel4.setText("Crate");
        jPanel2.add(jLabel4);

        jTextField3.setEditable(false);
        jTextField3.setText(new Integer(getCrate()).toString());
        jPanel2.add(jTextField3);

        jLabel5.setText("BOC");
        jPanel2.add(jLabel5);

        jTextField4.setEditable(false);
        jTextField4.setText(new Integer(getROD()).toString());
        jPanel2.add(jTextField4);

        jLabel7.setText("Slot");
        jPanel2.add(jLabel7);

        jTextField6.setEditable(false);
        jTextField6.setText(getRODSlot());
        jPanel2.add(jTextField6);

        add(jPanel2, java.awt.BorderLayout.NORTH);

        jPanel3.setLayout(new java.awt.GridBagLayout());

        bocSetupTable.setFont(new java.awt.Font("Monospaced", 0, 10));
        bocSetupTable.setModel(getBocSetupTableModel());
        bocSetupTable.setShowHorizontalLines(false);
        bocSetupTable.setShowVerticalLines(false);
        jScrollPane1.setViewportView(bocSetupTable);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel3.add(jScrollPane1, gridBagConstraints);

        jButton1.setText("Refresh");
        jButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                refreshBocSetupPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.1;
        jPanel3.add(jButton1, gridBagConstraints);

        jButton2.setText("Re-configure");
        jButton2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                reconfigureBOCSetupPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.1;
        jPanel3.add(jButton2, gridBagConstraints);

        jTabbedPane1.addTab("Setup", jPanel3);

        jPanel5.setLayout(new java.awt.GridBagLayout());

        jPanel6.setLayout(new java.awt.GridBagLayout());

        refreshButton.setText("Refresh");
        refreshButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                refreshButtonActionPerformed(evt);
            }
        });

        jPanel6.add(refreshButton, new java.awt.GridBagConstraints());

        jPanel1.setLayout(new java.awt.GridBagLayout());

        jLabel1.setText("Clock control");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 0;
        jPanel1.add(jLabel1, gridBagConstraints);

        clkCText.setEditable(false);
        clkCText.setText("jTextField1");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 0;
        jPanel1.add(clkCText, gridBagConstraints);

        jLabel2.setText("RX data mode");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 1;
        jPanel1.add(jLabel2, gridBagConstraints);

        rxDataText.setEditable(false);
        rxDataText.setText("jTextField1");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 1;
        jPanel1.add(rxDataText, gridBagConstraints);

        jLabel6.setText("RX DAC clear");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 2;
        jPanel1.add(jLabel6, gridBagConstraints);

        rxDacText.setEditable(false);
        rxDacText.setText("jTextField1");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 2;
        jPanel1.add(rxDacText, gridBagConstraints);

        jLabel8.setText("TX DAC clear");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 3;
        jPanel1.add(jLabel8, gridBagConstraints);

        txDacText.setEditable(false);
        txDacText.setText("jTextField1");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 3;
        jPanel1.add(txDacText, gridBagConstraints);

        jLabel9.setText("Vernier fine phase");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 4;
        jPanel1.add(jLabel9, gridBagConstraints);

        vFineText.setEditable(false);
        vFineText.setText("jTextField1");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 4;
        jPanel1.add(vFineText, gridBagConstraints);

        jLabel10.setText("Vernier clock phase 0");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 5;
        jPanel1.add(jLabel10, gridBagConstraints);

        vClock0Text.setEditable(false);
        vClock0Text.setText("jTextField1");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 5;
        jPanel1.add(vClock0Text, gridBagConstraints);

        jLabel11.setText("Vernier clock phase 1");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 6;
        jPanel1.add(jLabel11, gridBagConstraints);

        vClock1Text.setEditable(false);
        vClock1Text.setText("jTextField1");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 6;
        jPanel1.add(vClock1Text, gridBagConstraints);

        jLabel12.setText("BPM clock phase");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 7;
        jPanel1.add(jLabel12, gridBagConstraints);

        bpmPhaseText.setEditable(false);
        bpmPhaseText.setText("jTextField1");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 7;
        jPanel1.add(bpmPhaseText, gridBagConstraints);

        jLabel13.setText("bReg clock phase");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 8;
        jPanel1.add(jLabel13, gridBagConstraints);

        bregPhaseText.setEditable(false);
        bregPhaseText.setText("jTextField1");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 8;
        jPanel1.add(bregPhaseText, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 1;
        jPanel6.add(jPanel1, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        jPanel5.add(jPanel6, gridBagConstraints);

        jTabbedPane1.addTab("Global Registers", jPanel5);

        add(jTabbedPane1, java.awt.BorderLayout.CENTER);

    }//GEN-END:initComponents

    private void reconfigureBOCSetupPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_reconfigureBOCSetupPerformed
        api.configureBOC(partition, crate, rod);
        refreshRegisterFields();
    }//GEN-LAST:event_reconfigureBOCSetupPerformed

    private void refreshButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_refreshButtonActionPerformed
        refreshRegisterFields();
    }//GEN-LAST:event_refreshButtonActionPerformed

    private void refreshBocSetupPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_refreshBocSetupPerformed
        bocTableModel.newData(api.currentBOCSetup(partition, crate, rod));
    }//GEN-LAST:event_refreshBocSetupPerformed

    public TableModel getBocSetupTableModel() {
        if(bocTableModel == null) {
            sctConf.BOCChannelConfig [] nullBlock = new sctConf.BOCChannelConfig[0];

            bocTableModel = new BocDiagnostics.BocSetupTableModel(nullBlock);
        }

        return bocTableModel;
    }    
    
    public void refreshRegisterFields() {
        sctConf.BOCGlobalConfig regs = api.currentBOCRegisters(partition, crate, rod);

        clkCText.setText("" + regs.clockControl);
        rxDataText.setText("" + regs.rxDataMode);
        rxDacText.setText("" + regs.rxDacClear);
        txDacText.setText("" + regs.txDacClear);
        vFineText.setText("" + regs.vernierFinePhase);
        vClock0Text.setText("" + regs.vernierClockPhase0);
        vClock1Text.setText("" + regs.vernierClockPhase1);
        bpmPhaseText.setText("" + regs.bpmClockPhase);
        bregPhaseText.setText("" + regs.bregClockPhase);
    }
    
    public int getPartition() {
        return partition;
    }

    public int getCrate() {
        return crate;
    }

    public int getROD() {
        return rod;
    }

    public String getRODSlot() {
        try {
            long rodSlot = api.getRodSlot(partition, crate, rod);
            return "" + rodSlot;
        } catch(NullPointerException n) {
            return "No API";
        }
    }

    public boolean isRODValid() {
        if(api == null) {
            if(getTopLevelAncestor() == null) {
                // Doesn't have an ancestor when its being constructed...
                return false;
            } else {
                ((Window)getTopLevelAncestor()).dispose();
                return false;
            }
        } else {
            return api.isRODPresent(partition, crate, rod);
        }
    }

    /** Setter for property partition.
     * @param partition New value of property partition.
     *
     */
    public void setPartition(int partition) { this.partition = partition; }
    
    public class BocSetupTableModel extends javax.swing.table.AbstractTableModel {
        sctConf.BOCChannelConfig [] blockArray;

        public BocSetupTableModel(sctConf.BOCChannelConfig [] block) {
            blockArray = block;
        }

        public void newData(sctConf.BOCChannelConfig [] block) {
            blockArray = block;
            fireTableDataChanged();
        }
        
        public int getColumnCount() {
            return 9;
        }

        public int getRowCount() {
            return 48;
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            sctConf.BOCChannelConfig ch = blockArray[rowIndex];
            
            switch(columnIndex) {
                case 0: return "" + rowIndex;
                case 1: return "0x" + Integer.toHexString(ch.current);
                case 2: return "0x" + Integer.toHexString((ch.delay & 0xff00) >> 8);
                case 3: return "0x" + Integer.toHexString(ch.delay & 0xff);
                case 4: return "0x" + Integer.toHexString(ch.markSpace);
                case 5: return "0x" + Integer.toHexString(ch.threshold0);
                case 6: return "0x" + Integer.toHexString(ch.delay0);
                case 7: return "0x" + Integer.toHexString(ch.threshold1);
                case 8: return "0x" + Integer.toHexString(ch.delay1);
                default: return "---";
            }
        }
        
        public String getColumnName(int columnIndex) {
            String retValue;

            switch(columnIndex) {
            case 0: retValue = "Channel"; break;
            case 1: retValue = "Current"; break;
            case 2: retValue = "Coarse Delay"; break;
            case 3: retValue = "Fine Delay"; break;
            case 4: retValue = "Mark/space"; break;
            case 5: retValue = "Threshold 0"; break;
            case 6: retValue = "RX Delay 0"; break;
            case 7: retValue = "Threshold 1"; break;
            case 8: retValue = "RX Delay 1"; break;
            default: retValue = "Unkown"; break;
            }

            return retValue;
        }
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JTable bocSetupTable;
    private javax.swing.JTextField bpmPhaseText;
    private javax.swing.JTextField bregPhaseText;
    private javax.swing.JTextField clkCText;
    private javax.swing.JButton jButton1;
    private javax.swing.JButton jButton2;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel10;
    private javax.swing.JLabel jLabel11;
    private javax.swing.JLabel jLabel12;
    private javax.swing.JLabel jLabel13;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JLabel jLabel7;
    private javax.swing.JLabel jLabel8;
    private javax.swing.JLabel jLabel9;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JPanel jPanel5;
    private javax.swing.JPanel jPanel6;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JTabbedPane jTabbedPane1;
    private javax.swing.JTextField jTextField2;
    private javax.swing.JTextField jTextField3;
    private javax.swing.JTextField jTextField4;
    private javax.swing.JTextField jTextField6;
    private javax.swing.JButton refreshButton;
    private javax.swing.JTextField rxDacText;
    private javax.swing.JTextField rxDataText;
    private javax.swing.JTextField txDacText;
    private javax.swing.JTextField vClock0Text;
    private javax.swing.JTextField vClock1Text;
    private javax.swing.JTextField vFineText;
    // End of variables declaration//GEN-END:variables
    
}
