package GuiComponents.Panels;

import Sct_SctApi.*;
import ipc.*;

import Sct.gui.SelectionDialog;

import GuiComponents.SctApi.*;
import GuiComponents.System.*;

import java.util.Arrays;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JButton;
import javax.swing.JOptionPane;

import org.omg.CORBA.IntHolder;

public class SctApiGui extends JPanel {
    private Sct_SctApi.SctApi api;

    public static void main(String args[]) {
        System.out.println("Hello world");

        JFrame frame = new JFrame("SctApi GUI");
        frame.getContentPane().add(new SctApiGui());

        frame.pack();
        frame.setVisible(true);
    }

    public SctApiGui() {
        connectServer();

        JPanel topButtons = new JPanel();
        JPanel middleButtons = new JPanel();
        JPanel bottomButtons = new JPanel();

        setLayout(new BoxLayout(this, BoxLayout.Y_AXIS));

        topButtons.setLayout(new BoxLayout(topButtons, BoxLayout.X_AXIS));
        middleButtons.setLayout(new BoxLayout(middleButtons, BoxLayout.X_AXIS));
        bottomButtons.setLayout(new BoxLayout(bottomButtons, BoxLayout.X_AXIS));

        JButton close = new JButton("Close");
        close.addActionListener(new ActionListener() {
                public void actionPerformed(ActionEvent e) {
                    ((Window)getTopLevelAncestor()).dispose();
                }
            });

        JButton shutdown = new JButton("Shutdown server");
        shutdown.addActionListener(new ActionListener() {
                public void actionPerformed(ActionEvent e) {
                    shutDownAction();
                }
            });

        JButton probeButton = new JButton("Probe Modules");
        probeButton.addActionListener(new ActionListener() {
                public void actionPerformed(ActionEvent e) {
                    probeAction();
                }
            });

	/*AT 19042004 implementation: harness tests */
	JButton harnessTestButton = new JButton("Harness Test");
        harnessTestButton.addActionListener(new ActionListener() {
                public void actionPerformed(ActionEvent e) {
                    harnessTestAction();
                }
            });
	
        JButton listScan = new JButton("List scans");
        listScan.addActionListener(new ActionListener() {
                public void actionPerformed(ActionEvent e) {
                    Sct_SctApi.Scan[] scans = api.knownScans();

                    JFrame scanListFrame = new JFrame("List of known scans");
                    scanListFrame.getContentPane().add((Component)(new ScanList(api, scans)));

                    scanListFrame.pack();
                    scanListFrame.setVisible(true);
                }
            });

        JButton rodDiag = new JButton("ROD diagnostics");
        rodDiag.addActionListener(new ActionListener() {
                public void actionPerformed(ActionEvent e) {
                    rodDiagAction();
                }
            });

        JButton bocDiag = new JButton("BOC diagnostics");
        bocDiag.addActionListener(new ActionListener() {
                public void actionPerformed(ActionEvent e) {
                    bocDiagAction();
                }
            });

        JButton timDiag = new JButton("TIM diagnostics");
        timDiag.addActionListener(new ActionListener() {
                public void actionPerformed(ActionEvent e) {
                    timDiagAction();
                }
            });

        JButton confDiag = new JButton("Module Configuration diagnostics");
        confDiag.addActionListener(new ActionListener() {
                public void actionPerformed(ActionEvent e) {
                    moduleConfAction();
                }
            });

        JButton ddcDiag = new JButton("DDC diagnostics");
        ddcDiag.addActionListener(new ActionListener() {
                public void actionPerformed(ActionEvent e) {
                    JFrame ddcFrame = new JFrame("DDC diagnostics");
                    Component c = (Component)new DdcDiagnostics(api);
                    ddcFrame.getContentPane().add(c);
                    ddcFrame.pack();
                    ddcFrame.setVisible(true);
                }
            });

        JButton debugButton = new JButton("Set debug options");
        debugButton.addActionListener(new ActionListener() {
                public void actionPerformed(ActionEvent e) {
                    debugLevelAction();
                }
            });

        JButton statusButton = new JButton("Show status");
        statusButton.addActionListener(new ActionListener() {
                public void actionPerformed(ActionEvent e) {
                    api.status();
                }
            });

        JButton standardDump = new JButton("Do standard dump");
        standardDump.addActionListener(new ActionListener() {
                public void actionPerformed(ActionEvent e) {
                    api.standardRegisterDumpAll();
                }
            });

        JButton reconnect = new JButton("Reconnect");
        reconnect.addActionListener(new ActionListener() {
                public void actionPerformed(ActionEvent e) {
                    connectServer();
                }
            });

        JButton reloadConfig = new JButton("Reload module configuration");
        reloadConfig.addActionListener(new ActionListener() {
                public void actionPerformed(ActionEvent e) {
                    try {
                        api.loadConfiguration("");
                    } catch(Sct_SctApi.SctApiException s) {
                        javax.swing.JOptionPane.showMessageDialog(null, "Failed to reload module configuration: " + s.detail);
                    }
                }
            });

        JButton configModules = new JButton("Send module configs");
        configModules.addActionListener(new ActionListener() {
                public void actionPerformed(ActionEvent e) {
                    try {
                        api.sendABCDModules(Sct_SctApi.BankType.PHYSICS_CONFIG);
                    } catch(SctApiException s) {
                        javax.swing.JOptionPane.showMessageDialog(null, "Failed to Configure modules: " + s.detail);
                    }
                }
            });

        JButton freeTriggers = new JButton("Send free triggers");
        freeTriggers.addActionListener(new ActionListener() {
                public void actionPerformed(ActionEvent e) {
                    try {
                        TimDoublet td = inputTimDoublet();
                        api.freeTriggers(td.partition, td.crate);
                    } catch(SelectionDialog.InvalidDialogException i) {
                        javax.swing.JOptionPane.showMessageDialog(null, "Failed to interpet TIM entry");
                    } catch(SelectionDialog.CancelledDialogException c) {
                    }
                }
            });

        JButton stopTriggers = new JButton("Stop free triggers");
        stopTriggers.addActionListener(new ActionListener() {
                public void actionPerformed(ActionEvent e) {
                    try {
                        TimDoublet td = inputTimDoublet();
                        api.stopTriggers(td.partition, td.crate);
                    } catch(SelectionDialog.InvalidDialogException i) {
                        javax.swing.JOptionPane.showMessageDialog(null, "Failed to interpet TIM entry");
                    } catch(SelectionDialog.CancelledDialogException c) {
                    }
                }
            });

        JButton autoConfigure = new JButton("Run auto-configurer");
        autoConfigure.addActionListener(new ActionListener() {
                public void actionPerformed(ActionEvent e) {
                    autoConfigAction();
                }
            });

        // Action panels
        topButtons.add(probeButton);
        topButtons.add(harnessTestButton);
        topButtons.add(listScan);
        topButtons.add(autoConfigure);

        topButtons.add(freeTriggers);
        topButtons.add(stopTriggers);

        // Diagnostics
        middleButtons.add(rodDiag);
        middleButtons.add(bocDiag);
        middleButtons.add(timDiag);
        middleButtons.add(confDiag);
        middleButtons.add(ddcDiag);
        middleButtons.add(debugButton);
        middleButtons.add(standardDump);
        middleButtons.add(configModules);

        // Overall 
        bottomButtons.add(statusButton);
        bottomButtons.add(close);
        bottomButtons.add(shutdown);
        bottomButtons.add(reconnect);
        bottomButtons.add(reloadConfig);

        add(topButtons);
        add(middleButtons);
        add(bottomButtons);

        System.out.println("Set up GUI, wait for it to run");
    }


    void connectServer() {
        // Replace with SystemInterface!
        SystemInterface sys = SystemInterface.getInstance();
        // If config server lost then need to reconnect
        sys.refresh();
        api = sys.getSctApi();

	if (api==null) {
	    System.err.println("Error (check SCTAPI running)");
	} else {
            System.out.println("Found SCTAPI");
        }
    }

    void shutDownAction() {
        try {
            System.out.println("Shutdown system");
            api.shutdownAll();
            System.out.println("Done");
            api.destroy();
            ((Window)getTopLevelAncestor()).dispose();
        } catch(Exception ex) {
            // Exit whatever happens
        }
        System.exit(0);
    }

    void probeAction() {
        try {
            RodTriplet rt = inputRodTriplet();
            JFrame probeFrame = new JFrame("Probe modules");

            Component c = (Component)new ProbeView(rt.partition, rt.crate, rt.rod, api);
            probeFrame.getContentPane().add(c);
            probeFrame.pack();
            probeFrame.setVisible(true);
        } catch(SelectionDialog.InvalidDialogException i) {
            javax.swing.JOptionPane.showMessageDialog(null, "Failed to interpet ROD entry");
        } catch(SelectionDialog.CancelledDialogException c) {
        }
    }

    /*AT 042004 harness tests     */
    void harnessTestAction() {
            //try {
            //RodQuadruplet rt = inputRodQuadruplet();
            JFrame harnessTestFrame = new JFrame("Harness Test");

            //Component c = (Component)new HarnessTestView(rt.partition, rt.crate, rt.rod, rt.harness, api);
	    Component c = (Component) new HarnessTestView(api);
            harnessTestFrame.getContentPane().add(c);
            harnessTestFrame.pack();
            harnessTestFrame.setVisible(true);
	    //} catch(SelectionDialog.InvalidDialogException i) {
            //javax.swing.JOptionPane.showMessageDialog(null, "Failed to interpet ROD entry");
	    //} catch(SelectionDialog.CancelledDialogException c) {
	    //}
    }

    void rodDiagAction() {
        try {
            RodTriplet rt = inputRodTriplet();
            JFrame rodFrame = new JFrame("ROD diagnostics");
            Component c = (Component)new RodDiagnostics(rt.partition, rt.crate, rt.rod, api);
            rodFrame.getContentPane().add(c);
            rodFrame.pack();
            rodFrame.setVisible(true);
        } catch(SelectionDialog.InvalidDialogException i) {
            javax.swing.JOptionPane.showMessageDialog(null, "Failed to interpet ROD entry");
        } catch(SelectionDialog.CancelledDialogException c) {
        }
    }

    void bocDiagAction() {
        try {
            RodTriplet rt = inputRodTriplet();
            JFrame bocFrame = new JFrame("BOC diagnostics");
            Component c = (Component)new BocDiagnostics(rt.partition, rt.crate, rt.rod, api);
            bocFrame.getContentPane().add(c);
            bocFrame.pack();
            bocFrame.setVisible(true);
        } catch(SelectionDialog.InvalidDialogException i) {
            javax.swing.JOptionPane.showMessageDialog(null, "Failed to interpet BOC entry");
        } catch(SelectionDialog.CancelledDialogException c) {
        }
    }

    void moduleConfAction() {
        try {
            RodTriplet rt = inputRodTriplet();
            JFrame confFrame = new JFrame("Module configuration diagnostics");
            Component c = (Component)new ModuleConfigurations(rt.partition, rt.crate, rt.rod, api);
            confFrame.getContentPane().add(c);
            confFrame.pack();
            confFrame.setVisible(true);
        } catch(SelectionDialog.InvalidDialogException i) {
            javax.swing.JOptionPane.showMessageDialog(null, "Failed to interpet ROD entry");
        } catch(SelectionDialog.CancelledDialogException c) {
        }
    }

    void timDiagAction() {
        try {
            SctApiGui.TimDoublet td = inputTimDoublet();
            JFrame timFrame = new JFrame("TIM diagnostics");
            Component c = (Component)new TimDiagnostics(td.partition, td.crate, api);
            timFrame.getContentPane().add(c);
            timFrame.pack();
            timFrame.setVisible(true);
        } catch(SelectionDialog.InvalidDialogException i) {
            javax.swing.JOptionPane.showMessageDialog(null, "Failed to interpet TIM entry");
        } catch(SelectionDialog.CancelledDialogException c) {
        }
    }

    void debugLevelAction() {
        String[] possibilities = api.listDebugOptions();

        String[] enabled = api.listEnabledDebugOptions();

        int[] preSelected = new int[enabled.length];

        Arrays.sort(possibilities);

        // Find options that are selected
        for(int i=0; i<enabled.length; i++) {
            int result = Arrays.binarySearch(possibilities, enabled[i]);
            if(result < 0) {
                // Strange! ignore it
                preSelected[i] = -1;
            } else {
                preSelected[i] = result;
            }
        }

        String selected [] = 
            Sct.gui.MultiSelectionDialog.showDialog(null, "Select Debug Options", 
                                                    possibilities, preSelected);

        if (selected != null) {
            Arrays.sort(selected);
            Arrays.sort(enabled);

            // Find options that are selected that shouldn't be
            for(int i=0; i<enabled.length; i++) {
                if(Arrays.binarySearch(selected, enabled[i]) < 0) {
                    api.unsetDebugOption(enabled[i]);
                }
            }

            // Find options that aren't selected that should be
            for(int i=0; i<selected.length; i++) {
                if(Arrays.binarySearch(enabled, selected[i]) < 0) {
                    api.setDebugOption(selected[i]);
                }
            }
        }
    }

    void autoConfigAction() {
        JFrame autoFrame = new JFrame("Auto configure");
        Component c = (Component)new AutoConfigure(api);
        autoFrame.getContentPane().add(c);
        autoFrame.pack();
        autoFrame.setVisible(true);
    }

    RodTriplet inputRodTriplet() throws SelectionDialog.InvalidDialogException, SelectionDialog.CancelledDialogException {
        String [] labels = {"Partition", "Crate", "ROD"};
        String [] defaults = {"0", "0", "0"};

        SelectionDialog dia = new SelectionDialog(null, "Get ROD index", labels, defaults);

        dia.pack();
        dia.setVisible(true);

        return new RodTriplet(dia.getIntFieldValue(0), 
                              dia.getIntFieldValue(1), 
                              dia.getIntFieldValue(2));
    }


    /*AT    */
    RodQuadruplet inputRodQuadruplet() throws SelectionDialog.InvalidDialogException, SelectionDialog.CancelledDialogException {
        String [] labels = {"Partition", "Crate", "ROD", "Harness"};
        String [] defaults = {"0", "0", "0", "0"};

        SelectionDialog dia = new SelectionDialog(null, "Get ROD index", labels, defaults);

        dia.pack();
        dia.setVisible(true);

        return new RodQuadruplet(dia.getIntFieldValue(0), 
				 dia.getIntFieldValue(1), 
				 dia.getIntFieldValue(2),
				 dia.getIntFieldValue(3));
    }

    public class RodTriplet {
        int partition;
        int crate;
        int rod;
        RodTriplet(int p, int c, int r) {
            partition = p;
            crate = c;
            rod = r;
	    
        }
    }


    /*AT   */
    public class RodQuadruplet {
        int partition;
        int crate;
        int rod;
	int harness;
        RodQuadruplet(int p, int c, int r, int h) {
            partition = p;
            crate = c;
            rod = r;
	    harness = h;
        }
    }

    TimDoublet inputTimDoublet() throws SelectionDialog.InvalidDialogException, SelectionDialog.CancelledDialogException {
        String [] labels = {"Partition", "Crate"};
        String [] defaults = {"0", "0"};

        SelectionDialog dia = new SelectionDialog(null, "Get TIM index", labels, defaults);

        dia.pack();
        dia.setVisible(true);

        return new TimDoublet(dia.getIntFieldValue(0), 
                              dia.getIntFieldValue(1));
    }

    public class TimDoublet {
        int partition;
        int crate;
        TimDoublet(int p, int c) {
            partition = p;
            crate = c;
        }
    }
}
