/*
 * ModuleConfigurationPanel.java
 *
 * Created on 07 November 2003, 10:45
 */
package GuiComponents.Panels;

import SctData.*;
import Sct.File.ObjectManagerFile;
import Sct.*;
import GuiComponents.System.SystemInterface;
import GuiComponents.Inspector.*;
import java.util.logging.*;
import javax.swing.*;
import sctConf.*;
import Sct_SctApi.*;

/**
 * Displays a ModuleConfiguration by reading it from the Configuration Service
 * @author  Matthew Palmer
 */
public class ModuleConfigurationPanel extends javax.swing.JPanel {
    
    /** Creates new form ModuleConfigurationPanel 
     * @param serialNo the Serial number of the module whose configuration will be displayed
     */
    public ModuleConfigurationPanel(String serialNo) {
        this.serialNo = serialNo;
        initComponents();
    }
    
    
   
    private void getCurrentModuleConfig() {
        if (currentModuleConfig != null && currentIP != null) return;
        SctApi api = SystemInterface.getInstance().getSctApi();
        if (api == null) {
            Logger.getLogger("TestGUI").info("ModuleConfigurationPanel unable to get SctApi - so no data!");
            return;
        }
        try {
	    int mid = api.findModuleSerial(serialNo);
            ABCDModule data = api.retrieveModule(mid);
            currentModuleConfig = new ModuleConfiguration(data);
	    currentIP = new InspectorPanel("Module Configuration " + serialNo, new SerializableWrapper(currentModuleConfig, serialNo, "ModuleConfiguration"));
        } catch (Exception ce) {
            Logger.getLogger("TestGUI").info("ConfigurationException whilst ModuleConfigurationPanel getting saved Module Configuration: " + ce.getMessage());
	    return;
	}
    }

    private void getSavedModuleConfig() {
        if (savedModuleConfig != null && savedIP != null) return;
        Configuration config = SystemInterface.getInstance().getConfigurationService();
        if (config == null) {
            Logger.getLogger("TestGUI").info("ModuleConfigurationPanel unable to get ConfigurationService - so no data!");
            return;
        }
        try {
            ABCDModule data = config.getModuleConfig(serialNo);
            savedModuleConfig = new ModuleConfiguration(data);
	    savedIP = new InspectorPanel("Module Configuration " + serialNo, new SerializableWrapper(savedModuleConfig, serialNo, "ModuleConfiguration"));	    
        } catch (sctConf.ConfigurationException ce) {
            Logger.getLogger("TestGUI").info("ConfigurationException whilst ModuleConfigurationPanel getting current Module Configuration: " + ce.getMessage());
	    return;
	}
    }
    
    private void updateConfiguration() {
	int ret = JOptionPane.showConfirmDialog(this, "This will update the configuration for all modules but it is NOT persistent.\nAre you sure?", "Configuration Update", JOptionPane.YES_NO_OPTION);
	if (ret != JOptionPane.YES_OPTION) return;
	SctApi api = SystemInterface.getInstance().getSctApi();
        if (api == null) {
            Logger.getLogger("TestGUI").info("ModuleConfigurationPanel unable to get SctApi - so no data!");
            return;
        }
        try {
	    api.storeModuleConfigurations();
	} catch (Exception ce) {
            Logger.getLogger("TestGUI").info("ConfigurationException whilst ModuleConfigurationPanel getting saved Module Configuration: " + ce.getMessage());
	    return;
	}
    }
    
    
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {
        
        setBackground(new java.awt.Color(255, 255, 255));

        java.awt.GridBagConstraints gridBagConstraints;

        defaultText = new JTextArea("Configuration data not available");
        defaultText.setMinimumSize(new java.awt.Dimension(500, 400));
        defaultText.setPreferredSize(new java.awt.Dimension(600, 600));

        scrollPane = new javax.swing.JScrollPane(defaultText);
        saveConfigButton = new javax.swing.JButton();
        storedConfigButton = new javax.swing.JRadioButton();
        storedConfigButton.setBackground(new java.awt.Color(255,255,255));
        currentConfigButton = new javax.swing.JRadioButton();
        currentConfigButton.setBackground(new java.awt.Color(255,255,255));
        title = new javax.swing.JLabel("Configuration data for "+serialNo);
        title.setFont(new java.awt.Font("Arial",java.awt.Font.BOLD,16));
        title.setForeground(new java.awt.Color(51, 0, 153));

        buttonGroup1 = new javax.swing.ButtonGroup();

        setLayout(new java.awt.GridBagLayout());

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new java.awt.Insets(2, 0, 2, 0);
        gridBagConstraints.weighty = 0.1;
        add(title, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new java.awt.Insets(2, 0, 2, 0);
        gridBagConstraints.weighty = 0.7;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        add(scrollPane, gridBagConstraints);

        saveConfigButton.setFont(new java.awt.Font("Arial", 0, 12));
        saveConfigButton.setText("Save this Configuration");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weighty = 0.1;
        add(saveConfigButton, gridBagConstraints);
        saveConfigButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
		updateConfiguration();
            }
        });

        storedConfigButton.setFont(new java.awt.Font("Arial", 0, 12));
        storedConfigButton.setText("Stored Configuration");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 0, 2);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        add(storedConfigButton, gridBagConstraints);

        currentConfigButton.setFont(new java.awt.Font("Arial", 0, 12));
        currentConfigButton.setText("Current Configuration");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.insets = new java.awt.Insets(0, 2, 0, 0);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        add(currentConfigButton, gridBagConstraints);

        buttonGroup1.add(storedConfigButton);
        buttonGroup1.add(currentConfigButton);
        storedConfigButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                getSavedModuleConfig();
                if (savedIP != null) scrollPane.setViewportView(savedIP.treeTable);
		else scrollPane.setViewportView(defaultText);
            }
        });
        currentConfigButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                getCurrentModuleConfig();
                if (currentIP != null) scrollPane.setViewportView(currentIP.treeTable);
		else scrollPane.setViewportView(defaultText);
            }
        });
        storedConfigButton.setSelected(true);
        getSavedModuleConfig();
	if (savedIP != null) scrollPane.setViewportView(savedIP.treeTable);
	else scrollPane.setViewportView(defaultText);        
    }


    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    // End of variables declaration//GEN-END:variables
    private String serialNo;
    private ModuleConfiguration currentModuleConfig;
    private InspectorPanel currentIP;
    private ModuleConfiguration savedModuleConfig;
    private InspectorPanel savedIP;
    private javax.swing.ButtonGroup buttonGroup1;
    private javax.swing.JRadioButton currentConfigButton;
    private javax.swing.JButton saveConfigButton;
    private javax.swing.JScrollPane scrollPane;
    private javax.swing.JRadioButton storedConfigButton;
    private javax.swing.JTextArea defaultText;
    private javax.swing.JLabel title;
}
