package GuiComponents.Inspector;

import GuiComponents.Inspector.TreeTable.*;

class SerializableModel extends AbstractTreeTableModel {
    private StreamableRep rep;
    
    // Names of the columns.
    static protected String[]  cNames = {"Name", "Type", "Value"};

    // Types of the columns.
    static protected Class[]  cTypes = {TreeTableModel.class, String.class, String.class};

    
    SerializableModel(StreamableRep rep) { 
        super(rep);
        this.rep = rep;
    }

    
    //
    // The TreeModel interface
    //

    public int getChildCount(Object node) { 
        return ((StreamableRep)node).getChildCount();
    }

    public Object getChild(Object node, int i) { 
        return ((StreamableRep)node).getChild(i);
    }

    // The superclass's implementation would work, but this is more efficient - also helps with lazy filling of tree. 
    public boolean isLeaf(Object node) { 
        return node instanceof PrimitiveRep;
    }

    //
    //  The TreeTableNode interface. 
    //

    public int getColumnCount() {
        return cNames.length;
    }

    public String getColumnName(int column) {
        return cNames[column];
    }

    public Class getColumnClass(int column) {
        return cTypes[column];
    }
 
    public Object getValueAt(Object node, int column) {
        Rep rep = (Rep)node;
        try {
            switch(column) {
            case 0:                
                return rep.getName();
            case 1:
                return rep.getClassName();
            case 2:
                return rep.getValue();
            }
        }
        catch  (SecurityException se) { }

        return null; 
    }
}