/*
 * InspectorPanel.java
 *
 * Created on 25 April 2003, 18:29
 */

package GuiComponents.Inspector;

import Sct.Serializable;
import GuiComponents.Inspector.TreeTable.JTreeTable;

/**
 *@todo Some sort of resizing bug here.  Hacked around in ISPanel.
 * @author  palmer
 */
public class InspectorPanel extends javax.swing.JPanel {
    String isName;
    Serializable isObj;
    
    /** Creates new form InspectorPanel */
    public InspectorPanel(String name, Serializable ob) {
        initComponents();
        isName = name;
        isObj = ob;
        myInitComponents();
    }
    
    /** Creates new form InspectorPanel, beanable*/
    public InspectorPanel() {
        initComponents();
        isName = "Unnamed";
        isObj = null;
        myInitComponents();
    }

    public static void main(String [] args) {
        javax.swing.JFrame f = new javax.swing.JFrame("Inspector panel test");
        
        f.getContentPane().add(new InspectorPanel());
        f.pack();
        f.setVisible(true);
    }

    /** Creates new form InspectorPanel */
    public void setData(Serializable ob) {
        isObj = ob;
        myInitComponents();
    }

    public void setName(String name) {
        isName = name;
        myInitComponents();
    }

    private void myInitComponents() {
        StreamableRep rep = null;
        if(isObj != null) {
            rep = new StreamableRep(isName, isObj);
        }
        treeTable = new JTreeTable(new SerializableModel(rep));
        spScrollPane.setViewportView(treeTable);
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        spScrollPane = new javax.swing.JScrollPane();

        setLayout(new java.awt.BorderLayout());

        setPreferredSize(new java.awt.Dimension(600, 600));
        add(spScrollPane, java.awt.BorderLayout.CENTER);

    }//GEN-END:initComponents
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JScrollPane spScrollPane;
    // End of variables declaration//GEN-END:variables
    public JTreeTable treeTable;
}
