#include "RootFitStrategy.h"
#include <TH1.h>
#include <TF1.h>
#include <TGraphErrors.h>

using namespace Sct;
namespace SctFitter{
    RootFitStrategy::RootFitStrategy(string opt) throw()
	: FitStrategy(opt), name("RootFitStrategy") {}
    
    RootFitStrategy::~RootFitStrategy() throw() {}

    void RootFitStrategy::fitTH1(const TH1& hist, TF1& fit) const throw(LogicError, MathsError) {
	/// need to do this because ROOT hist.Fit() isn't const!
	TH1& theHist = const_cast<TH1&> (hist);
	theHist.Fit(&fit, getOptions().c_str());
    }

    void RootFitStrategy::fitTGraph(const TGraph& graph, TF1& fit) const throw(LogicError, MathsError) {
	/// need to do this because ROOT graph.Fit() isn't const!
	TGraph& theGraph = const_cast<TGraph&> (graph);
	theGraph.Fit(&fit, getOptions().c_str());
    }

     void RootFitStrategy::fitTGraphErrors(const TGraphErrors& graph, TF1& fit) const throw(LogicError, MathsError) {
	/// need to do this because ROOT graph.Fit() isn't const!
	TGraphErrors& theGraph = const_cast<TGraphErrors&> (graph);
	theGraph.Fit(&fit, getOptions().c_str());
    }

    const string& RootFitStrategy::getName() const throw() {
	return name;
    }
    
    bool RootFitStrategy::inMap=FitStrategyFactory::instance().addToMap("RootFitStrategy", *new RootFitStrategy("") );
    
} // end of namespace SctFitter;
