#ifndef MINUITFITSTRATEGY_H
#define MINUITFITSTRATEGY_H
#include "FitStrategy.h"

using namespace Sct;
namespace SctFitter{
    /**
       This concrete fit strategy uses a link to a fortran function which
       itself uses minuit directly. This should be faster than ROOT.
       @author Alan Barr
       @date 17/5/03
     */

    class MinuitFitStrategy : public FitStrategy {
    public:
	/// constuctor
	MinuitFitStrategy(string opt=string("")) throw();
	/// destructor
	~MinuitFitStrategy() throw();
	/// fit TH1 using current options 
	virtual void fitTH1(const TH1& hist, TF1& fit) const throw(LogicError, MathsError);
	
	/// fit TGraph using current options
	virtual void fitTGraph(const TGraph& graph, TF1& fit) const throw(LogicError, MathsError);

	/// fit TGraphErrors using current options
	virtual void fitTGraphErrors(const TGraphErrors& graph, TF1& fit) const throw(LogicError, MathsError);
	
	/// return name of the strategy
	virtual const string& getName() const throw();
    private:
	MinuitFitStrategy( const MinuitFitStrategy& ); ///< no copy constructor
	const string name;  ///< the name of the strategy.
	static bool inMap; ///< dummy variable used at static initialization.
    };
    
} // end of namespace SctFitter;
#endif // #ifndef MINUITFITSTRATEGY_H
