#include "MinuitFitStrategy.h"
#include "Sct/UnsupportedOperationError.h"
#include <TH1.h>
#include <TGraphErrors.h>

using namespace Sct;
namespace SctFitter{
   MinuitFitStrategy::MinuitFitStrategy(string opt) throw()
	: FitStrategy(opt), name("MinuitFitStrategy") {}
    
    MinuitFitStrategy::~MinuitFitStrategy() throw() {}

    void MinuitFitStrategy::fitTH1(const TH1& hist, TF1& fit) const throw(LogicError, MathsError) {
	/// need to do this because ROOT hist.Fit() isn't const!
	TH1& theHist = const_cast<TH1&> (hist);
	
	/// @todo implement
	throw UnsupportedOperationError("MinuitFitStrategy not yet implimented!", __FILE__, __LINE__);
    }

    void MinuitFitStrategy::fitTGraph(const TGraph& graph, TF1& fit) const throw(LogicError, MathsError) {
	/// need to do this because ROOT graph.Fit() isn't const!
	TGraph& theGraph = const_cast<TGraph&> (graph);
	
	/// @todo implement
	throw UnsupportedOperationError("MinuitFitStrategy not yet implimented!", __FILE__, __LINE__);
    }

    void MinuitFitStrategy::fitTGraphErrors(const TGraphErrors& graph, TF1& fit) const throw(LogicError, MathsError) {
	/// need to do this because ROOT graph.Fit() isn't const!
	TGraphErrors& theGraph = const_cast<TGraphErrors&> (graph);
	
	/// @todo implement
	throw UnsupportedOperationError("MinuitFitStrategy not yet implimented!", __FILE__, __LINE__);
    }

    const string& MinuitFitStrategy::getName() const throw() {
	return name;
    }
    
    bool MinuitFitStrategy::inMap=FitStrategyFactory::instance().addToMap("MinuitFitStrategy", *new MinuitFitStrategy("") );

}  // end of namespace SctFitter;
