#ifndef THRESHOLDFITALGORITHM2_H
#define THRESHOLDFITALGORITHM2_H

#include "FitAlgorithm.h"

namespace SctFitter {
 
class ThresholdFitAlgorithm2 : FitAlgorithm {
public:        
    static bool putInMap() throw();
    static bool isInMap() {return inMap;}
    
    virtual void doFit(const TH1& hist, FitObject& fitObject,
		       const ModuleElement& element, 
		       DefectList& defects) const throw (LogicError);
    
    virtual auto_ptr<FitObject> getPrototype() const throw();
    
    virtual void guessParameters(const TH1& hist, FitObject& fitOb) const throw (LogicError, MathsError);
    virtual void checkForDefects(const TH1& hist, const ModuleElement& element, 
				 DefectList& defects) const throw (LogicError);
    virtual void createSummaryHistograms(FitScanResult& fits) const throw();
    virtual void checkForDefects(const FitObject& hist, const ModuleElement& element, 
				 DefectList& defects) const;
private:
    ThresholdFitAlgorithm2() throw();
    static bool inMap;
};

}

#endif //THRESHOLDFITALGORITHM2_H

