#ifndef FITTERWORKERGROUP_H
#define FITTERWORKERGROUP_H
#include "SctService/WorkerGroup.h"
#include <string>
#include <boost/shared_ptr.hpp>

using std::string;
using boost::shared_ptr;
using namespace SctService;

namespace SctFitter {

/**
   Represents a group of worker threads which does the fitting.
   The fitting is done in the work() method.
 */
class FitterWorkerGroup : public WorkerGroup<string> {
public:
    /// initialise the number of calls and waits to 0;
    FitterWorkerGroup() : m_calls(0) {}

    /// destructor
    virtual ~FitterWorkerGroup() {}

private:
    /**
       Does the fitting. First gets the appropriate FitAlgorithm,
       then does the fit, then publishes the result.
       Handles its own exceptions, sending messages to MRS.
    */
    virtual void work(string name) throw() ;
    int m_calls; ///< number of times this worker has been called to work.
};

}// end of namespace SctFitter

#endif // #define FITTERWORKERGROUP_H
