#ifndef FitterMode_H
#define FitterMode_H

#include <iostream>

namespace SctFitter{
  /**
   * Describes the way in which the fitter is acting.
   * @author Alan Barr
   * @date
   */
  class FitterMode{
  public:
    FitterMode() throw() ;
    ~FitterMode() throw() {;}
    void fitChannels(bool b=true) throw() ;
    void fitLinks(bool b=true) throw() ;
    void fitChips(bool b=true) throw() ;
    void doSummary(bool b=true) throw() ;
    /**
     * Default is that only chips are fitted.
     */
    void fitDefault() throw() ;
    /**
     * Do everything: chips, strips and links.
     */
    void fitAll() throw() ;
    
    /**
     * Do no fits at all!
     */
    void fitNone() throw() ;
    bool fittingChannels() const throw() ;
    bool fittingChips() const throw() ;
    bool fittingLinks() const throw() ;
    bool doingSummary() const throw() ;
    /**
     * Can be sent to an ostream.
     */
  private:
    bool strip, link, chip, summary;
  };
}



#endif

