#include "FitterMode.h"

#include <iostream>

using namespace std;

SctFitter::FitterMode::FitterMode() throw() {
  this->fitDefault();
}

void SctFitter::FitterMode::fitChannels(bool b) throw() {
  strip=b;
}
void SctFitter::FitterMode::fitLinks(bool b) throw() {
  link=b;
}
void SctFitter::FitterMode::fitChips(bool b) throw() {
  chip=b;
}
void SctFitter::FitterMode::doSummary(bool b) throw() {
  summary=b;
}
void SctFitter::FitterMode::fitAll() throw() {
  fitChannels(); fitChips(); fitLinks(); doSummary();
}
bool SctFitter::FitterMode::fittingChannels() const throw() {
  return strip;
}
bool SctFitter::FitterMode::fittingLinks() const throw() {
  return link;
}
bool SctFitter::FitterMode::fittingChips() const throw() {
  return chip;
}
bool SctFitter::FitterMode::doingSummary() const throw() {
  return summary;
}
void SctFitter::FitterMode::fitDefault() throw() {
  fitChips(true);  fitChannels(false);  fitLinks(false); doSummary(true);
}
void SctFitter::FitterMode::fitNone() throw() {
  fitChips(false); fitChannels(false); fitLinks(false); doSummary(false);
}

/*void SctFitter::FitterMode::setFrom(ScanType s) throw() {
  if (s==ScanType::THRESHOLDSCAN) { fitNone(); fitChips(); fitChannels() ; doSummary(false); return; }
  if (s==ScanType::STROBEDELAYSCAN) { fitNone() ; fitChips() ; doSummary(false) ; return; }
}*/

ostream& operator << (ostream& os, SctFitter::FitterMode& fm) throw() {
  os << "Links: " << fm.fittingLinks() 
     << ", Chips: " << fm.fittingChips()
     << ", Channels: " << fm.fittingChannels()
     << ", Summary: "<< fm.doingSummary();
  return os;
}
