#ifndef TRIMRANGETEST_H
#define TRIMRANGETEST_H

#include "../ipc/TestRequest.h"
#include "../ipc/CalibrationController.h"
#include "../ipc/ScanLibrary.h"
#include "../ipc/Sct_CalibrationController.hh"
#include "../CalibrationControllerImpl.h"

#include "../SctApiAccessException.h"
#include "Sct/LogicErrors.h"
#include "../SctApiCall.h"

#include <CommonWithDsp/ABCD/ABCDscans.h>
#include <iostream>
#include <vector>

using namespace std;
using namespace SctCalibrationController::Ipc;
using namespace SctCalibrationController;
using namespace Sct;

namespace SctCalibrationController {
namespace Scripts {
    
class TrimRangeTest : public TestRequestImpl {
public:	
    static TrimRangeTest& instance() {
	static TrimRangeTest tr;
	return tr;
    }
    
    virtual void startTest(Sct_SctApi_T_SctApi& inapi, string& name, unsigned short& testVariable, unsigned long& nScans, vector<double>& testPoints) {	
	this->api = &inapi;

        // Compression mode X1X
        APICALL(api, modifyABCDVar(&st, ST_COMPRESSION, 1), "TrimRangeTest::startTest can't set compression")

        // Edge detect off
        APICALL(api, modifyABCDVar(&st, ST_EDGE_DETECT, 0), "TrimRangeTest::startTest can't set edge detect")

        // No masked channels
        APICALL(api, modifyABCDVar(&st, ST_SEND_MASK, 0), "TrimRangeTest::startTest can't set send mask")

        // QCAL (fC)
        APICALL(api, modifyABCDVar(&st, ST_QCAL, 1), "TrimRangeTest::startTest can't set qcal")

	name = "TrimRangeTest";
	testVariable=ST_TRIM_RANGE;
	for (unsigned int i=0; i<28; ++i) {
	    testPoints.push_back(getValue(i));
	}
	nScans = testPoints.size();
    }

    virtual ScanRequest* getNextScan(unsigned long index) {
	if (isFirstPoint(index)) {
            // set trim range
	    APICALL(api, modifyABCDVar(&st, ST_TRIM_RANGE, getRange(index)), "TrimRangeTest::getNextScan")
	}
        // set trim value
	APICALL(api, modifyABCDVar(&st, ST_TRIM, getValue(index)), "TrimRangeTest::getNextScan")

	ScanLibrary& sl = CalibrationControllerImpl::instance().getScanLibrary();
	double offset = ranges[getRange(index)] * getValue(index);
	return &sl.thresholdScanfCOffset(400, 1.0, offset);  // trim at 1 fC, but give it an offset
    }

    unsigned int getRange(unsigned int index) {
	if (index<16) return 0;
	else return (index-16)/4+1;
    }
    
    bool isFirstPoint(unsigned int index) {
	return (index-16)%4 == 0;
    }
    
    unsigned int getValue(unsigned int index) {
	if (index < 16) return index;
	unsigned int pointInRange = (index-16)%4;
	return (pointInRange+1)*4-1;
    }
    
    virtual bool canFeedback() {
	return true;
    }    

    virtual void endTest() {
	api = 0;
    }
        
private:
    TrimRangeTest() {}
    Sct_SctApi_T_SctApi* api;
    static double ranges[4];
};
double TrimRangeTest::ranges[4] = {3.5, 6.5, 10, 13};
}
}
#endif //TRIMRANGETEST_H
