#ifndef THRESHOLDSCAN_H
#define THRESHOLDSCAN_H

#include <cmath>  // For fabs

#include "../ipc/Sct_CalibrationController.hh"
#include "../CalibrationControllerImpl.h"
#include "../ipc/ScanRequest.h"
#include "../SctApiAccessException.h"
#include "../SctApiCall.h"
#include "Sct/LogicErrors.h"

#include <CommonWithDsp/ABCD/ABCDscans.h>

using namespace Sct;
using namespace SctCalibrationController::Ipc;
namespace SctCalibrationController {
namespace Scripts {
    
class ThresholdScan  : public ScanRequestImpl {
public:
    static ScanRequestImpl& thresholdScan(unsigned long nTrigs, double calChargefC = -1, double offset=0) {
      static ThresholdScan request;
      Sct_SctApi_T_SctApi* api = CalibrationControllerImpl::instance().getApi();
      Sct_SctApi_T_Scan* s = 0;
      APIRETCALL(api, s, createScan(&st), "Failed to create scan")

	request.setScan(s);

        APICALL(s, setNTrigs(&st, nTrigs), "Failed to set triggers")
	
        Sct_SctApi_T_Trigger* t = 0;
      APIRETCALL(s, t, getTrigger1(&st), "Failed to get Trigger1")
	
        APICALL(t, calL1A(&st, 0x82), "Failed to set trigger type")

        if (fabs(calChargefC) > 0.05) {
            APICALL(s, setOption(&st, Sct_SctApi_T_Scan_ScanOptions_loopCalLine, 1), "Failed to set loopCalLine")
        }

	double lo = 40.0 * calChargefC + offset/2.;
	double hi = 150.0 + 70.0 * calChargefC + offset;

	//Only set to lowLimit if we have some cal charge!
	if ((calChargefC > 0 && lo < lowLimit) || calChargefC < 0) lo = lowLimit;
	else if (lo < 0) lo = 0;
	if (hi > highLimit || calChargefC < 0) hi = highLimit;
        if (hi < lo) hi = lo + 100;
	
        APICALL(s, configure(&st, ST_VTHR, lo, hi, 5), "Failed to set Scan information")

	return request;
    }
    
private:
    ThresholdScan(){;}	
    
    static const double lowLimit = 0;
    static const double highLimit = 633;
};
    
}
}

#endif //THRESHOLDSCAN_H
