#ifndef STROBEDELAYSCAN_H
#define STROBEDELAYSCAN_H

#include "../ipc/Sct_CalibrationController.hh"
#include "../CalibrationControllerImpl.h"
#include "../SctApiAccessException.h"
#include "Sct/LogicErrors.h"

#include <CommonWithDsp/ABCD/ABCDscans.h>

using namespace Sct;
using namespace SctCalibrationController::Ipc;
namespace SctCalibrationController {
namespace Scripts {
    
class StrobeDelayScan : public ScanRequestImpl {
public:
    static ScanRequestImpl& strobeDelayScan(unsigned long nTrigs) {
      static StrobeDelayScan request;
      Sct_SctApi_T_SctApi* api = CalibrationControllerImpl::instance().getApi();
      Sct_SctApi_T_Scan* s = 0;
      APIRETCALL(api, s, createScan(&st), "Failed to create scan")
	request.setScan(s);
	
       APICALL(s, setNTrigs(&st, nTrigs), "Failed to set triggers")

        Sct_SctApi_T_Trigger* t = 0;
        APIRETCALL(s, t, getTrigger1(&st), "Failed to get Trigger1")

        APICALL(t, calL1A(&st, 0x82), "Failed to set trigger type")

        APICALL(s, setOption(&st, Sct_SctApi_T_Scan_ScanOptions_loopCalLine, 1), "Failed to set loopCalLine")

        APICALL(s, configure(&st, ST_STROBE_DELAY, 0, 63, 1), "Failed to set Scan information")

        return request;
    }
    
private:
    StrobeDelayScan(){;}
};
    
}
}

#endif //STROBEDELAYSCAN_H
