#ifndef RESPONSECURVE_H
#define RESPONSECURVE_H

#include "../ipc/TestRequest.h"
#include "../ipc/CalibrationController.h"
#include "../ipc/ScanLibrary.h"
#include "../ipc/Sct_CalibrationController.hh"
#include "../CalibrationControllerImpl.h"

#include "../SctApiAccessException.h"
#include "Sct/LogicErrors.h"
#include "../SctApiCall.h"

#include <CommonWithDsp/ABCD/ABCDscans.h>
#include <iostream>
#include <vector>

using namespace Sct;
using namespace std;
using namespace SctCalibrationController::Ipc;
using namespace SctCalibrationController;

namespace SctCalibrationController {
namespace Scripts {
    
class ResponseCurve : public TestRequestImpl {
public:	
    static ResponseCurve& instance() {
	static ResponseCurve rc;
	return rc;
    }
    
    virtual void startTest(Sct_SctApi_T_SctApi& api, string& name, unsigned short& testVariable, unsigned long& nScans, vector<double>& testPoints) {	
	this->api = &api;

        // Compression mode X1X
        APICALL(&api, modifyABCDVar(&st, ST_COMPRESSION, 1), "ResponseCurve::startTest")

        // Edge detect off
        APICALL(&api, modifyABCDVar(&st, ST_EDGE_DETECT, 0), "ResponseCurve::startTest")

        // No masked channels
        APICALL(&api, modifyABCDVar(&st, ST_SEND_MASK, 0), "ResponseCurve::startTest")

	name = "NPtGainTest";
	testVariable = ST_QCAL;

	charges.push_back(0.5);
	charges.push_back(0.75);
	charges.push_back(1.0);
	charges.push_back(1.25);
	charges.push_back(1.5);
	charges.push_back(2.);
	charges.push_back(3);
	charges.push_back(4);
	charges.push_back(6);
	charges.push_back(8);

	testPoints = charges;
	nScans = testPoints.size();
    }

    virtual ScanRequest* getNextScan(unsigned long index) {
	ScanLibrary& sl = CalibrationControllerImpl::instance().getScanLibrary();

	APICALL(api, modifyABCDVar(&st, ST_QCAL, charges[index]), "ResponseCurve::getNextScan")

	return &sl.thresholdScanfC(1000, charges[index]);
    }

    virtual bool canFeedback() {
	return true;
    }

    virtual void endTest() {
	api = 0;
	charges.clear();
    }


private:
    ResponseCurve() {}
    Sct_SctApi_T_SctApi* api;
    vector<double> charges;
};
}
}
#endif //RESPONSECURVE_H
