#ifndef SCTCALIBRATIONCONTROLLER_RAWSCAN_H
#define SCTCALIBRATIONCONTROLLER_RAWSCAN_H

#include "../ipc/Sct_CalibrationController.hh"
#include "../CalibrationControllerImpl.h"
#include "../SctApiAccessException.h"
#include "../SctApiCall.h"
#include "Sct/LogicErrors.h"

#include <CommonWithDsp/ABCD/ABCDscans.h>

using namespace Sct;
using namespace SctCalibrationController::Ipc;
namespace SctCalibrationController {
namespace Scripts {
    
class RawScan : public ScanRequestImpl {
public:
  static ScanRequestImpl& rawScan(unsigned long nTrigs) {
    static RawScan request;
    Sct_SctApi_T_SctApi* api = CalibrationControllerImpl::instance().getApi();
    Sct_SctApi_T_Scan* s=0;
    APIRETCALL(api, s, createScan(&st), "Failed to create scan")
    request.setScan(s);
    
    APICALL(s, setNTrigs(&st, nTrigs), "Failed to set triggers")
    request.setClockByTwo(false);
	    
    Sct_SctApi_T_Trigger* t = 0;
    APIRETCALL(s, t, getTrigger1(&st), "Failed to get Trigger1")

    APICALL(s, configure(&st, 1, 0, 2, 1), "Failed to set Scan information")

    APICALL(t, singleL1A(&st), "Failed to set trigger type")

    return request;
    }

  virtual ilu_Boolean isRaw(){ 
    return true;
  }

  virtual long delay(){
    return 1;
  }

  virtual ilu_Boolean configureModules(){
    return true;
  }

private:
  RawScan(){;}
};
    
}
}

#endif //SCTCALIBRATIONCONTROLLER_RAWSCAN_H
